/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ACPIInfo;
import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIGlobalCommand;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMITimeoutException;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.RMCPPlus;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class IPMIX9BIOSOEMCommand
extends IPMICommand {
    MOut mout = MOut.G();
    public static boolean retryTempFlag = false;

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMIX9BIOSOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void X9_BIOS_UPDATE_CMD____________() {
    }

    public IPMIMessage getBIOSInfoCommand(byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[size.length];
        System.arraycopy(size, 0, data, 0, size.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)96, data);
        double udpTimeout = ((RMCPPlus)this.ipmiInterface).getUDPSocketTimeout();
        ((RMCPPlus)this.ipmiInterface).setUDPSocketTimeout(30.0);
        retryTempFlag = true;
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        retryTempFlag = false;
        ((RMCPPlus)this.ipmiInterface).setUDPSocketTimeout(udpTimeout);
        return resMessage;
    }

    public IPMIMessage startBIOSUpgradeCommand(byte[] imageSize) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[imageSize.length];
        System.arraycopy(imageSize, 0, data, 0, imageSize.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)97, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage uploadBIOSCommand(byte[] reservationID, byte[] offset, byte[] chunk) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + offset.length + chunk.length];
        int index = 0;
        System.arraycopy(reservationID, 0, data, index, reservationID.length);
        index = reservationID.length;
        System.arraycopy(offset, 0, data, index, offset.length);
        System.arraycopy(chunk, 0, data, index += offset.length, chunk.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)98, data);
        IPMIMessage resMessage = ((RMCPPlus)this.ipmiInterface).sendNoSync(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage flashBIOSCommand(byte[] reservationID, byte[] flag) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[reservationID.length + flag.length];
        data[0] = reservationID[0];
        data[1] = reservationID[1];
        data[2] = flag[0];
        data[3] = flag[1];
        data[4] = flag[2];
        data[5] = flag[3];
        ipmiMessage.setCommandAndData((byte)-64, (byte)99, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage cancelBIOSUpgradeCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)100, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage finalizeBIOSUpgradeCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)101, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSUpdateProgressCommand(byte[] reservationID) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{reservationID[0], reservationID[1]};
        ipmiMessage.setCommandAndData((byte)-64, (byte)102, data);
        double udpTimeout = ((RMCPPlus)this.ipmiInterface).getUDPSocketTimeout();
        ((RMCPPlus)this.ipmiInterface).setUDPSocketTimeout(7.0);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        ((RMCPPlus)this.ipmiInterface).setUDPSocketTimeout(udpTimeout);
        return resMessage;
    }

    public IPMIMessage biosUpdatePrepareCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)103, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage biosUpdatePrepareDoneCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)104, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage biosSetProductKeyCommand(byte[] productKey) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[12];
        System.arraycopy(productKey, 0, data, 0, 12);
        ipmiMessage.setCommandAndData((byte)-64, (byte)105, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBIOSOOBCapabilityCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, 0};
        ipmiMessage.setCommandAndData((byte)-64, (byte)-96, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage checkProductKey() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{};
        ipmiMessage.setCommandAndData((byte)-64, (byte)106, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void X9_BIOS_UPDATE_API____________() {
    }

    public BIOSInfo getBIOSInfo(int size) throws Exception {
        byte[] imageSizeByteArray = new byte[4];
        ByteUtility.intTo4Bytes(imageSizeByteArray, 0, size);
        IPMIMessage resMessage = this.getBIOSInfoCommand(imageSizeByteArray);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                BIOSInfo biosInfo = new BIOSInfo();
                try {
                    biosInfo.fromRawToGetBIOSInfo(resMessage.data);
                }
                catch (Exception ex) {
                    this.mout.println("Value =" + new String(resMessage.data));
                    throw new IPMIException(resMessage, "BIOS info parsing error");
                }
                return biosInfo;
            }
            throw this.ccode2Exception(resMessage);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nNetwork connect failed after retry connect");
        sb.append("\nCan't connect to " + ((RMCPPlus)this.ipmiInterface).config.getIp());
        throw new IPMITimeoutException(sb.toString());
    }

    public Reservation startBIOSUpgrade(int imageSize) throws IPMIException {
        byte[] imageSizeByteArray = new byte[4];
        ByteUtility.intTo4Bytes(imageSizeByteArray, 0, imageSize);
        IPMIMessage resMessage = this.startBIOSUpgradeCommand(imageSizeByteArray);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                Reservation r = new Reservation();
                System.arraycopy(resMessage.data, 0, r.id, 0, 2);
                System.arraycopy(resMessage.data, 2, r.maxChunkSize, 0, 4);
                return r;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call startBIOSUpgradeCommand failed");
    }

    public void uploadBIOS(byte[] reservationID, byte[] offset, byte[] chunk) throws Exception {
        IPMIMessage resMessage = this.uploadBIOSCommand(reservationID, offset, chunk);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            this.mout.println("completion code = " + ByteUtility.byteToHex(resMessage.completionCode));
            throw this.ccode2Exception(resMessage);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nNetwork connect failed after retry connect");
        sb.append("\nCan't connect to " + ((RMCPPlus)this.ipmiInterface).config.getIp());
        throw new IPMITimeoutException(sb.toString());
    }

    public void flashBIOS(byte[] reservationID, int optionFlag) throws Exception {
        byte[] flagByteArray = new byte[4];
        ByteUtility.intTo4Bytes(flagByteArray, 0, optionFlag);
        IPMIMessage resMessage = this.flashBIOSCommand(reservationID, flagByteArray);
        if (resMessage != null) {
            String errorMessage;
            if (resMessage.completionCode == 0) {
                return;
            }
            switch (resMessage.completionCode) {
                case -128: {
                    errorMessage = "upload incomplete";
                    break;
                }
                case -127: {
                    errorMessage = "bad CRC";
                    break;
                }
                case -126: {
                    errorMessage = "firmware invalid";
                    break;
                }
                case -124: {
                    errorMessage = "upgrade failed";
                    break;
                }
                default: {
                    throw this.ccode2Exception(resMessage);
                }
            }
            throw new IPMIException(errorMessage);
        }
        throw new IPMIException(resMessage, "Call flashBIOSCommand failed");
    }

    public void cancelBIOSUpgrade(byte[] reservationID) throws Exception {
        IPMIMessage resMessage = this.cancelBIOSUpgradeCommand(reservationID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            this.mout.println(ByteUtility.byteToHex(resMessage.completionCode));
            throw this.ccode2Exception(resMessage);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nNetwork connect failed after retry connect");
        sb.append("\nCan't connect to " + ((RMCPPlus)this.ipmiInterface).config.getIp());
        throw new IPMITimeoutException(sb.toString());
    }

    public boolean checkIfSupportBIOSUpdate() throws IPMIException {
        byte[] empty = new byte[]{0, 0};
        IPMIMessage resMessage = this.cancelBIOSUpgradeCommand(empty);
        if (resMessage != null) {
            return resMessage.completionCode == 0 || resMessage.completionCode == -59 || resMessage.completionCode == -43;
        }
        return false;
    }

    public boolean checkIfProductNotActivated() throws IPMIException {
        IPMIMessage resMessage = this.checkProductKey();
        if (resMessage != null && resMessage.completionCode == 0) {
            return resMessage.data[0] != 1;
        }
        return true;
    }

    public void finalizeBIOSUpgrade(byte[] reservationID) throws Exception {
        IPMIMessage resMessage = this.finalizeBIOSUpgradeCommand(reservationID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call finalizeBIOSUpgradeCommand failed");
    }

    public byte getBIOSUpdateProgress(byte[] reservationID) throws Exception {
        IPMIMessage resMessage = this.getBIOSUpdateProgressCommand(reservationID);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0];
            }
            throw this.ccode2Exception(resMessage);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\nNetwork connect failed after retry connect");
        sb.append("\nCan't connect to " + ((RMCPPlus)this.ipmiInterface).config.getIp());
        throw new IPMITimeoutException(resMessage, sb.toString());
    }

    public void biosUpdatePrepare() throws Exception {
        IPMIMessage resMessage = this.biosUpdatePrepareCommand();
        if (resMessage != null) {
            int cCode = resMessage.completionCode & 0xFF;
            if (resMessage.completionCode == 0) {
                return;
            }
            if (cCode == 255) {
                this.mout.println("\nPlease wait a few minutes, other users is updating.");
            } else {
                throw this.ccode2Exception(resMessage);
            }
        }
        throw new IPMIException(resMessage, "Call BIOSUpdatePrepare failed");
    }

    public boolean biosUpdatePrepareDone() throws Exception {
        IPMIMessage resMessage = this.biosUpdatePrepareDoneCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data[0] == 1;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call BIOSUpdatePrepare failed");
    }

    public boolean biosSetProductKey(byte[] productKey) throws Exception {
        IPMIMessage resMessage = this.biosSetProductKeyCommand(productKey);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                if (resMessage.data[0] == 0) {
                    return true;
                }
                if (resMessage.data[0] == 1) {
                    return false;
                }
            } else {
                throw this.ccode2Exception(resMessage);
            }
        }
        throw new IPMIException(resMessage, "Call BIOSUpdatePrepare failed");
    }

    public boolean ifMultiSessionUploadSupported() throws Exception {
        IPMIMessage resMessage = this.getBIOSOOBCapabilityCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return (resMessage.data[0] & 4) == 4;
            }
            throw this.ccode2Exception(resMessage);
        }
        throw new IPMIException(resMessage, "Call getBIOSOOBCapabilityCommand failed");
    }

    private void API____________() {
    }

    public boolean flashBIOS(int chunkSizeParam, int optionFlag, String firmwareFilename) throws Exception {
        byte[] chunk;
        int chunkSize = 0;
        int totalRead = 0;
        int readCount = 0;
        File firmware = new File(firmwareFilename);
        long start = System.currentTimeMillis();
        long firstStart = System.currentTimeMillis();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.getIPMIInterface());
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.getIPMIInterface());
        IPMIBMCFileCommand powerStatusInfo = new IPMIBMCFileCommand(this.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (powerStatusInfo.getPowerStatus() == 1 && IPMIMessagingCommand.isAMIX9GUID(guid)) {
            int count = 0;
            this.mout.print("System is On. Preparing BIOS update procedure ...");
            this.biosUpdatePrepare();
            while (!this.biosUpdatePrepareDone()) {
                if (count++ == 30) {
                    throw new Exception("BIOS prepare timeout ");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.mout.print(".");
            }
            this.mout.println("Done");
        }
        this.mout.println("===============");
        this.mout.println("BIOS Image info");
        this.mout.println("===============");
        BIOSInfo biosFileInfo = this.checkBIOSImage(firmwareFilename);
        if (biosFileInfo == null) {
            throw new Exception("BIOS File invalid");
        }
        this.mout.println(biosFileInfo.toStringFromBIOSImage());
        byte[] boardIDfromBMC = ipmiOEMCommand.getProductID();
        if (boardIDfromBMC[0] != biosFileInfo.boardID[0] || boardIDfromBMC[1] != biosFileInfo.boardID[1]) {
            String fileBIOSID = ByteUtility.bytesToHex(biosFileInfo.boardID);
            String bmcBIOSID = ByteUtility.bytesToHex(boardIDfromBMC);
            throw new Exception("BIOS File invalid (Board ID mismatch. (" + fileBIOSID + ")(" + bmcBIOSID + "))");
        }
        this.mout.println("");
        this.mout.println("=============");
        this.mout.println("BIOS ROM info");
        this.mout.println("=============");
        start = System.currentTimeMillis();
        BIOSInfo biosInfo = null;
        try {
            biosInfo = this.getBIOSInfo((int)biosFileInfo.fileSize);
            this.mout.println(biosInfo.toStringFromBMC());
        }
        catch (IPMIException ex) {
            throw new Exception("Get BIOS Info failed (" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        catch (Exception ex) {
            // empty catch block
        }
        start = System.currentTimeMillis();
        long fileSize = firmware.length();
        Reservation reservation = null;
        try {
            reservation = this.startBIOSUpgrade((int)fileSize);
            chunkSize = chunkSizeParam;
            chunk = new byte[chunkSize];
        }
        catch (IPMIException ex) {
            throw new Exception("Start BIOS upgrade error(" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
        }
        this.mout.println("");
        this.mout.println("====================");
        this.mout.println("Uploading BIOS image");
        this.mout.println("====================");
        this.mout.print("Progress:|");
        start = System.currentTimeMillis();
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        int currentProgress = 0;
        int lastProgress = 0;
        while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
            byte[] currentChunk = new byte[4];
            ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
            if (readCount != chunkSize) {
                byte[] lastChunk = new byte[readCount];
                System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                chunk = lastChunk;
            }
            try {
                this.uploadBIOS(reservation.id, currentChunk, chunk);
            }
            catch (IPMITimeoutException ex) {
                throw ex;
            }
            catch (IPMIException ex1) {
                this.cancelBIOSUpgrade(reservation.id);
                throw new Exception("Upload firmware error. location = " + totalRead + "(" + ByteUtility.byteToHex(ex1.getIPMIMessage().completionCode) + "h)");
            }
            currentProgress = (int)((long)((totalRead += readCount) * 100) / firmware.length());
            if (currentProgress <= lastProgress) continue;
            if (currentProgress % 2 == 0) {
                this.mout.print(">");
            }
            lastProgress = currentProgress;
        }
        this.mout.println("| 100%");
        this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        this.mout.println("");
        this.mout.println("=============");
        this.mout.println("Updating BIOS");
        this.mout.println("=============");
        this.mout.print("Progress:|");
        start = System.currentTimeMillis();
        try {
            this.flashBIOS(reservation.id, optionFlag);
        }
        catch (Exception ex) {
            this.cancelBIOSUpgrade(reservation.id);
            throw new Exception(ex.getMessage());
        }
        int progIndex = 0;
        int count = 0;
        while (progIndex != 100) {
            try {
                progIndex = this.getBIOSUpdateProgress(reservation.id);
            }
            catch (IPMITimeoutException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.cancelBIOSUpgrade(reservation.id);
                throw new Exception(ex.getMessage());
            }
            if (progIndex > count) {
                for (int i2 = 0; i2 < progIndex - count; ++i2) {
                    if ((i2 + count) % 2 != 0) continue;
                    this.mout.print(">");
                }
                count = progIndex;
            }
            Thread.sleep(1000L);
        }
        this.mout.println("| 100%");
        this.printTimeString("Update Time", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        try {
            this.finalizeBIOSUpgrade(reservation.id);
        }
        catch (Exception ex) {
            this.cancelBIOSUpgrade(reservation.id);
            throw new Exception(ex.getMessage());
        }
        this.mout.println("Done");
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        return true;
    }

    public boolean isX9Q() {
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.getIPMIInterface());
        byte[] boardIDfromBMC = ipmiOEMCommand.getProductID();
        if (boardIDfromBMC != null) {
            if (boardIDfromBMC[0] == 7 && boardIDfromBMC[1] == 7) {
                return true;
            }
            if (boardIDfromBMC[0] == 15 && boardIDfromBMC[1] == 7) {
                return true;
            }
        }
        return false;
    }

    public boolean flashBIOSNew(int chunkSizeParam, int optionFlag, String firmwareFilename, int sessions, boolean reboot) throws Exception {
        byte[] chunk;
        BIOSInfo biosFileInfo;
        int chunkSize = 0;
        int totalRead = 0;
        int readCount = 0;
        File firmware = new File(firmwareFilename);
        long start = System.currentTimeMillis();
        long firstStart = System.currentTimeMillis();
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.getIPMIInterface());
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(this.getIPMIInterface());
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.getIPMIInterface());
        IPMIBMCFileCommand powerStatusInfo = new IPMIBMCFileCommand(this.getIPMIInterface());
        byte[] guid = ipmiMessagingCommand.getSystemGUID();
        if (powerStatusInfo.getPowerStatus() == 1 && IPMIMessagingCommand.isAMIX9GUID(guid)) {
            int count = 0;
            this.mout.print("System is On. Preparing BIOS update procedure ...");
            try {
                this.biosUpdatePrepare();
            }
            catch (IPMIException ex) {
                return false;
            }
            while (!this.biosUpdatePrepareDone()) {
                if (count++ == 120) {
                    throw new Exception("BIOS prepare timeout ");
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.mout.print(".");
            }
            this.mout.println("Done");
        }
        this.mout.println("===============");
        this.mout.println("BIOS Image info");
        this.mout.println("===============");
        try {
            biosFileInfo = this.checkBIOSImage(firmwareFilename, this.isX9Q());
        }
        catch (Exception ex) {
            this.mout.println("BIOS File invalid");
            return false;
        }
        if (biosFileInfo == null) {
            this.mout.println("BIOS File invalid");
            return false;
        }
        this.mout.println(biosFileInfo.toStringFromBIOSImage());
        byte[] boardIDfromBMC = ipmiOEMCommand.getProductID();
        if (boardIDfromBMC[0] != biosFileInfo.boardID[0] || boardIDfromBMC[1] != biosFileInfo.boardID[1]) {
            String fileBIOSID = ByteUtility.bytesToHex(biosFileInfo.boardID);
            String bmcBIOSID = ByteUtility.bytesToHex(boardIDfromBMC);
            throw new IPMIException("BIOS File invalid (Board ID mismatch. (" + fileBIOSID + ")(" + bmcBIOSID + "))");
        }
        this.mout.println("");
        this.mout.println("=============");
        this.mout.println("BIOS ROM info");
        this.mout.println("=============");
        start = System.currentTimeMillis();
        BIOSInfo biosInfo = null;
        try {
            biosInfo = this.getBIOSInfo((int)biosFileInfo.fileSize);
            this.mout.println(biosInfo.toStringFromBMC());
        }
        catch (IPMITimeoutException ex) {
            throw ex;
        }
        catch (IPMIException ex) {
            this.mout.println("Please wait a few minutes, other users is updating.");
            return false;
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        start = System.currentTimeMillis();
        long fileSize = firmware.length();
        Reservation reservation = null;
        try {
            reservation = this.startBIOSUpgrade((int)fileSize);
            chunkSize = chunkSizeParam;
            chunk = new byte[chunkSize];
        }
        catch (IPMIException ex) {
            this.mout.println("Previous BIOS update still in progress, please wait for few minutes before retrying. (" + ByteUtility.byteToHex(ex.getIPMIMessage().completionCode) + "h)");
            return false;
        }
        this.mout.println("");
        this.mout.println("====================");
        this.mout.println("Uploading BIOS image");
        this.mout.println("====================");
        if (sessions > 1) {
            MultiSessionSize sessionSize = MultiSessionSize.SESSION_1;
            sessionSize = sessions == 2 ? MultiSessionSize.SESSION_2 : (sessions == 4 ? MultiSessionSize.SESSION_4 : (sessions == 8 ? MultiSessionSize.SESSION_8 : (sessions == 16 ? MultiSessionSize.SESSION_16 : (sessions == 32 ? MultiSessionSize.SESSION_32 : MultiSessionSize.SESSION_1))));
            IPMIInterfaceConfig ipmiInterfaceConfig = ((RMCPPlus)this.ipmiInterface).config;
            MultiSessionTaskManager mSessionTaskManager = new MultiSessionTaskManager(sessionSize, firmwareFilename, 1024, reservation.id, ipmiInterfaceConfig);
            mSessionTaskManager.multiSessionUpload();
        } else {
            this.mout.print("Progress:|");
            start = System.currentTimeMillis();
            RandomAccessFile raf = new RandomAccessFile(firmware, "r");
            int currentProgress = 0;
            int lastProgress = 0;
            while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
                byte[] currentChunk = new byte[4];
                ByteUtility.intTo4Bytes(currentChunk, 0, totalRead);
                if (readCount != chunkSize) {
                    byte[] lastChunk = new byte[readCount];
                    System.arraycopy(chunk, 0, lastChunk, 0, readCount);
                    chunk = lastChunk;
                }
                try {
                    this.uploadBIOS(reservation.id, currentChunk, chunk);
                }
                catch (IPMIException ex1) {
                    this.cancelBIOSUpgrade(reservation.id);
                    throw new Exception("Upload firmware error. location = " + totalRead + "(" + ByteUtility.byteToHex(ex1.getIPMIMessage().completionCode) + "h)");
                }
                currentProgress = (int)((long)((totalRead += readCount) * 100) / firmware.length());
                if (currentProgress <= lastProgress) continue;
                if (currentProgress % 2 == 0) {
                    this.mout.print(">");
                }
                lastProgress = currentProgress;
            }
            this.mout.println("| 100%");
            this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        }
        this.mout.println("");
        this.mout.println("=============");
        this.mout.println("Updating BIOS");
        this.mout.println("=============");
        this.mout.print("Progress:|");
        start = System.currentTimeMillis();
        try {
            this.flashBIOS(reservation.id, optionFlag);
        }
        catch (Exception ex) {
            this.cancelBIOSUpgrade(reservation.id);
            throw new Exception(ex.getMessage());
        }
        int progIndex = 0;
        int count = 0;
        while (progIndex != 100) {
            try {
                progIndex = this.getBIOSUpdateProgress(reservation.id);
            }
            catch (IPMITimeoutException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.cancelBIOSUpgrade(reservation.id);
                throw new Exception(ex.getMessage());
            }
            if (progIndex > count) {
                for (int i2 = 0; i2 < progIndex - count; ++i2) {
                    if ((i2 + count) % 2 != 0) continue;
                    this.mout.print(">");
                }
                count = progIndex;
            }
            Thread.sleep(1000L);
        }
        this.mout.println("| 100%");
        this.printTimeString("Update Time", System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        try {
            this.finalizeBIOSUpgrade(reservation.id);
        }
        catch (Exception ex) {
            this.cancelBIOSUpgrade(reservation.id);
            throw new Exception(ex.getMessage());
        }
        this.printTimeString("Total Elapse Time", System.currentTimeMillis() - firstStart);
        if (reboot) {
            this.mout.println("");
            this.mout.println("====================================");
            this.mout.println("Reboot & check system power status");
            this.mout.println("====================================");
            IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiInterface);
            int softShutdownWaitingSecs = 300;
            int detectServerPowerUpSecs = 60;
            if (powerStatusInfo.getPowerStatus() == 1) {
                ipmiChassisCommand.softShutdown();
                this.mout.println("Going to shutdown the system softly");
                this.mout.println("Wait " + softShutdownWaitingSecs + " seconds for soft shutdown. If the system does not respond, it will be forced to restart automatically.");
                while (count++ != softShutdownWaitingSecs && (count <= 10 || powerStatusInfo.getPowerStatus() != 0)) {
                    if (count % 60 == 0) {
                        if (count != softShutdownWaitingSecs) {
                            this.mout.println();
                            this.mout.println("Going to shutdown the system softly");
                            ipmiChassisCommand.softShutdown();
                        }
                    } else {
                        this.mout.print(".");
                    }
                    Thread.sleep(1000L);
                }
                this.mout.println("");
            }
            if (powerStatusInfo.getPowerStatus() == 0) {
                ipmiChassisCommand.powerUp();
                this.mout.println("Going to power up the system");
            } else {
                this.mout.println("\nGoing to force shutdown the system");
                ipmiChassisCommand.powerDown();
                Thread.sleep(2000L);
                int i3 = 0;
                this.mout.print("Detecting system power status");
                while (powerStatusInfo.getPowerStatus() == 1) {
                    if (i3 < 10) {
                        Thread.sleep(1000L);
                        ++i3;
                        continue;
                    }
                    throw new Exception("Can not shut down this system");
                }
                this.mout.println("\nSystem power status: off");
                Thread.sleep(2000L);
                this.mout.print("\nGoing to power up the system");
                ipmiChassisCommand.powerUp();
            }
            this.mout.println("");
            this.mout.print("Detecting system power status");
            count = 0;
            while (powerStatusInfo.getPowerStatus() == 0) {
                if (count++ == detectServerPowerUpSecs) {
                    throw new Exception("Can not turn on this system\nDetect system power status timeout");
                }
                this.mout.print(".");
                Thread.sleep(1000L);
            }
            this.mout.println("");
            this.mout.println("System power status: on");
        }
        this.mout.println("Done");
        return true;
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    public BIOSInfo checkBIOSInfofromBMC() throws Exception {
        return null;
    }

    public BIOSInfo checkBIOSImageOLD(String firmwareFilename) throws Exception {
        File firmware = new File(firmwareFilename);
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        boolean result = false;
        int chunkSize = 8192;
        int i2 = 0;
        while ((long)i2 < firmware.length()) {
            byte[] chunk = new byte[chunkSize];
            raf.seek(i2);
            int count = raf.read(chunk);
            if (count != chunkSize) {
                throw new Exception("File read error");
            }
            String chunkString = new String(chunk);
            int index = chunkString.indexOf("Supermicro");
            if (index != -1) {
                String biosDate = "";
                String biosVer = "";
                String model = "";
                if (chunkString.indexOf("BIOS Date") != -1) {
                    int biosDateIndex = chunkString.indexOf("BIOS Date") + "BIOS Date".length();
                    biosDate = chunkString.substring(biosDateIndex + 1, biosDateIndex + 1 + 10);
                    model = chunkString.substring(index + "Supermicro".length() + 1, chunkString.indexOf("BIOS Date"));
                }
                if (chunkString.indexOf("Rev") != -1) {
                    int biosVerIndex = chunkString.indexOf("Rev") + "Rev".length();
                    biosVer = chunkString.substring(biosVerIndex + 1, biosVerIndex + 1 + 4);
                }
                BIOSInfo biosInfo = new BIOSInfo();
                biosInfo.ver = biosVer;
                biosInfo.date = biosDate;
                biosInfo.model = model;
                biosInfo.fileSize = firmware.length();
                raf.close();
                return biosInfo;
            }
            i2 += chunkSize;
        }
        raf.close();
        return null;
    }

    public BIOSInfo checkBIOSImage(String firmwareFilename) throws Exception {
        return this.checkBIOSImage(firmwareFilename, false);
    }

    public BIOSInfo checkBIOSImage(String firmwareFilename, boolean isBoardOffsetShift7) throws Exception {
        int boardIDOffset = 8;
        if (isBoardOffsetShift7) {
            boardIDOffset = 7;
        }
        File firmware = new File(firmwareFilename);
        RandomAccessFile raf = new RandomAccessFile(firmware, "r");
        boolean result = false;
        int chunkSize = 8192;
        int i2 = 0;
        while ((long)i2 < firmware.length()) {
            byte[] chunk = new byte[chunkSize];
            raf.seek(i2);
            int count = raf.read(chunk);
            if (count != chunkSize) {
                throw new Exception("File read error");
            }
            String chunkString = new String(chunk, "ISO-8859-1");
            int index = chunkString.indexOf("$FID");
            if (index != -1) {
                if (index + 8 > 8192) {
                    return null;
                }
                String boardIDStr = chunkString.substring(index + boardIDOffset, index + boardIDOffset + 4);
                String boardModel = "N/A";
                byte[] boardIDBytes = new byte[]{0, 0};
                try {
                    boardIDBytes = ByteUtility.hexToBytes(boardIDStr);
                    byte tempB = boardIDBytes[0];
                    boardIDBytes[0] = boardIDBytes[1];
                    boardIDBytes[1] = tempB;
                    IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
                    boardModel = IPMIOEMCommand.getBoardModel(boardIDBytes);
                }
                catch (Exception e2) {
                    // empty catch block
                }
                byte[] year = new byte[]{chunk[index + 44], chunk[index + 45]};
                byte month = chunk[index + 46];
                byte day = chunk[index + 47];
                String date = "" + (month < 10 ? "0" + month : Byte.valueOf(month)) + "/" + (day < 10 ? "0" + day : Byte.valueOf(day)) + "/" + (((year[1] & 0xFF) << 8) + (year[0] & 0xFF));
                BIOSInfo biosInfo = new BIOSInfo();
                biosInfo.date = date;
                biosInfo.model = boardModel;
                biosInfo.fileSize = firmware.length();
                biosInfo.boardID = boardIDBytes;
                raf.close();
                return biosInfo;
            }
            i2 += chunkSize;
        }
        raf.close();
        return null;
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public int speedTest() throws IPMIException {
        IPMIGlobalCommand ipmiGlobalCommand = new IPMIGlobalCommand(this.getIPMIInterface());
        long start = System.currentTimeMillis();
        for (int i2 = 0; i2 < 10; ++i2) {
            ACPIInfo acpi = ipmiGlobalCommand.getACPI();
            if (acpi != null) continue;
            throw new IPMIException("test speed failed");
        }
        long end = System.currentTimeMillis();
        return (int)((end - start) / 10L);
    }

    private void CLASS_X9_BIOS_UPDATE_ENTITY____________() {
    }

    private void dummyCommandForKeepMainThreadSession() {
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(this.getIPMIInterface());
        ipmiMessagingCommand.getSystemGUID();
    }

    private void main____________________________() {
    }

    public static void main(String[] args) {
        IPMIX9BIOSOEMCommand.main_FileReadTest();
    }

    private static void main_UploadTest(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java -jar BIOSUpdateTest.jar <IP> <ChunkSize> <BIOS Filename> [Options...]");
            System.out.println("Options: ");
            System.out.println("         -n: NVRAM overwrite");
            System.out.println("");
            System.out.println("Example 1: skip NVRAM overwrite");
            System.out.println("java -jar BIOSUpdateTest.jar 192.168.10.92 200 8M.rom");
            System.out.println("Example 2: NVRAM overwrite");
            System.out.println("java -jar BIOSUpdateTest.jar 192.168.10.92 200 8M.rom -n");
            return;
        }
        String ip = args[0];
        int chunkSize = Integer.parseInt(args[1]);
        String filename = args[2];
        String options = "";
        if (args.length > 3) {
            for (int i2 = 3; i2 < args.length; ++i2) {
                options = options + args[i2] + " ";
            }
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiX9BIOSOEMCommand.setIPMIInterface(rmcp);
        try {
            int optionFlag = 0;
            if (options.indexOf("-n") != -1) {
                optionFlag |= 0;
            } else {
                System.out.println("Option: Skip NVRAM overwrite");
                optionFlag |= 1;
            }
            ipmiX9BIOSOEMCommand.flashBIOS(chunkSize, optionFlag, filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void main_FileReadTest() {
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        try {
            long start = System.currentTimeMillis();
            BIOSInfo biosInfo = ipmiX9BIOSOEMCommand.checkBIOSImage("c:\\bios_x10.dat");
            System.out.println(biosInfo.toStringFromBIOSImage());
            long end = System.currentTimeMillis();
            System.out.println("Execution time was " + (end - start) + " ms.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void main_ATENTest() {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.100");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiX9BIOSOEMCommand.setIPMIInterface(rmcp);
        try {
            boolean b2 = ipmiX9BIOSOEMCommand.ifMultiSessionUploadSupported();
            System.out.println("if multi session upload support ? " + b2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class UploadingTask
    implements Runnable {
        public String filename;
        public long startOffset;
        public long sizeToUpload;
        public int chunkSize;
        public byte[] reservationID;
        public IPMIInterfaceConfig ipmiInterfaceConfig;
        public int totalRead = 0;
        public byte[] offset;
        public boolean isLogin;
        public boolean isDone;
        File firmware;
        ISessionController sessionController;
        IPMIX9BIOSOEMCommand ipmiX9BIOSOEMCommand;

        UploadingTask(String filename, long startOffset, long sizeToUpload, int chunkSize, byte[] reservationID, IPMIInterfaceConfig ipmiInterfaceConfig) {
            this.filename = filename;
            this.startOffset = startOffset;
            this.sizeToUpload = sizeToUpload;
            this.chunkSize = chunkSize;
            this.reservationID = reservationID;
            this.ipmiInterfaceConfig = ipmiInterfaceConfig;
            this.firmware = new File(filename);
        }

        public boolean loginBMC() {
            this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(null);
            this.sessionController = SessionControllerFactory.createSessionController(this.ipmiInterfaceConfig, this.ipmiX9BIOSOEMCommand);
            return this.sessionController != null;
        }

        @Override
        public void run() {
            try {
                this.doUploadingTask();
            }
            catch (Exception ex1) {
                ex1.printStackTrace();
            }
        }

        private void doUploadingTask() throws IOException, FileNotFoundException, IPMIException, Exception {
            int readCount = 0;
            byte[] chunk = new byte[this.chunkSize];
            this.isDone = false;
            long start = System.currentTimeMillis();
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            raf.seek(this.startOffset);
            while ((readCount = raf.read(chunk, 0, chunk.length)) != -1) {
                try {
                    byte[] currentChunk = new byte[4];
                    ByteUtility.intTo4Bytes(currentChunk, 0, (int)(this.startOffset + (long)this.totalRead));
                    this.ipmiX9BIOSOEMCommand.uploadBIOS(this.reservationID, currentChunk, chunk);
                }
                catch (IPMIException ex1) {
                    this.ipmiX9BIOSOEMCommand.cancelBIOSUpgrade(this.reservationID);
                    throw new Exception("Upload firmware error. location = " + (this.startOffset + (long)this.totalRead) + "(" + ByteUtility.byteToHex(ex1.getIPMIMessage().completionCode) + "h)");
                }
                this.totalRead += readCount;
                if ((long)this.totalRead != this.sizeToUpload) continue;
            }
            raf.close();
            this.isDone = true;
            this.sessionController.closeSession();
        }
    }

    class MultiSessionTaskManager {
        int sessionSize = 0;
        MultiSessionSize sessionSizeEnum;
        String filename;
        int chunkSize;
        byte[] reservationID;
        IPMIInterfaceConfig ipmiInterfaceConfig;
        long fileSize = 0L;
        long sizeToUpload = 0L;
        ArrayList<UploadingTask> uploadingTasks = new ArrayList();

        MultiSessionTaskManager(MultiSessionSize sessionSizeEnum, String filename, int chunkSize, byte[] reservationID, IPMIInterfaceConfig ipmiInterfaceConfig) {
            this.sessionSizeEnum = sessionSizeEnum;
            this.filename = filename;
            this.chunkSize = chunkSize;
            this.reservationID = reservationID;
            this.ipmiInterfaceConfig = ipmiInterfaceConfig;
        }

        public void multiSessionUpload() throws Exception {
            UploadingTask uTask;
            int i2;
            int currentProgress = 0;
            int lastProgress = 0;
            this.fileSize = new File(this.filename).length();
            switch (this.sessionSizeEnum) {
                case SESSION_1: {
                    this.sessionSize = 1;
                    break;
                }
                case SESSION_2: {
                    this.sessionSize = 2;
                    break;
                }
                case SESSION_4: {
                    this.sessionSize = 4;
                    break;
                }
                case SESSION_8: {
                    this.sessionSize = 8;
                    break;
                }
                case SESSION_16: {
                    this.sessionSize = 16;
                    break;
                }
                case SESSION_32: {
                    this.sessionSize = 32;
                }
            }
            this.sizeToUpload = this.fileSize / (long)this.sessionSize;
            for (i2 = 0; i2 < this.sessionSize; ++i2) {
                uTask = new UploadingTask(this.filename, (long)i2 * this.sizeToUpload, this.sizeToUpload, this.chunkSize, this.reservationID, this.ipmiInterfaceConfig);
                boolean isLogin = false;
                while (!(isLogin = uTask.loginBMC())) {
                }
                this.uploadingTasks.add(uTask);
            }
            for (i2 = 0; i2 < this.sessionSize; ++i2) {
                uTask = this.uploadingTasks.get(i2);
                Thread t = new Thread(uTask);
                t.start();
            }
            boolean allDone = false;
            int allUploadLength = 0;
            long start = System.currentTimeMillis();
            IPMIX9BIOSOEMCommand.this.mout.print("Progress:|");
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                allDone = true;
                allUploadLength = 0;
                for (int i3 = 0; i3 < this.sessionSize; ++i3) {
                    UploadingTask uTask2 = this.uploadingTasks.get(i3);
                    if (!uTask2.isDone) {
                        allDone = false;
                    }
                    allUploadLength += uTask2.totalRead;
                }
                currentProgress = (int)((long)(allUploadLength * 100) / this.fileSize);
                if (currentProgress > lastProgress) {
                    if (currentProgress % 2 == 0) {
                        IPMIX9BIOSOEMCommand.this.mout.print(">");
                    }
                    lastProgress = currentProgress;
                }
                IPMIX9BIOSOEMCommand.this.dummyCommandForKeepMainThreadSession();
            } while (!allDone);
            IPMIX9BIOSOEMCommand.this.mout.println("| 100%");
            IPMIX9BIOSOEMCommand.this.printTimeString("Upload Time", System.currentTimeMillis() - start);
        }
    }

    public static enum MultiSessionSize {
        SESSION_1,
        SESSION_2,
        SESSION_4,
        SESSION_8,
        SESSION_16,
        SESSION_32;

    }

    private class Reservation {
        byte[] id = new byte[2];
        byte[] maxChunkSize = new byte[4];

        public String toString() {
            String str = "";
            str = str + "Reservation ID = " + ByteUtility.bytesToHex(this.id) + "\n";
            str = str + "Max Chunk Size = " + ByteUtility.fourBytesToIntByLSBFirst(this.maxChunkSize) + "\n";
            return str;
        }
    }

    public class BIOSInfo {
        public long fileSize;
        public String ver;
        public String date;
        public String model;
        public byte[] boardID;
        public byte[] raw;

        public String toStringFromBIOSImage() {
            String str = "";
            str = str + "Date     = " + this.date + "\n";
            str = str + "MB Type  = " + this.model + "\n";
            str = str + "Size     = " + IPMIX9BIOSOEMCommand.readableFileSize(this.fileSize);
            return str;
        }

        public String toStringFromBMC() {
            return this.raw == null ? "" : new String(this.raw);
        }

        public boolean fromRawToGetBIOSInfo(byte[] raw) {
            boolean result = false;
            String rawString = new String(raw);
            this.raw = raw;
            return result;
        }
    }
}

