/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.blade;

import com.supermicro.ipmi.blade.BladeEntity;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.FailureEntity;
import com.supermicro.ipmi.blade.MB_B7DBE_SensorEntity;
import com.supermicro.ipmi.blade.TemperatureData;
import java.util.ArrayList;

public class MB_BHDGT_SensorEntity
extends MB_B7DBE_SensorEntity {
    public static final String CPU1_DIMM_VOLTAGE = "CPU1 DIMM voltage";
    public static final String CPU2_DIMM_VOLTAGE = "CPU2 DIMM voltage";
    public static final String V1P1 = "1.1V";
    public static final String V1P2H1 = "1.2V H1";
    public static final String V1P2H2 = "1.2V H2";
    public static final String V3P3VSB = "3.3VSB";
    private byte cpu1DIMMVoltage;
    private byte cpu2DIMMVoltage;
    private byte v1p1;
    private byte v1p2h1;
    private byte v1p2h2;
    private byte v3p3vsb;

    @Override
    public boolean fromRaw(byte[] raw) {
        if (raw.length != BladeSystemEntity.MOTHER_BOARD_SENSORS_DATA_SIZE) {
            return false;
        }
        this.pollCount = raw[0];
        this.flag = raw[1];
        this.remoteCPU1Temp = raw[2];
        this.remoteCPU2Temp = raw[3];
        this.systemTemp = raw[4];
        this.cpu1CoreVoltage = raw[5];
        this.cpu2CoreVoltage = raw[6];
        this.cpu1DIMMVoltage = raw[7];
        this.cpu2DIMMVoltage = raw[8];
        this.v1p1 = raw[9];
        this.v1p2h1 = raw[10];
        this.v1p2h2 = raw[11];
        this.v3p3 = raw[12];
        this.v3p3vsb = raw[13];
        this.v5 = raw[14];
        this.v5sb = raw[15];
        this.v12 = raw[16];
        this.batteryVoltage = raw[17];
        this.raw = raw;
        return true;
    }

    @Override
    public ArrayList generateFailureReport(BladeEntity bladeEntity, int moduleIndex) {
        ArrayList<FailureEntity> failures = new ArrayList<FailureEntity>();
        if (this.getFlag() != 1) {
            return failures;
        }
        if (this.checkRemoteCPU1Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Temp"));
        }
        if (this.checkRemoteCPU2Temp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Temp"));
        }
        if (this.checkSystemTemp() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "System Temp"));
        }
        if (this.checkCpu1CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU1 Vcore"));
        }
        if (this.checkCpu2CoreVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "CPU2 Vcore"));
        }
        if (this.checkCPU1DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU1_DIMM_VOLTAGE));
        }
        if (this.checkCPU2DIMMVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, CPU2_DIMM_VOLTAGE));
        }
        if (this.checkV1p1() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P1));
        }
        if (this.checkV1p2H1() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P2H1));
        }
        if (this.checkV1p2H2() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V1P2H2));
        }
        if (this.checkV3p3() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "3.3V"));
        }
        if (this.checkV3p3VSB() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, V3P3VSB));
        }
        if (this.checkV5() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5V"));
        }
        if (this.checkV5sb() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "5VSB"));
        }
        if (this.checkV12() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "12V"));
        }
        if (this.checkBatteryVoltage() == 1) {
            failures.add(this.generateBladeSensorFailure(bladeEntity, moduleIndex, "VBAT"));
        }
        return failures;
    }

    @Override
    public String toFormatedString() {
        this.formatedString = new StringBuffer();
        this.formatedString.append(String.format(this.formatTemplate, "Status", "Sensor", "Reading", "Low Limit", "High Limit"));
        this.formatedString.append(String.format(this.formatTemplate, "------", "------", "-------", "---------", "----------"));
        this.addRaw(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A");
        this.addRaw(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A");
        this.addRaw(this.checkSystemTemp(), "System Temp", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit()));
        if (this.getRemoteCPU1Temp() == 7) {
            this.setCpu1CoreVoltage((byte)0);
            this.setCpu1DIMMVoltage((byte)0);
        }
        if (this.getRemoteCPU2Temp() == 7) {
            this.setCpu2CoreVoltage((byte)0);
            this.setCpu2DIMMVoltage((byte)0);
        }
        this.addRaw(this.checkCpu1CoreVoltage(), "CPU1 Vcore", this.d2StrV(this.getCpu1CoreVoltageFormula()), this.d2StrV(this.getCpu1CoreVoltageLowLimit()), this.d2StrV(this.getCpu1CoreVoltageHighLimit()));
        this.addRaw(this.checkCpu2CoreVoltage(), "CPU2 Vcore", this.d2StrV(this.getCpu2CoreVoltageFormula()), this.d2StrV(this.getCpu2CoreVoltageLowLimit()), this.d2StrV(this.getCpu2CoreVoltageHighLimit()));
        this.addRaw(this.checkCPU1DIMMVoltage(), CPU1_DIMM_VOLTAGE, this.d2StrV(this.getCPU1DIMMVoltageFormula()), this.d2StrV(this.getCPU1DIMMVoltageLowLimit()), this.d2StrV(this.getCPU1DIMMVoltageHighLimit()));
        this.addRaw(this.checkCPU2DIMMVoltage(), CPU2_DIMM_VOLTAGE, this.d2StrV(this.getCPU2DIMMVoltageFormula()), this.d2StrV(this.getCPU2DIMMVoltageLowLimit()), this.d2StrV(this.getCPU2DIMMVoltageHighLimit()));
        this.addRaw(this.checkV1p1(), V1P1, this.d2StrV(this.getV1p1Formula()), this.d2StrV(this.getV1p1LowLimit()), this.d2StrV(this.getV1p1HighLimit()));
        this.addRaw(this.checkV1p2H1(), V1P2H1, this.d2StrV(this.getV1p2H1Formula()), this.d2StrV(this.getV1p2H1LowLimit()), this.d2StrV(this.getV1p2H1HighLimit()));
        this.addRaw(this.checkV1p2H2(), V1P2H2, this.d2StrV(this.getV1p2H2Formula()), this.d2StrV(this.getV1p2H2LowLimit()), this.d2StrV(this.getV1p2H2HighLimit()));
        this.addRaw(this.checkV3p3(), "3.3V", this.d2StrV(this.getV3p3Formula()), this.d2StrV(this.getV3p3LowLimit()), this.d2StrV(this.getV3p3HighLimit()));
        this.addRaw(this.checkV3p3VSB(), V3P3VSB, this.d2StrV(this.getV3p3VSBFormula()), this.d2StrV(this.getV3p3VSBLowLimit()), this.d2StrV(this.getV3p3VSBHighLimit()));
        this.addRaw(this.checkV12(), "12V", this.d2StrV(this.getV12Formula()), this.d2StrV(this.getV12LowLimit()), this.d2StrV(this.getV12HighLimit()));
        this.addRaw(this.checkV5(), "5V", this.d2StrV(this.getV5Formula()), this.d2StrV(this.getV5LowLimit()), this.d2StrV(this.getV5HighLimit()));
        this.addRaw(this.checkV5sb(), "5VSB", this.d2StrV(this.getV5sbFormula()), this.d2StrV(this.getV5sbLowLimit()), this.d2StrV(this.getV5sbHighLimit()));
        this.addRaw(this.checkBatteryVoltage(), "VBAT", this.d2StrV(this.getBatteryVoltageFormula()), this.d2StrV(this.getBatteryVoltageLowLimit()), this.d2StrV(this.getBatteryVoltageHighLimit()));
        return this.formatedString.toString();
    }

    @Override
    public int checkRemoteCPU1Temp() {
        if (this.getRemoteCPU1Temp() == 0 || this.getRemoteCPU1Temp() == 1 || this.getRemoteCPU1Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU1Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public int checkRemoteCPU2Temp() {
        if (this.getRemoteCPU2Temp() == 0 || this.getRemoteCPU2Temp() == 1 || this.getRemoteCPU2Temp() == 2) {
            return 0;
        }
        if (this.getRemoteCPU2Temp() == 4) {
            return 1;
        }
        return 2;
    }

    @Override
    public double getCpu1CoreVoltageFormula() {
        return (double)(this.cpu1CoreVoltage & 0xFF) * 0.008;
    }

    @Override
    public double getCpu1CoreVoltageHighLimit() {
        return 1.5;
    }

    @Override
    public double getCpu1CoreVoltageLowLimit() {
        return 0.75;
    }

    @Override
    public double getCpu2CoreVoltageFormula() {
        return (double)(this.cpu2CoreVoltage & 0xFF) * 0.008;
    }

    @Override
    public double getCpu2CoreVoltageHighLimit() {
        return 1.5;
    }

    @Override
    public double getCpu2CoreVoltageLowLimit() {
        return 0.75;
    }

    public int checkCPU1DIMMVoltage() {
        if (this.getRemoteCPU1Temp() == 7) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU1DIMMVoltageFormula() <= this.getCPU1DIMMVoltageLowLimit() || this.getCPU1DIMMVoltageFormula() >= this.getCPU1DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getCPU1DIMMVoltageFormula() {
        return (double)(this.cpu1DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU1DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCPU1DIMMVoltageHighLimit() {
        return 1.65;
    }

    public int checkCPU2DIMMVoltage() {
        if (this.getRemoteCPU2Temp() == 7) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() == 0.0) {
            return 2;
        }
        if (this.getCPU2DIMMVoltageFormula() <= this.getCPU2DIMMVoltageLowLimit() || this.getCPU2DIMMVoltageFormula() >= this.getCPU2DIMMVoltageHighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getCPU2DIMMVoltageFormula() {
        return (double)(this.cpu2DIMMVoltage & 0xFF) * 0.008;
    }

    public double getCPU2DIMMVoltageLowLimit() {
        return 1.2;
    }

    public double getCPU2DIMMVoltageHighLimit() {
        return 1.65;
    }

    public int checkV1p1() {
        if (this.getV1p1Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p1Formula() <= this.getV1p1LowLimit() || this.getV1p1Formula() >= this.getV1p1HighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getV1p1Formula() {
        return (double)(this.v1p1 & 0xFF) * 0.008;
    }

    public double getV1p1HighLimit() {
        return 1.21;
    }

    public double getV1p1LowLimit() {
        return 0.98;
    }

    public int checkV1p2H1() {
        if (this.getV1p2H1Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p2H1Formula() <= this.getV1p2H1LowLimit() || this.getV1p2H1Formula() >= this.getV1p2H1HighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getV1p2H1Formula() {
        return (double)(this.v1p2h1 & 0xFF) * 0.008;
    }

    public double getV1p2H1HighLimit() {
        return 1.32;
    }

    public double getV1p2H1LowLimit() {
        return 1.08;
    }

    public int checkV1p2H2() {
        if (this.getV1p2H2Formula() == 0.0) {
            return 2;
        }
        if (this.getV1p2H2Formula() <= this.getV1p2H2LowLimit() || this.getV1p2H2Formula() >= this.getV1p2H2HighLimit()) {
            return 1;
        }
        return 0;
    }

    public double getV1p2H2Formula() {
        return (double)(this.v1p2h2 & 0xFF) * 0.008;
    }

    public double getV1p2H2HighLimit() {
        return 1.32;
    }

    public double getV1p2H2LowLimit() {
        return 1.08;
    }

    public int checkV3p3VSB() {
        if (this.getV3p3VSBFormula() == 0.0) {
            return 2;
        }
        if (this.getV3p3VSBFormula() <= this.getV3p3VSBLowLimit() || this.getV3p3VSBFormula() >= this.getV3p3VSBHighLimit()) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getV3p3Formula() {
        return (double)(this.v3p3 & 0xFF) * 0.024;
    }

    public double getV3p3VSBFormula() {
        return (double)(this.v3p3vsb & 0xFF) * 0.024;
    }

    public double getV3p3VSBHighLimit() {
        return 3.63;
    }

    public double getV3p3VSBLowLimit() {
        return 2.96;
    }

    @Override
    public double getV5Formula() {
        return (double)(this.v5 & 0xFF) * 0.04;
    }

    @Override
    public double getV5sbFormula() {
        return (double)(this.v5sb & 0xFF) * 0.04;
    }

    @Override
    public double getBatteryVoltageFormula() {
        return (double)(this.batteryVoltage & 0xFF) * 0.024;
    }

    @Override
    public byte getSystemTempHighLimit() {
        if (this.systemTempHighLimit != 0) {
            return this.systemTempHighLimit;
        }
        return 80;
    }

    @Override
    public ArrayList<TemperatureData> getTemperatures() {
        ArrayList<TemperatureData> list = new ArrayList<TemperatureData>();
        list.add(this.createTemperatureData(this.checkRemoteCPU1Temp(), "CPU1 Temp", this.showCPUTempString(this.getRemoteCPU1Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkRemoteCPU2Temp(), "CPU2 Temp", this.showCPUTempString(this.getRemoteCPU2Temp()), "N/A", "N/A"));
        list.add(this.createTemperatureData(this.checkSystemTemp(), "System Temp", this.showCandF(this.getSystemTemp()), "N/A", "" + this.showCandF(this.getSystemTempHighLimit())));
        return list;
    }

    public byte getCpu1DIMMVoltage() {
        return this.cpu1DIMMVoltage;
    }

    public byte getCpu2DIMMVoltage() {
        return this.cpu2DIMMVoltage;
    }

    public byte getV1p1() {
        return this.v1p1;
    }

    public byte getV1p2h1() {
        return this.v1p2h1;
    }

    public byte getV1p2h2() {
        return this.v1p2h2;
    }

    public byte getV3p3vsb() {
        return this.v3p3vsb;
    }

    public void setCpu1DIMMVoltage(byte cpu1DIMMVoltage) {
        this.cpu1DIMMVoltage = cpu1DIMMVoltage;
    }

    public void setCpu2DIMMVoltage(byte cpu2DIMMVoltage) {
        this.cpu2DIMMVoltage = cpu2DIMMVoltage;
    }

    public void setV1p1(byte v1p1) {
        this.v1p1 = v1p1;
    }

    public void setV1p2h1(byte v1p2h1) {
        this.v1p2h1 = v1p2h1;
    }

    public void setV1p2h2(byte v1p2h2) {
        this.v1p2h2 = v1p2h2;
    }

    public void setV3p3vsb(byte v3p3vsb) {
        this.v3p3vsb = v3p3vsb;
    }
}

