/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.doctor;

import com.supermicro.ipmi.doctor.IPMIDiagnostic;
import com.supermicro.ipmi.doctor.IPMIDiagnosticResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public abstract class IPMIDiagnosticCase
implements IPMIDiagnostic {
    private String fName;

    public IPMIDiagnosticCase() {
    }

    public IPMIDiagnosticCase(String name) {
        this.fName = name;
    }

    @Override
    public void runResult(IPMIDiagnosticResult ipmiDiagnosticResult) {
        ipmiDiagnosticResult.run(this);
    }

    public void run() {
        this.setUp();
        this.runDiagnostic();
        this.tearDown();
    }

    protected abstract void setUp();

    protected abstract void tearDown();

    private void runDiagnostic() {
        Method runMethod = null;
        try {
            runMethod = this.getClass().getMethod(this.fName, new Class[0]);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        if (!Modifier.isPublic(runMethod.getModifiers())) {
            throw new RuntimeException("Method \"" + this.fName + "\" should be public");
        }
        try {
            runMethod.invoke((Object)this, new Object[0]);
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException(this.getClass() + "." + runMethod.getName() + ": " + e3.getTargetException().getMessage());
        }
        catch (Exception e4) {
            throw new RuntimeException(e4);
        }
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public IPMIDiagnostic suite() {
        return null;
    }
}

