/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingSNMPConfiguration
extends Command {
    public static String SNMP_COMMUNITY = "SNMP_COMMUNITY";
    public static String SNMP_DESC_IP_1 = "SNMP_DESC_IP_1";
    public static String SNMP_DESC_IP_2 = "SNMP_DESC_IP_2";
    public static String SNMP_DESC_IP_3 = "SNMP_DESC_IP_3";
    public static String SNMP_DESC_MAC_1 = "SNMP_DESC_MAC_1";
    public static String SNMP_DESC_MAC_2 = "SNMP_DESC_MAC_2";
    public static String SNMP_DESC_MAC_3 = "SNMP_DESC_MAC_3";

    @Override
    public Result execute(Host host) {
        IPMILanCommand ipmiLANCommand = new IPMILanCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiLANCommand.setIPMIInterface(rmcp);
        result.description = result.description + "\n";
        String communityString = ipmiLANCommand.getCommunityString();
        if (communityString != null) {
            result.description = result.description + "Community String = " + communityString + "\n";
            result.setSingleData(SNMP_COMMUNITY, communityString);
        }
        int numberOfDestination = ipmiLANCommand.getNumberOfDestination();
        for (int j2 = 1; j2 < numberOfDestination; ++j2) {
            String dIP = ipmiLANCommand.getDestinationIP((byte)j2);
            String dMAC = ipmiLANCommand.getDestinationMAC((byte)j2);
            if (dIP != null) {
                result.description = result.description + "Destination(" + j2 + ") IP address : " + dIP + "   MAC : " + dMAC;
                switch (j2) {
                    case 1: {
                        result.setSingleData(SNMP_DESC_IP_1, dIP);
                        result.setSingleData(SNMP_DESC_MAC_1, dMAC);
                        break;
                    }
                    case 2: {
                        result.setSingleData(SNMP_DESC_IP_2, dIP);
                        result.setSingleData(SNMP_DESC_MAC_2, dMAC);
                        break;
                    }
                    case 3: {
                        result.setSingleData(SNMP_DESC_IP_3, dIP);
                        result.setSingleData(SNMP_DESC_MAC_3, dMAC);
                    }
                }
            }
            if (j2 == numberOfDestination - 1) continue;
            result.description = result.description + "\n";
        }
        result.booleanResult = true;
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get SNMP Configuration";
    }
}

