/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task;

import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.task.BTaskManager;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.MOutFactory;
import com.supermicro.ipmi.text.Parser;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class BTask
implements Runnable {
    public static final int STATE_WAIT = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_END = 2;
    public String taskID;
    public String ip;
    public String id;
    public String pw;
    public String[] cmdString;
    public long startTime = 0L;
    public long endTime = 0L;
    public int status = 0;
    public int exitCode;
    Parser parser;
    MOut aMout;

    public BTask(String ip, String id, String pw, String[] cmdString) {
        this.ip = ip;
        this.id = id;
        this.pw = pw;
        this.cmdString = cmdString;
    }

    public MOut getMOut() {
        return this.aMout;
    }

    @Override
    public void run() {
        this.startTime = Calendar.getInstance().getTime().getTime();
        this.status = 1;
        this.runTask();
        this.endTime = Calendar.getInstance().getTime().getTime();
        this.status = 2;
    }

    public void runTask() {
        this.parser = new Parser();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(this.ip);
        config.setUserName(this.id);
        config.setPassword(this.pw);
        this.aMout = MOutFactory.createMOutInstanceWtihBufferOutput();
        MOut.addMOut(this.parser, this.aMout);
        Command command = this.parser.parse(this.parser.getArgumentRoot(), this.cmdString);
        if (command == null) {
            this.exitCode = 180;
            return;
        }
        if (!command.isSupportBackgroundModeForTaskRunCommand) {
            this.exitCode = 154;
            return;
        }
        command.setConfig(config);
        command.setOriginalParser(this.parser);
        try {
            command.execute();
        }
        catch (Exception ex) {
            MOut.G(command).println(ex.getMessage());
        }
        this.exitCode = command.getStatusCode();
    }

    public String getCommandString() {
        String cmd = this.ip + " " + this.id + " " + this.helpHidePW(this.pw) + " ";
        for (int i2 = 0; i2 < this.cmdString.length; ++i2) {
            cmd = cmd + this.cmdString[i2] + " ";
        }
        return cmd;
    }

    public String helpHidePW(String pw) {
        String hidePW = "";
        for (int i2 = 0; i2 < pw.length(); ++i2) {
            hidePW = hidePW + "*";
        }
        return hidePW;
    }

    public String getStateString() {
        switch (this.status) {
            case 0: {
                return "WAIT";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "END";
            }
        }
        return "";
    }

    public String getMessageDisplay(boolean tag) {
        String content = "No Message";
        if (this.getMOut() != null) {
            content = this.getMOut().getBufferContent();
        }
        String result = "";
        if (tag) {
            result = "TaskID : " + this.taskID + " [" + this.getStateString() + "] [Command : " + this.getCommandString() + "]" + "\n";
        }
        result = result + content + "\n";
        if (tag) {
            result = result + "TaskID : " + this.taskID + " [" + this.getStateString() + "]" + "\n";
        }
        return result;
    }

    public void saveMessageToFile(String filename) throws Exception {
        this.getMOut().bufferToFile(filename);
    }

    public String getElapseTimeDisplay() {
        String elapse = this.endTime != 0L ? BTaskManager.printTimeString(this.endTime - this.startTime) : (this.startTime == 0L ? "" : BTaskManager.printTimeString(Calendar.getInstance().getTime().getTime() - this.startTime));
        return elapse;
    }

    public String getStartTimeDisplay() {
        if (this.startTime == 0L) {
            return "no start time";
        }
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd HH:mm:ss");
        String s = f2.format(new Date(this.startTime));
        return s;
    }

    public String getEndTimeDisplay() {
        if (this.endTime == 0L) {
            return "no end time";
        }
        SimpleDateFormat f2 = new SimpleDateFormat("MM/dd HH:mm:ss");
        String e2 = f2.format(new Date(this.endTime));
        return e2;
    }

    public String getExitCodeDisplay() {
        if (this.status != 2) {
            return "No Exit Code";
        }
        return "" + this.exitCode;
    }

    public void clearMessageLinkForGC() {
        if (this.parser != null) {
            MOut.removeMOut(this.parser);
        }
    }
}

