/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BBPAutoDischargeCommand
extends SuperBladeCommand {
    int index;
    int day;

    @Override
    public boolean preValidate() {
        this.index = -1;
        if (this.parameters != null && this.parameters.length == 2) {
            try {
                this.index = Integer.parseInt(this.parameters[0]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid Module");
                return false;
            }
            if (this.index > 4 || this.index < 1) {
                MOut.G(this).println("Module out of range");
                return false;
            }
            try {
                this.day = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println("Invalid day");
                return false;
            }
            if (this.day > 63 || this.day < 1) {
                MOut.G(this).println("day out of range");
                return false;
            }
        } else {
            MOut.G(this).println("<module> and <day> required");
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        boolean busID = false;
        byte slaveAddr = ipmiI2CPMBusCommand.slaveAddrsFRUBBP[this.index - 1];
        try {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(slaveAddr);
            ipmiI2CPMBusCommand.setAutoDischargeCommand((byte)this.day);
            MOut.G(this).print("Done");
        }
        catch (Exception e2) {
            MOut.G(this).println(e2.getMessage());
        }
    }
}

