/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class BBPStatusCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 0;
        byte slaveAddr = 0;
        if (this.parameters == null) {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.detectSlaveAddressFRUBBP();
            if (ipmiI2CPMBusCommand.getBusID() == 0) {
                MOut.G(this).println("Cannot detect BusID");
                this.statusCode = 147;
                return;
            }
            if (ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP() == null) {
                MOut.G(this).println("Cannot detect BBP FRU slave address");
                this.statusCode = 147;
                return;
            }
            for (int i2 = 0; i2 < ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP().length; ++i2) {
                String moduleLabel = "";
                int module = ipmiI2CPMBusCommand.getModuleByFRUBBP(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP()[i2]);
                if (module != 0) {
                    moduleLabel = "[Module " + module + "]";
                }
                MOut.G(this).println(" [SlaveAddress = " + ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP()[i2]) + "h] " + moduleLabel);
                ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRUBBP()[i2]);
                IPMII2CPMBusCommand.BBPHealth bbpHealth = ipmiI2CPMBusCommand.getAllBBP();
                MOut.G(this).println(bbpHealth.toFormatedHeader() + bbpHealth.toFormatedString());
            }
        } else {
            if (this.parameters.length < 2) {
                MOut.G(this).println("[<busId> <SlaveAddr>] both parameters required");
                this.statusCode = 147;
                return;
            }
            try {
                busID = (byte)Integer.parseInt(this.parameters[0], 16);
                slaveAddr = (byte)Integer.parseInt(this.parameters[1], 16);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddrFRUBBP(slaveAddr);
            IPMII2CPMBusCommand.BBPHealth bbpHealth = ipmiI2CPMBusCommand.getAllBBP();
            MOut.G(this).println(bbpHealth.toFormatedHeader() + bbpHealth.toFormatedString());
        }
    }
}

