/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.algo.AES_CBC_128;
import com.supermicro.ipmi.text.Host;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SortedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class HostManager {
    private AES_CBC_128 aes = new AES_CBC_128();
    private byte[] iv = new byte[]{8, 2, 2, 6, 3, 9, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public String filename = "hosts.properties";
    public SortedSet hosts = new TreeSet();
    public SortedSet hostGroups = new TreeSet();
    private static final HostManager instance = new HostManager();

    private HostManager() {
        this.load();
    }

    public static HostManager getInstance() {
        return instance;
    }

    public void load() {
        Host host;
        String value;
        String hostname;
        this.checkFile();
        this.hosts.clear();
        this.hostGroups.clear();
        Enumeration<String> e2 = this.getPropertyNames();
        while (e2.hasMoreElements()) {
            hostname = e2.nextElement();
            value = this.getProperty(hostname);
            if (hostname.startsWith("*") || (host = this.createHostByText(hostname, value)) == null) continue;
            this.hosts.add(host);
        }
        e2 = this.getPropertyNames();
        while (e2.hasMoreElements()) {
            hostname = e2.nextElement();
            value = this.getProperty(hostname);
            if (!hostname.startsWith("*") || (host = this.createHostGroupByText(hostname = hostname.substring(1, hostname.length()), value)) == null) continue;
            this.hostGroups.add(host);
        }
    }

    public void checkFile() {
        File f2 = new File(this.filename);
        if (!f2.exists()) {
            try {
                f2.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Host:\n");
        sb.append(String.format("\t%-20s %-20s\n", "Host", "IP"));
        sb.append(String.format("\t%-20s %-20s\n", "----", "--"));
        Iterator iter = this.hosts.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString() + "\n");
        }
        sb.append("\nHost Group:\n");
        sb.append(String.format("\t%-20s %-20s\n", "Group Name", "Host"));
        sb.append(String.format("\t%-20s %-20s\n", "----------", "----"));
        iter = this.hostGroups.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString() + "\n");
        }
        return sb.toString();
    }

    public boolean addHostGroup(Host hostGroup) throws Exception {
        int result = this.isDuplicateHost(hostGroup);
        if (result != 0) {
            if (result == 1) {
                throw new Exception("Duplicated host name");
            }
            if (result == 2) {
                throw new Exception("Duplicated hostGroup group name");
            }
        }
        this.hostGroups.add(hostGroup);
        String str = "";
        Iterator iter = hostGroup.subHosts.iterator();
        while (iter.hasNext()) {
            Host item = (Host)iter.next();
            str = str + item.getName();
            if (!iter.hasNext()) continue;
            str = str + ",";
        }
        this.setProperty("*" + hostGroup.getName(), str);
        return true;
    }

    public boolean addHost(Host host) throws Exception {
        int result = this.isDuplicateHost(host);
        if (result != 0) {
            if (result == 1) {
                throw new Exception("Duplicated host name");
            }
            if (result == 2) {
                throw new Exception("Duplicated host group name");
            }
        }
        this.hosts.add(host);
        String value = host.getIp();
        if (host.getUsername() != null && host.getPassword() != null) {
            value = value + "," + host.getUsername() + "," + this.encode(host.getName(), host.getPassword());
        }
        this.setProperty(host.getName(), value);
        return true;
    }

    public boolean updateHostname(String oldname, String newname) {
        Host host = this.findHost(oldname);
        ArrayList<Host> tempHosts = new ArrayList<Host>();
        if (host == null) {
            return false;
        }
        for (Host group : this.hostGroups) {
            if (group.findSubHost(oldname) == null) continue;
            tempHosts.add(group);
        }
        host.updateHostName(newname);
        for (Host group : tempHosts) {
            group.updateProperties();
        }
        return true;
    }

    public boolean updateHostGroupname(String oldname, String newname) {
        Host group = this.findHostGroup(oldname);
        if (group == null) {
            return false;
        }
        group.updateHostName(newname);
        return true;
    }

    public boolean removeHostByName(String hostname) {
        for (Host hostGroup : this.hostGroups) {
            hostGroup.removeSubHostsByName(hostname);
        }
        Host willRemoved = this.findHost(hostname);
        if (willRemoved != null) {
            this.hosts.remove(willRemoved);
            this.removeProperty(hostname);
            return true;
        }
        return false;
    }

    public boolean removeGroupByName(String groupname) {
        Host willRemoved = this.findHostGroup(groupname);
        if (willRemoved != null) {
            this.hostGroups.remove(willRemoved);
            this.removeProperty("*" + groupname);
            return true;
        }
        return false;
    }

    public int isDuplicateHost(Host host) {
        for (Host item : this.hosts) {
            if (!item.getName().equals(host.getName())) continue;
            return 1;
        }
        for (Host item : this.hostGroups) {
            if (!item.getName().equals(host.getName())) continue;
            return 2;
        }
        return 0;
    }

    public Host findHost(String hostname) {
        for (Host item : this.hosts) {
            if (!item.getName().equals(hostname)) continue;
            return item;
        }
        return null;
    }

    public Host findHostGroup(String hostGroupname) {
        for (Host item : this.hostGroups) {
            if (!item.getName().equals(hostGroupname)) continue;
            return item;
        }
        return null;
    }

    protected Host createHostGroupByText(String name, String format) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.findHost(name) != null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(format, ",");
        Host host = new Host();
        host.setName(name);
        while (st.hasMoreTokens()) {
            String aHostStr = st.nextToken().trim();
            Host aHost = this.findHost(aHostStr);
            if (aHost != null) {
                host.subHosts.add(aHost);
                continue;
            }
            Host aHostGroup = this.findHostGroup(aHostStr);
            if (aHostGroup == null) continue;
            host.subHosts.addAll(aHostGroup.subHosts);
        }
        host.setHostType(1);
        return host;
    }

    protected Host createHostByText(String name, String format) {
        String ip = null;
        String id = null;
        String pw = null;
        if (format == null || format.length() == 0) {
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(format, ",");
        if (st.hasMoreTokens()) {
            ip = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            id = st.nextToken().trim();
        }
        if (st.hasMoreTokens()) {
            pw = st.nextToken().trim();
        }
        if (!IPMILanCommand.isIPAddress(ip)) {
            return null;
        }
        pw = this.decode(name, pw);
        Host host = new Host();
        host.setName(name);
        host.setIp(ip);
        if (id != null && id.length() != 0) {
            host.setUsername(id);
        }
        if (pw != null && pw.length() != 0) {
            host.setPassword(pw);
        }
        host.setHostType(0);
        return host;
    }

    public String decode(String hostname, String value) {
        if (value == null) {
            return null;
        }
        byte[] key = new byte[16];
        int hostNameLength = hostname.getBytes().length;
        System.arraycopy(hostname.getBytes(), 0, key, 0, hostNameLength > 16 ? 16 : hostNameLength);
        String encryptedStr = value.substring(value.indexOf(",") + 1, value.length());
        byte[] input = null;
        try {
            input = ByteUtility.toBinArray(encryptedStr);
        }
        catch (Exception ex) {
            return value;
        }
        byte[] decrypted = this.aes.decrypt(this.iv, key, input);
        if (decrypted == null) {
            return value;
        }
        return new String(decrypted).trim();
    }

    public String encode(String hostname, String value) {
        byte[] key = new byte[16];
        int hostNameLength = hostname.getBytes().length;
        System.arraycopy(hostname.getBytes(), 0, key, 0, hostNameLength > 16 ? 16 : hostNameLength);
        byte[] input = new byte[value.getBytes().length + (16 - value.getBytes().length % 16)];
        System.arraycopy(value.getBytes(), 0, input, 0, value.getBytes().length);
        byte[] encryptedBytes = this.aes.encrypt(this.iv, key, input);
        String encodeStr = ByteUtility.bytesToHexNoSpace(encryptedBytes);
        return encodeStr;
    }

    public Enumeration<String> getPropertyNames() {
        Enumeration<?> e2 = null;
        try {
            File file = new File(this.filename);
            SortedProperties p = new SortedProperties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            e2 = p.propertyNames();
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            MOut.G().println(fnfe.toString());
        }
        catch (IOException ioe) {
            MOut.G().println(ioe.toString());
        }
        return e2;
    }

    public void removeProperty(String key) {
        try {
            File file = new File(this.filename);
            SortedProperties p = new SortedProperties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.remove(key);
            p.store(new FileOutputStream(file), null);
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            MOut.G().println(fnfe.toString());
        }
        catch (IOException ioe) {
            MOut.G().println(ioe.toString());
        }
    }

    public void setProperty(String key, String value) {
        try {
            File file = new File(this.filename);
            SortedProperties p = new SortedProperties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.put(key, value);
            p.store(new FileOutputStream(file), null);
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            MOut.G().println(fnfe.toString());
        }
        catch (IOException ioe) {
            MOut.G().println(ioe.toString());
        }
    }

    public String getProperty(String key) {
        try {
            File file = new File(this.filename);
            SortedProperties p = new SortedProperties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            String retStr = p.getProperty(key);
            fis.close();
            return retStr;
        }
        catch (FileNotFoundException fnfe) {
            MOut.G().println(fnfe.toString());
        }
        catch (IOException ioe) {
            MOut.G().println(ioe.toString());
        }
        return null;
    }

    public static void main(String[] args) {
        HostManager.getInstance().load();
        MOut.G().println(HostManager.getInstance().toString());
    }
}

