/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class OOBConfirmCommand
extends SuperBladeCommand {
    @Override
    public boolean preValidate() {
        if (this.parameters == null || this.parameters.length < 8) {
            MOut.G(this).println("<count of raw data> [raw data] <verification offset> <compare byte> <progress byte> <timeout LSB> <timeout MSB>");
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void runCommand() throws Exception {
        int timeout;
        byte progressByte;
        byte successByte;
        byte confirmOffset;
        byte[] data;
        byte cmd;
        byte netfn;
        IPMIMessage resMessage = null;
        try {
            netfn = (byte)Integer.parseInt(this.parameters[1], 16);
            cmd = (byte)Integer.parseInt(this.parameters[2], 16);
            int dataSize = (byte)Integer.parseInt(this.parameters[0], 16) - 2;
            data = new byte[dataSize];
            for (int i2 = 0; i2 < dataSize; ++i2) {
                data[i2] = (byte)Integer.parseInt(this.parameters[3 + i2], 16);
            }
            confirmOffset = (byte)Integer.parseInt(this.parameters[dataSize + 3], 16);
            successByte = (byte)Integer.parseInt(this.parameters[dataSize + 4], 16);
            progressByte = (byte)Integer.parseInt(this.parameters[dataSize + 5], 16);
            timeout = Integer.parseInt(this.parameters[dataSize + 6], 16) + (Integer.parseInt(this.parameters[dataSize + 7], 16) << 8);
        }
        catch (NumberFormatException ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 147;
            return;
        }
        IPMIMessage ipmiMessage = new IPMIMessage();
        netfn = (byte)(netfn << 2);
        ipmiMessage.setCommandAndData(netfn, cmd, data);
        int i3 = 0;
        while (true) {
            if (i3 >= timeout) {
                MOut.G(this).println("\nTime out");
                this.statusCode = 145;
                return;
            }
            resMessage = this.ipmiCMMOEMCommand.getIPMIInterface().send(ipmiMessage);
            if (resMessage != null) {
                if (resMessage.completionCode != 0) {
                    MOut.G(this).println("Completion Code: " + ByteUtility.byteToHex(resMessage.completionCode));
                    this.statusCode = 149;
                    return;
                }
                if (resMessage.data[confirmOffset] == successByte) {
                    MOut.G(this).println("\nSuccess");
                    this.statusCode = 0;
                    return;
                }
                if (resMessage.data[confirmOffset] != progressByte) {
                    MOut.G(this).println(ByteUtility.bytesToHex(resMessage.data));
                    MOut.G(this).println("\nFailed");
                    this.statusCode = 149;
                    return;
                }
            } else {
                MOut.G(this).println("\nNetwork connect failed after retry connect\nCan't connect to " + this.config.getIp());
                System.exit(145);
            }
            MOut.G(this).print(".");
            Thread.sleep(1000L);
            ++i3;
        }
    }
}

