/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMII2CPMBusCommand;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class PSFRUInfoCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMII2CPMBusCommand ipmiI2CPMBusCommand = new IPMII2CPMBusCommand(null);
        ipmiI2CPMBusCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte busID = 0;
        byte slaveAddr = 0;
        if (this.parameters == null) {
            ipmiI2CPMBusCommand.detectBusID();
            ipmiI2CPMBusCommand.detectSlaveAddressFRU();
            if (ipmiI2CPMBusCommand.getBusID() == 0) {
                MOut.G(this).println("Cannot detect BusID");
                this.statusCode = 147;
                return;
            }
            if (ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU() == null) {
                MOut.G(this).println("Cannot detect FRU slave address (PWS-721P doesn't support FRU)");
                this.statusCode = 147;
                return;
            }
            for (int i2 = 0; i2 < ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU().length; ++i2) {
                String moduleLabel = "";
                int module = ipmiI2CPMBusCommand.getModuleByFRU(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU()[i2]);
                if (module != 0) {
                    moduleLabel = "[Module " + module + "]";
                }
                MOut.G(this).println(" [SlaveAddress = " + ByteUtility.byteToHex(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU()[i2]) + "h] " + moduleLabel);
                ipmiI2CPMBusCommand.setSlaveAddrFRU(ipmiI2CPMBusCommand.getAvailableSlaveAddrsFRU()[i2]);
                IPMII2CPMBusCommand.FRUHealth fruHealth = ipmiI2CPMBusCommand.getAllFRU();
                MOut.G(this).println(fruHealth.toFormatedHeader() + fruHealth.toFormatedString());
            }
        } else {
            if (this.parameters.length < 2) {
                MOut.G(this).println("[<busId> <SlaveAddr>] both parameters required");
                this.statusCode = 147;
                return;
            }
            try {
                busID = (byte)Integer.parseInt(this.parameters[0], 16);
                slaveAddr = (byte)Integer.parseInt(this.parameters[1], 16);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                this.statusCode = 147;
                return;
            }
            ipmiI2CPMBusCommand.setBusID(busID);
            ipmiI2CPMBusCommand.setSlaveAddrFRU(slaveAddr);
            IPMII2CPMBusCommand.FRUHealth fruHealth = ipmiI2CPMBusCommand.getAllFRU();
            MOut.G(this).println(fruHealth.toFormatedHeader() + fruHealth.toFormatedString());
        }
    }
}

