/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICMMOEMCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.blade.BladeSystemEntity;
import com.supermicro.ipmi.blade.CMMModuleEntity;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.ShellStatusException;

public abstract class SuperBladeCommand
extends Command {
    IPMICMMOEMCommand ipmiCMMOEMCommand = null;
    ISessionController sessionController = null;
    boolean isMaster = false;
    boolean isExceptionTracking = false;
    String masterIP;

    @Override
    public void execute() throws Exception {
        GlobalDefine.PAUSE_DEBUG = true;
        boolean b2 = this.preValidate();
        if (!b2) {
            this.statusCode = 147;
            return;
        }
        this.ipmiCMMOEMCommand = new IPMICMMOEMCommand(null);
        try {
            this.sessionController = SessionControllerFactory.createSessionControllerWithAutomaticllyCheckPrivilegeEx(this.config, this.ipmiCMMOEMCommand);
        }
        catch (IPMIException ex) {
            MOut.G(this).println(ex.getMessage());
            String message = ex.getMessage();
            if (message.indexOf("connect") != -1) {
                this.statusCode = 145;
            } else if (message.indexOf("login") != -1) {
                this.statusCode = 146;
            }
            return;
        }
        this.isMaster = this.isCurrentCMMMaster();
        try {
            GlobalDefine.PAUSE_DEBUG = false;
            this.runCommand();
            GlobalDefine.PAUSE_DEBUG = true;
        }
        catch (ShellStatusException sse) {
            MOut.G(this).println(sse.getMessage());
            this.statusCode = sse.getStatusCode();
            return;
        }
        catch (Exception e2) {
            if (this.isExceptionTracking) {
                MOut.G(this).println("Exception:");
                e2.printStackTrace();
            } else {
                MOut.G(this).println("Exception:" + e2.getMessage());
            }
            this.statusCode = 148;
            return;
        }
        b2 = this.sessionController.closeSession();
        GlobalDefine.PAUSE_DEBUG = false;
    }

    public boolean preValidate() {
        return true;
    }

    public abstract void runCommand() throws Exception;

    public boolean isBladePresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getBlades()[--index].getPresent() != 0;
    }

    public boolean isCMMPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getCmmModules()[--index].getPresent() != 0;
    }

    public boolean isPowerSupplyPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getPowerSupplies()[--index].getPresent() != 0;
    }

    public boolean isGigabitPresent(int index) {
        --index;
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        if (bladeSystem != null) {
            switch (index) {
                case 0: 
                case 1: {
                    if (bladeSystem.getGigabitSwitchs()[index].getPresent() == 0) break;
                    return true;
                }
                case 2: 
                case 3: {
                    if (bladeSystem.getTenGSwitches()[index - 2].getPresent() != 0 && bladeSystem.getTenGSwitches()[index - 2].is10GSwitch()) {
                        return true;
                    }
                    if (bladeSystem.getGigabitSwitchs().length != 4 || bladeSystem.getGigabitSwitchs()[index].getPresent() == 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isIBPresent(int index) {
        BladeSystemEntity bladeSystem = this.getBladeSystemEntity();
        return bladeSystem != null && bladeSystem.getInfiniBands()[--index].getPresent() != 0;
    }

    public BladeSystemEntity getBladeSystemEntity() {
        if (this.ipmiCMMOEMCommand == null) {
            return null;
        }
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        if (bladeSystem.isLoginSuccessful) {
            return bladeSystem;
        }
        return null;
    }

    public boolean isConnectToCMM(int cmmIndex) {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        CMMModuleEntity cmm = bladeSystem.getCmmModules()[cmmIndex];
        return cmm.isConnected();
    }

    public boolean isCurrentCMMMaster() {
        BladeSystemEntity bladeSystem = new BladeSystemEntity(this.config);
        bladeSystem.setEnableAllQuery(false);
        bladeSystem.setIsQueryCMMModuleEntity(true);
        bladeSystem.setUseExistConnection(true);
        bladeSystem.setIpmiCMMOEMCommand(this.ipmiCMMOEMCommand);
        bladeSystem.getData();
        for (int i2 = 0; i2 < 2; ++i2) {
            CMMModuleEntity cmm = bladeSystem.getCmmModules()[i2];
            if (!cmm.isConnected() || cmm.getMasterSlave() != 0) continue;
            return true;
        }
        try {
            this.masterIP = this.ipmiCMMOEMCommand.getCMMOtherIP();
        }
        catch (IPMIException iPMIException) {
            // empty catch block
        }
        return false;
    }

    public boolean isVirutalMediaSupported() {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            result = false;
        } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
            result = this.isMaster;
        } else if (IPMIMessagingCommand.isPepperconGUID(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isSIMBL(guid)) {
            result = true;
        } else if (IPMIMessagingCommand.isOSAGUID(guid)) {
            result = false;
        }
        return result;
    }

    public void printSlaveCMMUnavailableMessage() {
        MOut.G(this).println("This function is unavailable for this device or slave CMM.");
        if (this.masterIP != null) {
            MOut.G(this).println("Please connect to Master CMM(IP : " + this.masterIP + ")");
        }
    }

    public int getBladeMaxSize() {
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid != null && IPMIMessagingCommand.isCMMGUID(guid)) {
            byte bladeSize = guid[8];
            byte cmmModuleSize = guid[9];
            byte powerSupplySize = guid[10];
            byte infiniBandSize = guid[11];
            byte gigabitSwitchSize = guid[12];
            return bladeSize;
        }
        return 0;
    }
}

