/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuperBladeTool {
    public static String version = "2.5.4";
    public static String buildNo = "130704";
    public static String softwareName = "SMC IPMI Tool V" + version + "(Build " + buildNo + ") - Super Micro Computer, Inc.";
    public static final boolean DEBUG = false;

    public static void main(String[] args) {
        SuperBladeTool smcIPMITool = new SuperBladeTool();
        smcIPMITool.execute(args);
    }

    public void execute(String[] args) {
        SuperBladeTool.setDebugLevel();
        try {
            SuperBladeTool.addDir(".");
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
        }
        if (args.length < 3) {
            SuperBladeTool.usage();
            System.exit(182);
        }
        Parser parser = new Parser();
        String ip = args[0];
        String username = args[1];
        String password = args[2];
        if (!SuperBladeTool.validateIP(ip)) {
            MOut.G().println("IP format erorr !");
            System.exit(181);
        }
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        String[] subArgs = new String[args.length - 3];
        System.arraycopy(args, 3, subArgs, 0, subArgs.length);
        Command command = parser.parse(parser.argumentRoot, subArgs);
        if (command == null) {
            System.exit(180);
        }
        command.setConfig(config);
        command.setOriginalParser(parser);
        try {
            command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(command.getStatusCode());
    }

    public static void usage() {
        MOut.G().println("");
        MOut.G().println(softwareName);
        MOut.G().println("Usage:");
        MOut.G().println("      SMCIPMITool <IP> <username> <password> [commands ... ]");
    }

    public static void ver() {
        MOut.G().println(softwareName);
    }

    public static boolean validateIP(String ip) {
        Pattern macPattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher m = macPattern.matcher(ip);
        return m.matches();
    }

    public static void addDir(String s) throws IOException {
        try {
            Field field = ClassLoader.class.getDeclaredField("usr_paths");
            field.setAccessible(true);
            String[] paths = (String[])field.get(null);
            for (int i2 = 0; i2 < paths.length; ++i2) {
                if (!s.equals(paths[i2])) continue;
                return;
            }
            String[] tmp = new String[paths.length + 1];
            System.arraycopy(paths, 0, tmp, 0, paths.length);
            tmp[paths.length] = s;
            field.set(null, tmp);
        }
        catch (IllegalAccessException e2) {
            throw new IOException("Failed to get permissions to set library path");
        }
        catch (NoSuchFieldException e3) {
            throw new IOException("Failed to get field handle to set library path");
        }
    }

    public static void setDebugLevel() {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        int debug_level = 0;
        try {
            debug_level = Integer.parseInt(ca.getProperty("debug_level"));
        }
        catch (NumberFormatException ex) {
            debug_level = 0;
        }
        GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL = debug_level;
    }
}

