/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.softkeyboard;

import com.ami.kvm.jviewer.hid.KVMClient;
import com.supermicro.softkeyboard.SoftKeyboardPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SoftKeyboardDialog
extends JDialog {
    String title = "Soft Keyboard";
    String version = "v0.96";
    SoftKeyboardPanel softKeyboardPanel;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();

    public SoftKeyboardDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.setDefaultCloseOperation(2);
            this.jbInit();
            this.myInit();
            this.pack();
            this.requestFocusInWindow();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 200) {
            this.requestFocusInWindow();
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            // empty if block
        }
        if (keyEvent.getID() == 402) {
            // empty if block
        }
        super.processKeyEvent(keyEvent);
    }

    private void myInit() {
        this.softKeyboardPanel = new SoftKeyboardPanel();
        this.getContentPane().add((Component)this.softKeyboardPanel, "Center");
        this.getContentPane().setSize(this.softKeyboardPanel.getPreferredSize());
        this.pack();
        this.setTitle(this.title + " " + this.version);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                mouseEvent.getComponent().requestFocusInWindow();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
    }

    public SoftKeyboardDialog() {
        this(new Frame(), "SoftKeyboardDialog", false);
    }

    private void jbInit() throws Exception {
        this.panel1.setLayout(this.borderLayout1);
        this.getContentPane().add(this.panel1);
    }

    public void setKVMClient(KVMClient kVMClient) {
        this.softKeyboardPanel.softKeyboard.setKvmClient(kVMClient);
    }
}

