/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import javax.mail.internet.ParseException;

public class HeaderTokenizer {
    private String string;
    private boolean skipComments;
    private String delimiters;
    private int currentPos;
    private int maxPos;
    private int nextPos;
    private int peekPos;
    public static final String RFC822 = "()<>@,;:\\\"\t .[]";
    public static final String MIME = "()<>@,;:\\\"\t []/?=";
    private static final Token EOFToken = new Token(-4, null);

    public HeaderTokenizer(String string, String string2, boolean bl) {
        this.string = string == null ? "" : string;
        this.skipComments = bl;
        this.delimiters = string2;
        this.peekPos = 0;
        this.nextPos = 0;
        this.currentPos = 0;
        this.maxPos = this.string.length();
    }

    public HeaderTokenizer(String string, String string2) {
        this(string, string2, true);
    }

    public HeaderTokenizer(String string) {
        this(string, RFC822);
    }

    public Token next() throws ParseException {
        this.currentPos = this.nextPos;
        Token token = this.getNext();
        this.nextPos = this.peekPos = this.currentPos;
        return token;
    }

    public Token peek() throws ParseException {
        this.currentPos = this.peekPos;
        Token token = this.getNext();
        this.peekPos = this.currentPos;
        return token;
    }

    public String getRemainder() {
        return this.string.substring(this.nextPos);
    }

    private Token getNext() throws ParseException {
        int n;
        if (this.currentPos >= this.maxPos) {
            return EOFToken;
        }
        if (this.skipWhiteSpace() == -4) {
            return EOFToken;
        }
        boolean bl = false;
        char c2 = this.string.charAt(this.currentPos);
        while (c2 == '(') {
            n = ++this.currentPos;
            int n2 = 1;
            while (n2 > 0 && this.currentPos < this.maxPos) {
                c2 = this.string.charAt(this.currentPos);
                if (c2 == '\\') {
                    ++this.currentPos;
                    bl = true;
                } else if (c2 == '\r') {
                    bl = true;
                } else if (c2 == '(') {
                    ++n2;
                } else if (c2 == ')') {
                    --n2;
                }
                ++this.currentPos;
            }
            if (n2 != 0) {
                throw new ParseException("Unbalanced comments");
            }
            if (!this.skipComments) {
                String string = bl ? HeaderTokenizer.filterToken(this.string, n, this.currentPos - 1) : this.string.substring(n, this.currentPos - 1);
                return new Token(-3, string);
            }
            if (this.skipWhiteSpace() == -4) {
                return EOFToken;
            }
            c2 = this.string.charAt(this.currentPos);
        }
        if (c2 == '\"') {
            n = ++this.currentPos;
            while (this.currentPos < this.maxPos) {
                c2 = this.string.charAt(this.currentPos);
                if (c2 == '\\') {
                    ++this.currentPos;
                    bl = true;
                } else if (c2 == '\r') {
                    bl = true;
                } else if (c2 == '\"') {
                    ++this.currentPos;
                    String string = bl ? HeaderTokenizer.filterToken(this.string, n, this.currentPos - 1) : this.string.substring(n, this.currentPos - 1);
                    return new Token(-2, string);
                }
                ++this.currentPos;
            }
            throw new ParseException("Unbalanced quoted string");
        }
        if (c2 < ' ' || c2 >= '\u007f' || this.delimiters.indexOf(c2) >= 0) {
            ++this.currentPos;
            char[] cArray = new char[]{c2};
            return new Token(c2, new String(cArray));
        }
        n = this.currentPos;
        while (this.currentPos < this.maxPos) {
            c2 = this.string.charAt(this.currentPos);
            if (c2 < ' ' || c2 >= '\u007f' || c2 == '(' || c2 == ' ' || c2 == '\"' || this.delimiters.indexOf(c2) >= 0) break;
            ++this.currentPos;
        }
        return new Token(-1, this.string.substring(n, this.currentPos));
    }

    private int skipWhiteSpace() {
        while (this.currentPos < this.maxPos) {
            char c2 = this.string.charAt(this.currentPos);
            if (c2 != ' ' && c2 != '\t' && c2 != '\r' && c2 != '\n') {
                return this.currentPos;
            }
            ++this.currentPos;
        }
        return -4;
    }

    private static String filterToken(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\n' && bl2) {
                bl2 = false;
            } else {
                bl2 = false;
                if (!bl) {
                    if (c2 == '\\') {
                        bl = true;
                    } else if (c2 == '\r') {
                        bl2 = true;
                    } else {
                        stringBuffer.append(c2);
                    }
                } else {
                    stringBuffer.append(c2);
                    bl = false;
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static class Token {
        private int type;
        private String value;
        public static final int ATOM = -1;
        public static final int QUOTEDSTRING = -2;
        public static final int COMMENT = -3;
        public static final int EOF = -4;

        public Token(int n, String string) {
            this.type = n;
            this.value = string;
        }

        public int getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

