/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nn.pp.rc.ChatFrame;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.RCCanvasPanel;
import nn.pp.rc.RCProto;
import nn.pp.rc.RCRenderer;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.Semaphore;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rc.TrafficMonitor;
import nn.pp.rc.VideoSettingsFrame;
import nn.pp.rckbd.KeyboardEvent;
import nn.pp.rckbd.KeyboardListener;

public abstract class RCHandler
extends Thread
implements KeyboardListener {
    public static final boolean debug = false;
    protected RCHandler child;
    protected RCHandler parent;
    protected ServerConsolePanelBase scp;
    protected RCCanvasPanel canvas;
    protected ChatFrame chat;
    protected MouseHandler mhandler1;
    protected MouseHandler mhandler2;
    protected TrafficMonitor tmoni;
    protected VideoSettingsFrame vsframe;
    protected PrintStream logger;
    protected RCProto proto;
    protected RFBProfile profile;
    public boolean fps = false;
    private Semaphore startsema;

    protected abstract int processProtocol() throws IOException;

    protected abstract void writeKeyboardEvent(byte var1) throws IOException;

    protected abstract void writeKvmSwitchEvent(short var1) throws IOException;

    protected abstract void establishConnection() throws IOException;

    public void sendPlay() throws IOException {
    }

    public void sendPause() throws IOException {
    }

    public void sendStop() throws IOException {
    }

    public void sendSpeed(int speed) throws IOException {
    }

    public void sendSeek(Date pos) throws IOException {
    }

    public void setBlank(boolean blank) {
    }

    public abstract void distributeProto();

    protected abstract RCRenderer getRenderer();

    public RCHandler() {
    }

    public RCHandler(RCHandler parent, RFBProfile profile) {
        this.setClasses(parent.scp, parent.canvas, parent.chat, parent.tmoni, parent.vsframe, parent.mhandler1, parent.mhandler2, parent.logger, profile);
        this.parent = parent;
        parent.child = this;
    }

    public RCHandler(ServerConsolePanelBase scp, RCCanvasPanel canvas, ChatFrame chat, TrafficMonitor tmoni, VideoSettingsFrame vsframe, MouseHandler mhandler1, MouseHandler mhandler2, PrintStream logger, RFBProfile profile) {
        this.setClasses(scp, canvas, chat, tmoni, vsframe, mhandler1, mhandler2, logger, profile);
    }

    protected void setClasses(ServerConsolePanelBase scp, RCCanvasPanel canvas, ChatFrame chat, TrafficMonitor tmoni, VideoSettingsFrame vsframe, MouseHandler mhandler1, MouseHandler mhandler2, PrintStream logger, RFBProfile profile) {
        this.scp = scp;
        this.canvas = canvas;
        this.chat = chat;
        this.tmoni = tmoni;
        this.vsframe = vsframe;
        this.mhandler1 = mhandler1;
        this.mhandler2 = mhandler2;
        this.logger = logger;
        this.profile = profile;
        this.startsema = new Semaphore(1);
    }

    public void switchFPS() {
        this.fps = !this.fps;
    }

    public MouseHandler getMouseHandler() {
        return this.mhandler1;
    }

    public void setScreenSize(int w, int h2) {
    }

    public void connect() {
        this.startsema.get();
        if (this.proto.connected()) {
            this.disconnectFunc();
        }
        this.start();
    }

    public void disconnect() {
        this.startsema.get();
        if (this.child != null) {
            this.child.disconnect();
        }
        this.disconnectFunc();
        this.startsema.post();
    }

    protected void disconnectFunc() {
        if (this.proto != null && this.proto.connected()) {
            this.proto.close();
            this.proto = null;
        }
        try {
            this.join(500L);
            if (this.isAlive()) {
                System.out.println("Frame: cleanup: thread " + this + "still alive, killing forcefully!");
                this.stop();
                if (this.parent != null) {
                    this.parent.distributeProto();
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.sleep(500L);
            this.establishConnection();
            this.scp.connected(this);
        }
        catch (Exception e2) {
            this.logException(T._("unable to connect!"), e2);
            e2.printStackTrace();
            if (e2.toString().indexOf("exclusive access active") != -1) {
                this.scp.setExclusiveMode(true);
            }
            this.scp.disconnected(this);
            this.disposeConnect();
            return;
        }
        finally {
            this.startsema.post();
        }
        try {
            this.distributeProto();
            int q = this.processProtocol();
            this.showQuitMsg(q);
        }
        catch (Exception exception) {
        }
        finally {
            this.scp.disconnected(this);
            if (this.proto != null) {
                this.proto.close();
            }
            this.dispose();
        }
    }

    protected abstract void showQuitMsg(int var1);

    protected abstract void dispose();

    protected abstract void disposeConnect();

    protected String mode() {
        return "RFB";
    }

    private void logException(String text, Exception e2) {
        String msg = e2.getMessage();
        e2.printStackTrace();
        if (msg != null) {
            this.logger.println(this.mode() + ": " + T._("error") + ": " + e2);
        }
        this.logger.println(this.mode() + ": " + text + " " + (msg != null ? msg : e2.toString()) + "!");
    }

    @Override
    public void fired(KeyboardEvent e2) {
        try {
            this.writeKeyboardEvent(e2.keycode);
        }
        catch (IOException ignore) {
            this.logger.println(T._("Can't write keycode:") + " " + ignore);
        }
    }
}

