/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintStream;
import nn.pp.rc.ChatFrame;
import nn.pp.rc.ForensicPanel;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.J11ByteColorRFBRenderer;
import nn.pp.rc.J11TrueColorRFBRenderer;
import nn.pp.rc.J14ByteColorRFBRenderer;
import nn.pp.rc.J14TrueColorRFBRenderer;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.RCCanvasPanel;
import nn.pp.rc.RCHandler;
import nn.pp.rc.RCRenderer;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.RFBRenderer;
import nn.pp.rc.RFBproto;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;
import nn.pp.rc.TrafficMonitor;
import nn.pp.rc.VideoSettingsFrame;

public abstract class RFBHandler
extends RCHandler
implements ActionListener {
    RFBproto rfbProto;
    RFBRenderer rdr = null;
    RFBRenderer rdr16 = null;
    RFBRenderer rdr8 = null;
    ForensicPanel forensicPanel;
    boolean pendingFormatChange = false;
    protected boolean repaint_scheduled = false;
    protected GenericTimer repaint_timer;

    public RFBHandler(RCHandler parent, RFBProfile profile) {
        super(parent, profile);
    }

    public RFBHandler(ServerConsolePanelBase scp, RCCanvasPanel canvas, ChatFrame chat, TrafficMonitor tmoni, VideoSettingsFrame vsframe, MouseHandler mhandler1, MouseHandler mhandler2, PrintStream logger, RFBProfile profile) {
        super(scp, canvas, chat, tmoni, vsframe, mhandler1, mhandler2, logger, profile);
    }

    public RFBHandler() {
    }

    public abstract void init(ServerConsolePanelBase var1, RCCanvasPanel var2, ChatFrame var3, TrafficMonitor var4, VideoSettingsFrame var5, MouseHandler var6, MouseHandler var7, PrintStream var8, RFBProfile var9);

    @Override
    public RCRenderer getRenderer() {
        return this.rdr;
    }

    public RFBproto getRFBProto() {
        return this.rfbProto;
    }

    @Override
    protected abstract void establishConnection() throws IOException;

    @Override
    public void disconnect() {
        super.disconnect();
        this.dispose();
    }

    @Override
    protected void disposeConnect() {
        this.scp.disconnected(this);
    }

    @Override
    protected void dispose() {
        this.rdr.dispose();
        if (this.parent != null) {
            this.parent.distributeProto();
        }
        this.scp.disconnected(this);
    }

    @Override
    public void distributeProto() {
        this.rdr.setRFBProto(this.rfbProto);
        if (this.chat != null) {
            this.chat.setRFBProto(this.rfbProto);
        }
        this.mhandler1.setRCProto(this.rfbProto);
        if (this.mhandler2 != null) {
            this.mhandler2.setRCProto(this.rfbProto);
        }
        this.tmoni.setStreams(this.rfbProto.min, this.rfbProto.mout);
        if (this.vsframe != null) {
            this.vsframe.setRFBproto(this.rfbProto);
        }
        this.canvas.setRCHandler(this);
        this.logger.println(this.canvas);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.repaint_scheduled = true;
    }

    public abstract void sendFormatAndEncodings(boolean var1) throws IOException;

    abstract void sendFramebufferUpdateRequest() throws IOException;

    abstract void sendFullFramebufferUpdateRequest() throws IOException;

    @Override
    public void setBlank(boolean blank) {
        if (this.rdr != null) {
            this.rdr.setBlank(blank);
        }
    }

    @Override
    public String toString() {
        if (this.proto == null) {
            return T._("not connected");
        }
        return this.rfbProto.getSecDesc();
    }

    protected RFBRenderer loadRFBRenderer(Component scc, boolean truecolor) {
        RFBRenderer r;
        if (truecolor && JVMVersionInfo.getJVMVersionInfo().isJava14()) {
            r = new J14TrueColorRFBRenderer(scc);
            this.rdr16 = r;
        } else if (truecolor) {
            r = new J11TrueColorRFBRenderer(scc);
            this.rdr16 = r;
        } else if (JVMVersionInfo.getJVMVersionInfo().isJava14()) {
            r = new J14ByteColorRFBRenderer(scc);
            this.rdr8 = r;
        } else {
            r = new J11ByteColorRFBRenderer(scc);
            this.rdr8 = r;
        }
        return r;
    }
}

