/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import nn.pp.rc.ButtonPanel;
import nn.pp.rc.ChatFrame;
import nn.pp.rc.CloseablePanel;
import nn.pp.rc.ComponentWriter;
import nn.pp.rc.ConfirmDialog;
import nn.pp.rc.CursorType;
import nn.pp.rc.CustomCursor;
import nn.pp.rc.DriveRedirectionContainer;
import nn.pp.rc.ExampleFileFilter;
import nn.pp.rc.FilePreviewer;
import nn.pp.rc.FixedLabel;
import nn.pp.rc.FocusHandler;
import nn.pp.rc.ForensicPanel;
import nn.pp.rc.HotkeyMenu;
import nn.pp.rc.ImageButton;
import nn.pp.rc.ImageLoader;
import nn.pp.rc.JVMVersionInfo;
import nn.pp.rc.Jim;
import nn.pp.rc.KeyboardMouseSettingPanel;
import nn.pp.rc.Logger;
import nn.pp.rc.MenuLabel;
import nn.pp.rc.MouseHandler;
import nn.pp.rc.MouseHandlerAbsolute;
import nn.pp.rc.MouseHandlerRelative;
import nn.pp.rc.MyCBMenuItem;
import nn.pp.rc.PlainFlowText;
import nn.pp.rc.QuickShotThumbnailPanel;
import nn.pp.rc.RCCanvasPanel;
import nn.pp.rc.RCHandler;
import nn.pp.rc.RFBEncoding;
import nn.pp.rc.RFBHandler;
import nn.pp.rc.RFBHandlerFactory;
import nn.pp.rc.RFBProfile;
import nn.pp.rc.ServerConsoleFrame;
import nn.pp.rc.StateMessageInterface;
import nn.pp.rc.T;
import nn.pp.rc.ToolTip;
import nn.pp.rc.TrafficMonitor;
import nn.pp.rc.VideoSettingsFrame;
import nn.pp.rckbd.KbdFactory;
import nn.pp.rckbd.KeyEventHandler;
import nn.pp.rckbd.SoftKbd;
import smc.ext.KVMType;

public abstract class ServerConsolePanelBase
extends Panel
implements FocusHandler,
ItemListener,
ActionListener,
MouseListener {
    boolean isTestVideoResultAvailable = false;
    int testVideoResult = 100;
    GraphicsDevice graphicsDevice;
    DisplayMode orgdm;
    boolean isFullScreenMode = false;
    JFrame fullFrame;
    ImageIcon imageStart;
    ImageIcon imageStop;
    ImageIcon imageFullScreen;
    ImageIcon imageScreenShot;
    ImageIcon imageQuickShot;
    ImageIcon imageQuickShotView;
    ImageIcon imageZoomIn;
    ImageIcon imageZoomOut;
    JButton buttonStart;
    JButton buttonStop;
    JButton buttonFullScreen;
    JButton buttonScreenShot;
    JButton buttonQuickShot;
    JButton buttonQuickShotView;
    JButton buttonZoomIn;
    JButton buttonZoomOut;
    Choice comboBoxzoomStep;
    JToolBar smCtrlPane;
    JFileChooser saveFileChooser = new JFileChooser();
    String saveFilename;
    BufferedImage image;
    boolean isShowThumbnailPanel = false;
    QuickShotThumbnailPanel quickShotThumbnailPanel = new QuickShotThumbnailPanel();
    FilePreviewer filePreviewer = new FilePreviewer();
    BufferedImage quickShotImage;
    Image thumbnail;
    boolean isFristTimeQuickShot = true;
    KeyboardMouseSettingPanel keyboardMouseSettingPanel = null;
    MenuItem miKeyboardMouseSetting;
    public static final boolean debug = false;
    public static String defkbd;
    private static final int SPRIM = 4;
    private MenuItem sc100;
    private MenuItem sc50;
    private MenuItem sc25;
    private MenuItem sc2fit;
    private MenuItem scfilter;
    private MenuItem currentScale = this.sc100;
    private Menu laymi;
    private Menu mapmi;
    private MenuItem hardmapmi;
    private String curlayout;
    private Locale locale;
    private Locale curmapping;
    private Locale curhardmapping;
    private boolean showReduced = false;
    private boolean useScrollPane = false;
    private boolean truecolor = false;
    private ButtonPanel buttonpane;
    private String buttonpane_loc;
    private KeyEventHandler keh;
    private Window softkbdwin = null;
    private SoftKbd softkbd = null;
    public RFBProfile profile;
    private Component sccpanel;
    private ScrollPane sccsp;
    private ChatFrame chat;
    private String boardname;
    private MenuItem cursormi;
    private Image imageButtons;
    private Image wlanimageButtons;
    private Image sharemodeButtons;
    private CheckboxMenuItem itemRO;
    private CheckboxMenuItem itemVNC;
    private CheckboxMenuItem itemExcl = null;
    private CheckboxMenuItem itemChat;
    private CheckboxMenuItem itemSoftKbd;
    private CheckboxMenuItem itemVideoSettings;
    private ImageButton btnRO = null;
    private ImageButton btnWL = null;
    private ImageButton btnSM = null;
    private Dimension btnDim;
    private MenuItem miMouseSyncFast;
    private MenuItem miMouseSyncHard;
    private MenuItem miMouseRel;
    private MenuItem miMouseAbs;
    private MenuItem miVideoRefresh;
    private Menu mMouse;
    private Menu mMouseMode;
    private Menu kbd;
    private Menu encodingMenu;
    private Menu fixSubMenu;
    private Menu compSubMenu;
    private Menu colorSubMenu;
    private CheckboxMenuItem lossymi = null;
    protected boolean showEncodingMenu = true;
    protected boolean showSoftKbdMenu = true;
    protected boolean showHotkeys = true;
    private String synckey;
    protected boolean bneedmouse;
    protected boolean vs_type_full;
    private VideoSettingsFrame vsframe = null;
    private boolean monitorModeOn;
    private boolean monitorPerm;
    private boolean exclusiveAccessPerm = false;
    private boolean exclusiveAccessOn = false;
    private PopupMenu optionmenu;
    public ToolTip mytooltip = null;
    private PlainFlowText wlantext = null;
    private TrafficLabel trafficlabel;
    int drvRedirIndex = 0;
    protected ImageButton btnDrvRedir = null;
    protected ImageButton btnMouseSync;
    protected ImageButton btnMouseMode;
    protected ImageButton btnAA;
    protected ImageButton btnForensic = null;
    protected PopupMenu hotkey_menu;
    protected PopupMenu kvmkey_menu;
    protected Label menu;
    protected Panel stdbtnpane;
    protected Panel[] stdbtnpanecontent;
    protected Panel ctrlpane;
    protected Panel statusbar;
    protected Panel menupane;
    protected Logger logpane;
    private URL codeBase;
    private ClassLoader classLoader;
    private boolean inFrame;
    private ServerConsoleFrame scframe = null;
    RCCanvasPanel console;
    RFBHandler primeRFBHandler;
    RFBHandler currentRFBHandler;
    MouseHandler mhandler;
    MouseHandler mhandler_abs;
    MouseHandler mhandler_rel = null;
    PrintStream logger;
    TrafficMonitor traffic;
    CustomCursor cursors;
    CursorType currentCursor;
    CloseablePanel drvRedirPanel = null;
    private boolean is_wlanEnabled;
    private boolean have_DriveRedir;
    private String softKbdMapping;
    private String localKbdMapping;
    private String kbdLayout;
    private JVMVersionInfo verInfo;
    private StateMessageInterface stateMessenger;
    ForensicPanel forensicPanel;
    private boolean exclusive = false;
    private boolean showDriveRedirection = false;
    private boolean showForensic = false;
    private int userscount = 0;
    private CheckboxMenuItem itemRFB;
    private String noRelativeMouseHandlerReason = null;
    static boolean isAddedEncodeMenu;
    boolean isAddKMSettingMenu = false;
    private boolean wlChatReg = false;
    private boolean wlVideoReg = false;
    BufferedImage orgImage = null;
    BufferedImage capImage = null;

    public ServerConsolePanelBase() {
        ExampleFileFilter filter = new ExampleFileFilter();
        filter.addExtension("jpg");
        filter.addExtension("png");
        filter.setDescription("JPG or PNG Images");
        this.saveFileChooser.setFileFilter(filter);
    }

    protected void LoadSupermicroButton() {
        this.imageStart = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_Start.gif"));
        this.imageStop = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_Stop.gif"));
        this.imageFullScreen = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_FullScreen.gif"));
        this.imageScreenShot = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_Screenshot.gif"));
        this.imageQuickShot = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_QuickShot.gif"));
        this.imageQuickShotView = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_QuickShotView.gif"));
        this.imageZoomIn = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_ZoomIn.gif"));
        this.imageZoomOut = new ImageIcon(ServerConsolePanelBase.class.getResource("SM_ZoomOut.gif"));
        this.buttonStart = new JButton(this.imageStart);
        this.buttonStop = new JButton(this.imageStop);
        this.buttonFullScreen = new JButton(this.imageFullScreen);
        this.buttonScreenShot = new JButton(this.imageScreenShot);
        this.buttonQuickShot = new JButton(this.imageQuickShot);
        this.buttonQuickShotView = new JButton(this.imageQuickShotView);
        this.buttonZoomIn = new JButton(this.imageZoomIn);
        this.buttonZoomOut = new JButton(this.imageZoomOut);
        this.comboBoxzoomStep = new Choice();
        this.buttonStart.setPreferredSize(this.btnDim);
        this.buttonStop.setPreferredSize(this.btnDim);
        this.buttonFullScreen.setPreferredSize(this.btnDim);
        this.buttonScreenShot.setPreferredSize(this.btnDim);
        this.buttonQuickShot.setPreferredSize(this.btnDim);
        this.buttonQuickShotView.setPreferredSize(this.btnDim);
        this.buttonZoomIn.setPreferredSize(this.btnDim);
        this.buttonZoomOut.setPreferredSize(this.btnDim);
        this.buttonStart.setToolTipText(T._("Start video redireciton"));
        this.buttonStop.setToolTipText(T._("Stop video redirection"));
        this.buttonFullScreen.setToolTipText(T._("Full Screen (Alt+Enter)"));
        this.buttonScreenShot.setToolTipText(T._("Capture Screen"));
        this.buttonZoomIn.setToolTipText(T._("Zoom In"));
        this.buttonZoomOut.setToolTipText(T._("Zoom Out"));
        this.comboBoxzoomStep.addItem("300%");
        this.comboBoxzoomStep.addItem("250%");
        this.comboBoxzoomStep.addItem("200%");
        this.comboBoxzoomStep.addItem("150%");
        this.comboBoxzoomStep.addItem("100%");
        this.comboBoxzoomStep.addItem("75%");
        this.comboBoxzoomStep.addItem("50%");
        this.comboBoxzoomStep.addItem("25%");
        this.comboBoxzoomStep.addItem("10%");
        this.comboBoxzoomStep.addItem(T._("Scale to fit"));
        this.comboBoxzoomStep.select("100%");
        this.smCtrlPane = new JToolBar();
        this.smCtrlPane.setFloatable(false);
        this.smCtrlPane.setAlignmentX(0.5f);
        this.smCtrlPane.setAlignmentY(0.5f);
        this.smCtrlPane.add(this.buttonStart);
        this.smCtrlPane.add(this.buttonStop);
        this.smCtrlPane.addSeparator();
        this.smCtrlPane.add(this.buttonFullScreen);
        this.smCtrlPane.add(this.buttonScreenShot);
        this.smCtrlPane.addSeparator();
        this.smCtrlPane.add(this.buttonQuickShot);
        this.smCtrlPane.add(this.buttonQuickShotView);
        this.smCtrlPane.addSeparator();
        this.smCtrlPane.add(this.buttonZoomIn);
        this.smCtrlPane.add(this.comboBoxzoomStep);
        this.smCtrlPane.add(this.buttonZoomOut);
        this.smCtrlPane.addSeparator();
        this.smCtrlPane.setBorderPainted(false);
        this.buttonStart.addActionListener(this);
        this.buttonStop.addActionListener(this);
        this.buttonFullScreen.addActionListener(this);
        this.buttonScreenShot.addActionListener(this);
        this.buttonQuickShot.addActionListener(this);
        this.buttonQuickShotView.addActionListener(this);
        this.buttonZoomIn.addActionListener(this);
        this.buttonZoomOut.addActionListener(this);
        this.buttonStart.addMouseListener(this);
        this.buttonStop.addMouseListener(this);
        this.buttonFullScreen.addMouseListener(this);
        this.buttonScreenShot.addMouseListener(this);
        this.buttonQuickShot.addMouseListener(this);
        this.buttonQuickShotView.addMouseListener(this);
        this.buttonZoomIn.addMouseListener(this);
        this.buttonZoomOut.addMouseListener(this);
        this.comboBoxzoomStep.addMouseListener(this);
        this.comboBoxzoomStep.addItemListener(this);
    }

    protected void SetSupermicroButtonConnectedMode() {
        this.buttonStart.setEnabled(false);
        this.buttonStop.setEnabled(true);
        this.buttonFullScreen.setEnabled(true);
        this.buttonScreenShot.setEnabled(true);
        this.buttonQuickShot.setEnabled(true);
        this.buttonQuickShotView.setEnabled(true);
        this.buttonZoomIn.setEnabled(true);
        this.comboBoxzoomStep.setEnabled(true);
        this.buttonZoomOut.setEnabled(true);
    }

    protected void SetSupermicroButtonDisconnectedMode() {
        this.buttonStart.setEnabled(true);
        this.buttonStop.setEnabled(false);
        this.buttonFullScreen.setEnabled(false);
        this.buttonScreenShot.setEnabled(false);
        this.buttonQuickShot.setEnabled(false);
        this.buttonZoomIn.setEnabled(false);
        this.comboBoxzoomStep.setEnabled(false);
        this.buttonZoomOut.setEnabled(false);
    }

    protected void LoadROButton(boolean monitorMode) {
        this.btnRO = new ImageButton(this.imageButtons, this.btnDim, monitorMode ? 5 : 4, true);
    }

    protected void LoadWLButton() {
        this.btnWL = new ImageButton(this.wlanimageButtons, this.btnDim, 0, true);
    }

    protected void LoadSMButton() {
        this.btnSM = new ImageButton(this.sharemodeButtons, this.btnDim, 0, true);
        this.btnSM.addMouseListener(this);
    }

    public void init(URL codeBase, ClassLoader classLoader, boolean inFrame, StateMessageInterface stateMessenger, JVMVersionInfo verInfo, String boardname, String[] hotkeys, String[] hotkeycodes, String[] hotkeynames, int keypause, boolean monitorMode, boolean monitorPerm, boolean exclusiveOn, boolean exclusivePerm, Locale locale, String synckey, String synckeycodes, String localcursor, boolean exclusiveMouse, int vs_perms, boolean vs_type_full, boolean use_iip, boolean is_wlanEnabled, boolean have_DriveRedir, String softKbdMapping, String localKbdMapping, String kbdLayout) {
        this.codeBase = codeBase;
        this.classLoader = classLoader;
        this.inFrame = inFrame;
        this.stateMessenger = stateMessenger;
        this.boardname = boardname;
        this.synckey = synckey;
        this.monitorPerm = monitorPerm;
        this.monitorModeOn = monitorMode;
        this.exclusiveAccessPerm = exclusivePerm;
        this.exclusiveAccessOn = exclusiveOn;
        this.bneedmouse = use_iip;
        this.locale = locale;
        this.is_wlanEnabled = is_wlanEnabled;
        this.have_DriveRedir = have_DriveRedir;
        this.softKbdMapping = softKbdMapping;
        this.localKbdMapping = localKbdMapping;
        this.kbdLayout = kbdLayout;
        this.verInfo = verInfo;
        this.vs_type_full = vs_type_full;
        this.setLayout(new BorderLayout());
        this.ctrlpane = new Panel(new BorderLayout());
        this.ctrlpane.setBackground(SystemColor.control);
        this.menupane = new Panel(new BorderLayout());
        this.stdbtnpane = new Panel(new BorderLayout());
        this.stdbtnpanecontent = new Panel[2];
        this.stdbtnpanecontent[0] = new Panel(new BorderLayout());
        this.stdbtnpanecontent[1] = new Panel(new BorderLayout());
        this.stdbtnpane.add((Component)this.stdbtnpanecontent[0], "West");
        this.stdbtnpane.add((Component)this.stdbtnpanecontent[1], "East");
        this.logpane = new Logger("", this, this.redirectLogger());
        this.logger = this.logpane.getPrintStream();
        this.btnDim = new Dimension(30, 26);
        ImageLoader imgloader = new ImageLoader(codeBase);
        this.imageButtons = imgloader.loadImage("nn/pp/rc/buttons.gif");
        this.wlanimageButtons = imgloader.loadImage("nn/pp/rc/wlanbars.gif");
        this.sharemodeButtons = imgloader.loadImage("nn/pp/rc/sharemode.gif");
        defkbd = kbdLayout;
        if (defkbd == null || defkbd.length() < 2) {
            defkbd = "pc104";
        }
        this.curlayout = defkbd;
        this.keh = new KeyEventHandler(KbdFactory.getInstance().getKbdLayout(defkbd));
        if (have_DriveRedir) {
            this.btnDrvRedir = new ImageButton(this.imageButtons, this.btnDim, 6);
            this.btnDrvRedir.addActionListener(this);
            this.btnDrvRedir.addMouseListener(this);
        }
        this.cursors = new CustomCursor(localcursor);
        this.currentCursor = this.cursors.getCurrentCursor();
        if (this.bneedmouse) {
            this.btnMouseSync = new ImageButton(T._("Sync"), this.imageButtons, this.btnDim, 2);
            this.btnMouseSync.addActionListener(this);
            this.btnMouseMode = new ImageButton(this.imageButtons, this.btnDim, 1);
            this.btnMouseMode.addActionListener(this);
        }
        this.LoadROButton(monitorMode);
        if (this.btnRO != null) {
            this.btnRO.setEnabled(false);
            this.btnRO.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    if (e2.getClickCount() > 2 && !e2.isAltDown()) {
                        if (e2.isMetaDown()) {
                            ServerConsolePanelBase.this.primeRFBHandler.switchFPS();
                        } else {
                            ServerConsolePanelBase.this.console.debug = !ServerConsolePanelBase.this.console.debug;
                            ServerConsolePanelBase.this.logger.println(T._("Kbd Debug") + " " + (ServerConsolePanelBase.this.console.debug ? T._("on") : T._("off")));
                        }
                    }
                }
            });
        }
        this.wlantext = new PlainFlowText(T._("n/a"));
        if (is_wlanEnabled) {
            this.LoadWLButton();
            if (this.btnWL != null) {
                this.btnWL.setEnabled(false);
                this.btnWL.setImageIndex(2);
            }
        }
        this.LoadSMButton();
        if (this.btnSM != null) {
            this.btnSM.setEnabled(false);
        }
        if (vs_perms != 0) {
            this.vsframe = new VideoSettingsFrame(this, boardname, this.logger, false, monitorMode, vs_perms, vs_type_full);
        }
        this.kvmkey_menu = new HotkeyMenu(T._("KVM keys"), this, this.keh, hotkeys, hotkeycodes, hotkeynames, this.logger, true, keypause);
        this.hotkey_menu = new HotkeyMenu(T._("Hotkeys"), this, this.keh, hotkeys, hotkeycodes, hotkeynames, this.logger, false, keypause);
        try {
            this.chat = new ChatFrame(this, this.logger, codeBase);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        this.console = new RCCanvasPanel(this, locale, this.logger, 640, 480, monitorMode, this.keh, synckeycodes);
        this.buttonpane = new ButtonPanel(this, this.keh, hotkeys, hotkeycodes, hotkeynames, this.logger, monitorMode, keypause);
        this.buttonpane.setPreferredWidth(this.console.getPreferredSize().width);
        this.optionmenu = new PopupMenu(T._("Options"));
        this.menu = new MenuLabel(this.optionmenu);
        this.populateMenu();
        this.populateStdBtnPane();
        this.mhandler = this.mhandler_abs = new MouseHandlerAbsolute(this.console);
        this.noRelativeMouseHandlerReason = null;
        if (this.bneedmouse) {
            if (verInfo.isJava13() && synckey != null && synckey.length() > 0) {
                try {
                    this.mhandler_rel = new MouseHandlerRelative(this.console, this.cursors, this.logger, synckey);
                    this.switchMouseHandler(exclusiveMouse);
                }
                catch (AWTException ignore) {
                    this.noRelativeMouseHandlerReason = new String("Relative mouse mode not supported");
                    System.out.println(this.noRelativeMouseHandlerReason);
                }
                catch (SecurityException ignore) {
                    this.noRelativeMouseHandlerReason = new String("Entering the single mouse mode is not possible\ndue to security restrictions in the Java VM.\nThe most common reason for the problem is\nan applet which is not trusted by the user.\n\nPlease try to restart your browser and\nanswer the question whether the applet should be\ntrusted with \"Yes\" or \"Always\".\nIf this does not help solving the problem,\nlook into the manual about other possible solutions.");
                    System.out.println(this.noRelativeMouseHandlerReason);
                }
            }
            if (this.mhandler_rel == null) {
                this.switchMouseHandler(false);
            }
        } else {
            this.console.setMouseHandler(this.mhandler);
        }
        this.console.setCursor(this.currentCursor.cursor);
        this.allowMouseHandling(!monitorMode);
        this.traffic = new TrafficMonitor(this);
        this.sccsp = new ScrollPane(0);
        this.useScrollPane(true, false);
        Component paneladd = this.getCtrlPanelWest();
        if (paneladd != null) {
            this.ctrlpane.add(paneladd, "West");
        }
        if ((paneladd = this.getCtrlPanelCenter()) != null) {
            this.ctrlpane.add(paneladd, "Center");
        }
        if ((paneladd = this.getCtrlPanelSouth()) != null) {
            this.ctrlpane.add(paneladd, "South");
        }
        if ((paneladd = this.getMenuPanelWest()) != null) {
            this.menupane.add(paneladd, "West");
        }
        if ((paneladd = this.getMenuPanelCenter()) != null) {
            this.menupane.add(paneladd, "Center");
        }
        if ((paneladd = this.getMenuPanelEast()) != null) {
            this.menupane.add(paneladd, "East");
        }
        this.ctrlpane.add((Component)this.menupane, "East");
        this.ctrlpane.remove(this.buttonpane);
        this.LoadSupermicroButton();
        this.SetSupermicroButtonDisconnectedMode();
        this.switchCtrlPaneButtons(false);
        for (int i2 = 0; i2 < this.buttonpane.buttons.size(); ++i2) {
            Component o = (Component)this.buttonpane.buttons.get(i2);
            this.smCtrlPane.add(o);
        }
        this.ctrlpane.add((Component)this.smCtrlPane, "West");
        this.placeCtrlPane();
        this.statusbar = new Panel();
        Panel statusbar2 = new Panel();
        statusbar2.setLayout(new BorderLayout());
        this.statusbar.setLayout(new BorderLayout());
        Panel trayarea = new Panel();
        this.trafficlabel = new TrafficLabel();
        int cbtns = 0;
        if (this.btnRO != null) {
            ++cbtns;
        }
        if (this.btnWL != null) {
            ++cbtns;
        }
        if (this.btnSM != null) {
            ++cbtns;
        }
        trayarea.setLayout(new GridLayout(1, cbtns));
        if (this.btnSM != null) {
            trayarea.add(this.btnSM);
        }
        if (this.btnRO != null) {
            trayarea.add(this.btnRO);
        }
        if (this.btnWL != null) {
            trayarea.add(this.btnWL);
        }
        statusbar2.add((Component)trayarea, "East");
        statusbar2.add((Component)this.trafficlabel, "West");
        this.statusbar.add((Component)statusbar2, "East");
        this.statusbar.add((Component)this.logpane, "Center");
        this.placeStatusBar();
        this.adjustGUIArbitrarily();
        this.enableEvents(101L);
        this.useScrollPane(false, true);
    }

    void setDrvRedirPanel(CloseablePanel p) {
        this.drvRedirPanel = p;
    }

    ForensicPanel addForensicButton(boolean showEvents, boolean localOnly, boolean noKbd, boolean showReplay) {
        ServerConsoleFrame parent = (ServerConsoleFrame)this.getParent();
        this.forensicPanel = parent.addForensicPanel(showEvents, localOnly, noKbd, showReplay);
        if (this.forensicPanel == null) {
            return null;
        }
        this.btnForensic = new ImageButton(this.imageButtons, this.btnDim, 8);
        this.statusbar.add((Component)this.btnForensic, "West");
        this.btnForensic.addActionListener(this);
        this.switchForensic();
        return this.forensicPanel;
    }

    Locale getCurMapping() {
        return this.curmapping;
    }

    protected Component getCtrlPanelWest() {
        if (this.showHotkeys && !this.verInfo.isPJava() && this.suggestButtonLocation(true).equals("West")) {
            return this.buttonpane;
        }
        return null;
    }

    protected Component getCtrlPanelCenter() {
        return null;
    }

    protected Component getCtrlPanelSouth() {
        if (!this.verInfo.isPJava() && this.suggestButtonLocation(true).equals("South")) {
            return this.buttonpane;
        }
        return null;
    }

    protected Component getMenuPanelWest() {
        if (!this.verInfo.isPJava()) {
            return this.stdbtnpane;
        }
        return null;
    }

    protected Component getMenuPanelCenter() {
        return this.menu;
    }

    protected Component getMenuPanelEast() {
        return null;
    }

    protected void placeCtrlPane() {
        this.add((Component)this.ctrlpane, "North");
    }

    protected void placeStatusBar() {
        this.add((Component)this.statusbar, "South");
    }

    protected abstract void populateMenu();

    protected abstract void populateStdBtnPane();

    protected void addMonitorModeMenu() {
        if (this.monitorPerm) {
            this.itemRO = this.createCBMenuItem(T._("Monitor Only"), this, this.monitorModeOn);
            this.optionmenu.add(this.itemRO);
        }
    }

    protected void addExclusiveAccessMenu() {
        if (this.exclusiveAccessPerm) {
            this.itemExcl = this.createCBMenuItem(T._("Exclusive Access"), this, this.exclusiveAccessOn);
            this.optionmenu.add(this.itemExcl);
        }
    }

    protected void addInterpolationMenu() {
        if (this.verInfo.isJava13()) {
            this.scfilter = this.createCBMenuItem(T._("Readability Filter"), this, false);
            this.optionmenu.add(this.scfilter);
        }
    }

    protected void addScalingMenu() {
    }

    protected void addMouseHandlingMenu() {
        if (this.bneedmouse) {
            this.mMouse = new Menu(T._("Mouse Handling"));
            this.miMouseSyncFast = this.createMenuItem(T._("Fast Sync") + " " + (this.synckey != null && this.synckey.length() > 0 ? "(" + this.synckey + ")" : ""), this);
            this.miMouseSyncHard = this.createMenuItem(T._("Intelligent Sync"), this);
            this.mMouseMode = new Menu(T._("Mouse Mode"));
            this.miMouseRel = this.createCBMenuItem(T._("Single Mouse Mode"), this, false);
            this.miMouseAbs = this.createCBMenuItem(T._("Double Mouse Mode"), this, true);
            this.mMouseMode.add(this.miMouseRel);
            this.mMouseMode.add(this.miMouseAbs);
            this.mMouse.add(this.miMouseSyncFast);
            this.mMouse.add(this.miMouseSyncHard);
            this.mMouse.add(this.mMouseMode);
            this.optionmenu.add(this.mMouse);
        }
    }

    protected void addLocalCursorMenu() {
        if (!this.verInfo.isPJava()) {
            this.cursormi = this.createCBMenu(T._("Local Cursor"), this.cursors.getCursors(), this, this.currentCursor);
            this.optionmenu.add(this.cursormi);
        }
    }

    protected void addChatMenu() {
        this.itemChat = this.createCBMenuItem(T._("Chat Window"), this, false);
        this.optionmenu.add(this.itemChat);
    }

    protected void addVideoSettings() {
        this.itemVideoSettings = this.createCBMenuItem(T._("Video Settings"), this, false);
        this.optionmenu.add(this.itemVideoSettings);
        if (this.vsframe == null) {
            this.itemVideoSettings.setEnabled(false);
        }
    }

    protected void addVideoRefresh() {
        this.miVideoRefresh = this.createMenuItem(T._("Refresh Video"), this);
        this.optionmenu.add(this.miVideoRefresh);
    }

    protected void addSoftKbdMenu() {
        String langCode = this.softKbdMapping;
        this.kbd = new Menu(T._("Soft Keyboard"));
        this.itemSoftKbd = new CheckboxMenuItem(T._("Show"));
        this.itemSoftKbd.addItemListener(this);
        this.kbd.add(this.itemSoftKbd);
        if (langCode != null && langCode.length() > 3) {
            this.curmapping = new Locale(langCode.substring(0, 2), langCode.substring(3));
        }
        if (this.curmapping == null) {
            this.curmapping = this.locale;
        }
        this.mapmi = this.createCBMenu(T._("Mapping"), KbdFactory.getInstance().getKbdMappingNames(), this, this.curmapping);
        this.kbd.add(this.mapmi);
        if (this.showSoftKbdMenu) {
            this.optionmenu.add(this.kbd);
        }
    }

    protected void addHardKbdMenu() {
        if (this.curhardmapping == null) {
            this.curhardmapping = this.locale;
        }
        this.console.setKbdLocale(this.curhardmapping);
        this.hardmapmi = this.createCBMenu(T._("Local Keyboard"), KbdFactory.getInstance().getKbdTranslatorNames(), this, this.curhardmapping);
        this.optionmenu.add(this.hardmapmi);
    }

    protected void addHotkeyMenu() {
        if (!this.inFrame) {
            return;
        }
        if (!((HotkeyMenu)this.kvmkey_menu).isEmpty()) {
            this.optionmenu.add(((HotkeyMenu)this.kvmkey_menu).getPlainMenu("KVM keys"));
        }
        if (!((HotkeyMenu)this.hotkey_menu).isEmpty()) {
            this.optionmenu.add(((HotkeyMenu)this.hotkey_menu).getPlainMenu("Hotkeys"));
        }
    }

    protected void addEncodingMenu() {
        RFBEncoding enc = this.profile.encoding;
        this.encodingMenu = new Menu(T._("Encoding"));
        Object[] names = enc.getFixNames();
        this.fixSubMenu = new Menu(T._("Predefined"));
        for (int i2 = 0; i2 < names.length; ++i2) {
            String o = names[i2];
            String n = o instanceof Locale ? ((Locale)((Object)o)).getDisplayName() : T._(o.toString());
            MenuItem mi = new MenuItem(n);
            mi.addActionListener(this);
            this.fixSubMenu.add(mi);
        }
        names = enc.getCompressionNames();
        this.compSubMenu = this.createCBMenu(T._("Compression"), names, this, enc.getCurrentCompName());
        names = enc.getColorNames();
        this.colorSubMenu = this.createCBMenu(T._("Color Depth"), names, this, enc.getCurrentColorName());
        this.encodingMenu.add(this.fixSubMenu);
        this.encodingMenu.add(this.compSubMenu);
        this.encodingMenu.add(this.colorSubMenu);
        if (enc.isHwSupported()) {
            this.lossymi = this.createCBMenuItem("Lossy", this, enc.isLossy());
            this.encodingMenu.add(this.lossymi);
        }
        this.optionmenu.add(this.encodingMenu);
        this.adjustEncodingSubmenus();
    }

    protected void addKeyboardMouseSettingMenu() {
        this.miKeyboardMouseSetting = this.createMenuItem(T._("Keyboard/Mouse Settings..."), this);
        this.optionmenu.add(this.miKeyboardMouseSetting);
    }

    protected void addDrvRedirButton(int index, String location) {
        if (this.btnDrvRedir != null) {
            this.drvRedirIndex = index;
            this.stdbtnpanecontent[index].add((Component)this.btnDrvRedir, location);
        }
    }

    void hideDrvRedirButton() {
        if (this.btnDrvRedir != null) {
            this.stdbtnpanecontent[this.drvRedirIndex].remove(this.btnDrvRedir);
        }
    }

    protected void addAAButton(int index, String location) {
        this.btnAA = new ImageButton(this.imageButtons, this.btnDim, 3);
        this.btnAA.addActionListener(this);
        this.btnAA.addMouseListener(this);
        this.stdbtnpanecontent[index].add((Component)this.btnAA, location);
    }

    protected void addMouseSyncButton(int index, String location) {
        if (!this.verInfo.isPJava() && this.bneedmouse) {
            this.stdbtnpanecontent[index].add((Component)this.btnMouseSync, location);
        }
    }

    protected void addMouseModeButton(int index, String location) {
        if (!this.verInfo.isPJava() && this.bneedmouse) {
            this.stdbtnpanecontent[index].add((Component)this.btnMouseMode, location);
        }
    }

    protected void adjustGUIArbitrarily() {
    }

    protected boolean redirectLogger() {
        return false;
    }

    public boolean displayStateMsg() {
        return true;
    }

    public int adjustStateMsgPos(int height) {
        return height - 3;
    }

    public void start(RFBProfile profile) {
        this.profile = profile;
        this.keyboardMouseSettingPanel = new KeyboardMouseSettingPanel(profile.remoteHost, profile.username, profile.password);
        this.currentRFBHandler = this.primeRFBHandler = RFBHandlerFactory.loadRfbHandler(profile);
        if (this.currentRFBHandler == null) {
            this.logger.println("Unable to load protocol handler!");
            return;
        }
        this.currentRFBHandler.init(this, this.console, this.chat, this.traffic, this.vsframe, this.mhandler_abs, this.mhandler_rel, this.logger, profile);
        if (!isAddedEncodeMenu) {
            if (this.showEncodingMenu && !profile.encoding.isModeAuto()) {
                this.addEncodingMenu();
            }
            isAddedEncodeMenu = true;
        }
        if (!this.isAddKMSettingMenu) {
            this.addKeyboardMouseSettingMenu();
            this.isAddKMSettingMenu = true;
        }
        this.primeRFBHandler.connect();
        this.console.enableEvent();
        this.useScrollPane(true, true);
        if (!this.ifSupportVideoSetting()) {
            this.itemVideoSettings.setEnabled(false);
        }
    }

    public boolean ifSupportVideoSetting() {
        boolean result = false;
        KVMType kvmType = new KVMType();
        kvmType.init(this.profile.remoteHost, this.profile.username, this.profile.password);
        if (kvmType.getKVMType() == 20) {
            result = true;
        }
        return result;
    }

    public void adjustMouseSyncButtonAndMenuBySetting() {
        boolean isWindowsUSBMouseType = this.keyboardMouseSettingPanel.isWindowUSBMouseType();
        if (isWindowsUSBMouseType) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerConsolePanelBase.this.setMouseSyncButtonAndMenuEnable(false);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServerConsolePanelBase.this.setMouseSyncButtonAndMenuEnable(true);
                }
            });
        }
    }

    public void setMouseSyncButtonAndMenuEnable(boolean isEnable) {
        this.btnMouseSync.setEnabled(isEnable);
        this.btnMouseMode.setEnabled(isEnable);
        this.mMouse.setEnabled(isEnable);
    }

    public void stop() {
        if (this.primeRFBHandler != null) {
            this.primeRFBHandler.disconnect();
        }
        if (this.currentRFBHandler != null) {
            if (this.currentRFBHandler.rdr != null) {
                this.currentRFBHandler.rdr.removeOSDTimer();
                this.currentRFBHandler.rdr = null;
            }
            if (this.currentRFBHandler.rdr8 != null) {
                this.currentRFBHandler.rdr8.removeOSDTimer();
                this.currentRFBHandler.rdr8 = null;
            }
            if (this.currentRFBHandler.rdr16 != null) {
                this.currentRFBHandler.rdr16.removeOSDTimer();
                this.currentRFBHandler.rdr16 = null;
            }
        }
        this.keh.removeKeyboardListener(this.currentRFBHandler);
        this.currentRFBHandler = null;
        this.primeRFBHandler = null;
        System.gc();
    }

    public void close() {
        this.console.close();
        this.console.setSize(this.sccsp.getViewportSize());
        this.useScrollPane(false, true);
        this.logpane.close();
        if (this.chat != null) {
            this.chat.close();
        }
        if (this.vsframe != null) {
            this.vsframe.close();
        }
        if (this.softkbdwin != null) {
            this.softkbdwin.hide();
            this.softkbdwin.dispose();
        }
        this.stop();
    }

    public void connected(RCHandler handler) {
        this.switchCtrlPaneButtons(true);
        this.menu.setEnabled(true);
        if (handler == this.primeRFBHandler) {
            if (this.stateMessenger != null) {
                this.stateMessenger.setStateMessage(true);
            }
            if (this.exclusiveAccessOn) {
                try {
                    this.primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive", "on");
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.setShareIcon();
        if (Jim.isCMTest) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ServerConsolePanelBase.this.testVideoResult = ServerConsolePanelBase.this.testVideoSignal();
                    ServerConsolePanelBase.this.isTestVideoResultAvailable = true;
                }
            };
            thread.start();
        }
        this.adjustMouseSyncButtonAndMenuBySetting();
    }

    public void disconnected(RCHandler handler) {
        this.switchCtrlPaneButtons(false);
        if (this.stateMessenger != null) {
            this.stateMessenger.setStateMessage(false);
        }
        this.setExclusive(this.itemRFB);
        this.setShareIcon();
    }

    protected void switchCtrlPaneButtons(boolean switchOn) {
        if (this.btnMouseMode != null) {
            this.btnMouseMode.setEnabled(switchOn);
        }
        if (this.btnAA != null) {
            this.btnAA.setEnabled(switchOn);
        }
        if (this.btnMouseSync != null) {
            this.btnMouseSync.setEnabled(switchOn);
        }
        if (this.btnDrvRedir != null) {
            // empty if block
        }
        this.menu.setEnabled(switchOn);
        this.buttonpane.setEnabled(switchOn);
        if (this.drvRedirPanel != null) {
            this.drvRedirPanel.setEnabled(switchOn);
        }
        if (switchOn) {
            this.SetSupermicroButtonConnectedMode();
        } else {
            this.SetSupermicroButtonDisconnectedMode();
        }
    }

    @Override
    public void handleFocus(Component c2) {
        if (this.verInfo.isJava14()) {
            this.console.requestFocusInWindow();
        } else {
            this.console.requestFocus();
        }
    }

    public void setTitle(String title) {
        this.trafficlabel.setText(title);
    }

    public void setSCFrame(ServerConsoleFrame scframe) {
        this.scframe = scframe;
    }

    public Dimension getBlankSize() {
        Dimension myd = this.getSize();
        Dimension ctd = this.ctrlpane.getSize();
        Dimension stb = this.statusbar.getSize();
        return new Dimension(myd.width, myd.height - ctd.height - stb.height);
    }

    public void canvasSizeChanged(Dimension d2) {
        Container p = this.useScrollPane ? this.sccsp : this;
        p.setSize(d2.width + 4, d2.height + 4);
        if (p instanceof ScrollPane) {
            // empty if block
        }
        this.buttonpane.setPreferredWidth(d2.width);
        if (this.getParent() instanceof Frame) {
            Frame f2 = (Frame)this.getParent();
            Dimension nd = f2.getPreferredSize();
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.verInfo.isJava14()) {
                Insets insets = new J14GetGraphicsConfigurationHelper().getScreenInsets(f2);
                sd.width -= insets.left + insets.right;
                sd.height -= insets.top + insets.bottom;
            }
            if (nd.width > sd.width) {
                nd.width = sd.width;
            }
            if (nd.height > sd.height) {
                nd.height = sd.height;
            }
            f2.setSize(nd);
        }
        this.validate();
        this.handleFocus(null);
    }

    public void adjustLayout() {
        if (this.verInfo.isPJava()) {
            return;
        }
        if (this.buttonpane_loc != this.suggestButtonLocation(true)) {
            this.ctrlpane.remove(this.buttonpane);
            this.ctrlpane.add((Component)this.buttonpane, this.suggestButtonLocation(false));
        }
    }

    @Override
    public void processComponentEvent(ComponentEvent e2) {
        if (e2.getID() == 101) {
            this.buttonpane.setPreferredWidth(this.getSize().width);
        }
        this.console.processEvent(e2);
    }

    public void setSoftKbdLayout(String kbdlayout) {
        if (this.softkbd != null) {
            this.softkbd.setLayout(kbdlayout);
        } else {
            this.keh.init(KbdFactory.getInstance().getKbdLayout(kbdlayout));
        }
        if (this.forensicPanel != null) {
            this.forensicPanel.newKbdLayout(kbdlayout);
        }
        if (this.softkbd != null) {
            this.softkbd.setMapping(this.curmapping);
        }
        if (this.forensicPanel != null) {
            this.forensicPanel.newKbdMapping(this.curmapping);
        }
    }

    protected String suggestButtonLocation(boolean renew) {
        if (null == this.buttonpane_loc || renew) {
            this.buttonpane_loc = this.buttonpane.getPreferredSize().width > this.getMaxButtonPaneSize() ? "South" : "West";
        }
        return this.buttonpane_loc;
    }

    protected int getMaxButtonPaneSize() {
        return 260;
    }

    private void showReduced(boolean so, boolean validate) {
        if (this.verInfo.isPJava()) {
            return;
        }
        if (so == this.showReduced) {
            return;
        }
        this.showReduced = so;
        if (this.showReduced) {
            this.logpane.setTiny(true);
            this.ctrlpane.remove(this.buttonpane);
        } else {
            this.logpane.setTiny(false);
            this.ctrlpane.add((Component)this.buttonpane, this.suggestButtonLocation(false));
        }
        if (validate) {
            this.validate();
        }
    }

    public void useScrollPane(boolean sp, boolean validate) {
        if (sp == this.useScrollPane) {
            return;
        }
        this.useScrollPane = sp;
        if (this.useScrollPane) {
            this.remove(this.console);
            Dimension d2 = this.console.getPreferredSize();
            this.sccsp.setSize(d2.width + 4, d2.height + 4);
            this.add((Component)this.sccsp, "Center");
            this.sccsp.add(this.console);
        } else {
            this.remove(this.sccsp);
            this.add((Component)this.console, "Center");
        }
        if (validate) {
            this.validate();
        }
    }

    private MenuItem createMenuItem(String label, ActionListener l) {
        MenuItem i2 = new MenuItem(label);
        i2.addActionListener(l);
        return i2;
    }

    private CheckboxMenuItem createCBMenuItem(String label, ItemListener l, boolean checked) {
        CheckboxMenuItem i2 = new CheckboxMenuItem(label, checked);
        i2.addItemListener(l);
        return i2;
    }

    private Menu createCBMenu(String label, Object[] names, ItemListener l, Object def) {
        Menu m = new Menu(label);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object o = names[i2];
            String n = o instanceof Locale ? ((Locale)o).getDisplayName() : T._(o.toString());
            MyCBMenuItem mi = new MyCBMenuItem(n, o, o.equals(def));
            mi.addItemListener(l);
            m.add(mi);
        }
        return m;
    }

    private void setExclusive(CheckboxMenuItem mi) {
        if (mi == null) {
            return;
        }
        Menu c2 = (Menu)mi.getParent();
        for (int i2 = 0; i2 < c2.getItemCount(); ++i2) {
            CheckboxMenuItem ci = (CheckboxMenuItem)c2.getItem(i2);
            if (ci == mi) continue;
            ci.setState(false);
        }
        mi.setState(true);
    }

    private void allowMouseHandling(boolean allow) {
        if (this.bneedmouse && this.mhandler.needMouseHandling()) {
            if (this.btnMouseSync != null) {
                this.btnMouseSync.setEnabled(allow);
            }
            if (this.miMouseSyncFast != null) {
                this.miMouseSyncFast.setEnabled(allow);
            }
            if (this.miMouseSyncHard != null) {
                this.miMouseSyncHard.setEnabled(allow);
            }
        }
    }

    private void switchMouseHandler(boolean relative) {
        if (relative) {
            this.mhandler = this.mhandler_rel;
            this.setExclusive((CheckboxMenuItem)this.miMouseRel);
        } else {
            this.mhandler = this.mhandler_abs;
            this.setExclusive((CheckboxMenuItem)this.miMouseAbs);
        }
        if (this.mhandler.needMouseHandling()) {
            if (this.miMouseSyncFast != null) {
                this.miMouseSyncFast.setEnabled(!this.monitorModeOn);
            }
            if (this.miMouseSyncHard != null) {
                this.miMouseSyncHard.setEnabled(!this.monitorModeOn);
            }
            if (this.btnMouseSync != null) {
                this.btnMouseSync.setEnabled(!this.monitorModeOn);
            }
            if (this.mhandler_rel != null) {
                this.btnMouseMode.setImageIndex(1);
            }
        } else {
            if (this.miMouseSyncFast != null) {
                this.miMouseSyncFast.setEnabled(false);
            }
            if (this.miMouseSyncHard != null) {
                this.miMouseSyncHard.setEnabled(false);
            }
            if (this.btnMouseSync != null) {
                this.btnMouseSync.setEnabled(false);
            }
            if (this.mhandler_rel != null) {
                this.btnMouseMode.setImageIndex(0);
            }
        }
        this.console.setMouseHandler(this.mhandler);
        if (!relative) {
            try {
                if (this.primeRFBHandler != null) {
                    this.primeRFBHandler.rfbProto.writeMouseSyncEvent((byte)2);
                }
            }
            catch (IOException ec) {
                ec.printStackTrace();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        Object src = e2.getSource();
        try {
            boolean handleFocus = true;
            if (src == this.btnDrvRedir) {
                this.switchDriveRedirection();
            } else if (src == this.btnForensic) {
                this.switchForensic();
                if (this.showForensic) {
                    handleFocus = false;
                }
            } else if (src == this.btnMouseSync) {
                this.primeRFBHandler.rfbProto.writeMouseSyncEvent((byte)0);
            } else if (src == this.miMouseSyncFast) {
                this.primeRFBHandler.rfbProto.writeMouseSyncEvent((byte)2);
            } else if (src == this.miMouseSyncHard) {
                this.primeRFBHandler.rfbProto.writeMouseSyncEvent((byte)1);
                Date date = new Date();
                MouseEvent me = new MouseEvent(this.console, 503, date.getTime(), 0, this.mhandler.oldPos.x, this.mhandler.oldPos.y, 0, false);
                this.console.processEvent(me);
            } else if (src == this.btnAA) {
                this.primeRFBHandler.rfbProto.writeVideoSettingsEvent((byte)12, (short)0);
            } else if (src == this.miVideoRefresh) {
                this.primeRFBHandler.rfbProto.writeVideoRefresh();
            } else if (src == this.btnMouseMode) {
                if (this.mhandler == this.mhandler_abs) {
                    this.setMouseSingle();
                } else {
                    this.setMouseDouble();
                }
            } else if (src == this.buttonStart) {
                this.start();
            } else if (src == this.buttonStop) {
                int result = JOptionPane.showConfirmDialog(this, T._("Are you sure to quit video redirection?"), T._("Confirmation"), 0);
                if (result == 0) {
                    this.close();
                }
            } else if (src == this.buttonFullScreen) {
                JOptionPane.showMessageDialog(this, T._("Press Alt+Enter to return to window mode"), T._("Full Screen"), 1);
                this.fullScreenMode();
            } else if (src == this.buttonScreenShot) {
                this.buttonScreenShot.setEnabled(false);
                this.image = ComponentWriter.captureScreenByRCCanvasPanel(this.console);
                this.filePreviewer.init(this.saveFileChooser, this.image);
                this.saveFileChooser.setAccessory(this.filePreviewer);
                int returnVal = this.saveFileChooser.showSaveDialog(this);
                if (returnVal == 0) {
                    this.saveFilename = this.saveFileChooser.getSelectedFile().getPath();
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            ServerConsolePanelBase.this.captureScreen(ServerConsolePanelBase.this.image, ServerConsolePanelBase.this.saveFilename);
                        }
                    };
                    t.start();
                }
                this.buttonScreenShot.setEnabled(true);
            } else if (src == this.buttonZoomIn) {
                int index = this.comboBoxzoomStep.getSelectedIndex();
                if (index != 0) {
                    this.comboBoxzoomStep.select(index - 1);
                    this.itemStateChanged(new ItemEvent(this.comboBoxzoomStep, 0, null, 0));
                }
            } else if (src == this.buttonZoomOut) {
                int index = this.comboBoxzoomStep.getSelectedIndex();
                if (index != this.comboBoxzoomStep.getItemCount() - 1) {
                    this.comboBoxzoomStep.select(index + 1);
                    this.itemStateChanged(new ItemEvent(this.comboBoxzoomStep, 0, null, 0));
                }
            } else if (src == this.buttonQuickShot) {
                if (this.isFristTimeQuickShot) {
                    JFileChooser savedir = new JFileChooser();
                    savedir.setFileSelectionMode(1);
                    int returnVal = savedir.showSaveDialog(this);
                    if (returnVal != 0) {
                        return;
                    }
                    File savePath = savedir.getSelectedFile();
                    this.quickShotThumbnailPanel.setDirectory(savePath);
                    this.isFristTimeQuickShot = false;
                }
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        ServerConsolePanelBase.this.buttonQuickShot.setEnabled(false);
                        ServerConsolePanelBase.this.quickShotImage = ComponentWriter.captureScreenByRCCanvasPanel(ServerConsolePanelBase.this.console);
                        File file = ServerConsolePanelBase.this.quickShotThumbnailPanel.addImage(ServerConsolePanelBase.this.quickShotImage);
                        if (file != null) {
                            ServerConsolePanelBase.this.logger.println(T._("Quick Shot to ") + file.getAbsolutePath());
                            if (!ServerConsolePanelBase.this.isShowThumbnailPanel) {
                                ServerConsolePanelBase.this.isShowThumbnailPanel = true;
                                DriveRedirectionContainer parent = (DriveRedirectionContainer)((Object)ServerConsolePanelBase.this.getParent());
                                parent.showThumbnailPane(ServerConsolePanelBase.this.isShowThumbnailPanel, ServerConsolePanelBase.this.quickShotThumbnailPanel);
                                ServerConsolePanelBase.this.quickShotThumbnailPanel.invalidate();
                            }
                        } else {
                            ServerConsolePanelBase.this.logger.println(T._("Quick Shot error"));
                        }
                        ServerConsolePanelBase.this.buttonQuickShot.setEnabled(true);
                    }
                };
                t.start();
            } else if (src == this.buttonQuickShotView) {
                if (this.isShowThumbnailPanel) {
                    this.isShowThumbnailPanel = false;
                    DriveRedirectionContainer parent = (DriveRedirectionContainer)((Object)this.getParent());
                    parent.showThumbnailPane(this.isShowThumbnailPanel, this.quickShotThumbnailPanel);
                } else {
                    this.isShowThumbnailPanel = true;
                    DriveRedirectionContainer parent = (DriveRedirectionContainer)((Object)this.getParent());
                    parent.showThumbnailPane(this.isShowThumbnailPanel, this.quickShotThumbnailPanel);
                    this.quickShotThumbnailPanel.invalidate();
                }
            } else if (((MenuItem)src).getParent() != null && ((MenuItem)src).getParent() == this.fixSubMenu) {
                boolean requestFBUpdate;
                MenuItem item = (MenuItem)src;
                RFBEncoding enc = this.profile.encoding;
                String oldColorName = enc.getCurrentColorName();
                boolean needReadjust = enc.setFixEncoding(item.getLabel());
                boolean bl = requestFBUpdate = !oldColorName.equals(enc.getCurrentColorName());
                if (needReadjust) {
                    this.adjustEncodingSubmenus();
                    this.currentRFBHandler.pendingFormatChange = true;
                    if (requestFBUpdate) {
                        try {
                            this.currentRFBHandler.sendFullFramebufferUpdateRequest();
                        }
                        catch (IOException ec) {
                            this.logger.println(T._("Unable to send Full Framebuffer Update Request message"));
                        }
                    }
                }
            } else if (src == this.miKeyboardMouseSetting) {
                new Thread(){

                    @Override
                    public void run() {
                        ServerConsolePanelBase.this.helpHandleMiKeyboardMouseSetting();
                        ServerConsolePanelBase.this.adjustMouseSyncButtonAndMenuBySetting();
                    }
                }.start();
            }
            if (handleFocus) {
                this.handleFocus(null);
            }
        }
        catch (IOException ec) {
            ec.printStackTrace();
        }
    }

    private void helpHandleMiKeyboardMouseSetting() {
        if (!this.keyboardMouseSettingPanel.getData()) {
            return;
        }
        Object[] message = new Object[]{this.keyboardMouseSettingPanel};
        int result = JOptionPane.showOptionDialog(this, message, "Keyboard/Mouse Setting", 2, -1, null, null, null);
        if (result == 0) {
            this.keyboardMouseSettingPanel.setData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        if (e2.getSource() instanceof Choice) {
            Choice cb = (Choice)e2.getSource();
            if ("300%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(3.0, 3.0);
            } else if ("250%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(2.5, 2.5);
            } else if ("200%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(2.0, 2.0);
            } else if ("150%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(1.5, 1.5);
            } else if ("100%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(1.0, 1.0);
            } else if ("75%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(0.75, 0.75);
            } else if ("50%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(0.5, 0.5);
            } else if ("25%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(0.25, 0.25);
            } else if ("10%".equals(cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(true, true);
                this.console.setScaleToFit(false);
                this.console.setScale(0.1, 0.1);
            } else if (T._("Scale to fit").equalsIgnoreCase("" + cb.getSelectedItem())) {
                this.showReduced(false, true);
                this.useScrollPane(false, true);
                this.console.setScaleToFit(true);
            }
            return;
        }
        MenuItem mi = (MenuItem)e2.getSource();
        if (mi == this.itemRO) {
            boolean moni = e2.getStateChange() == 1;
            this.changeMonitorState(moni);
        } else if (mi == this.itemExcl) {
            String ex = e2.getStateChange() == 1 ? "on" : "off";
            try {
                this.primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive", ex);
            }
            catch (Exception ec) {
                this.logger.println(T._("Exclusive") + " " + ex + " " + ec.getMessage());
            }
            this.handleFocus(null);
        } else if (mi == this.scfilter) {
            if (e2.getStateChange() == 1) {
                this.console.setInterpol(true);
            } else {
                this.console.setInterpol(false);
            }
            this.handleFocus(null);
        } else if (mi == this.sc100 || mi == this.sc50 || mi == this.sc25 || mi == this.sc2fit) {
            if (this.currentScale != mi) {
                this.currentScale = mi;
                if (mi == this.sc2fit) {
                    this.showReduced(false, false);
                    this.useScrollPane(false, true);
                    this.console.setScaleToFit(true);
                } else if (mi == this.sc100) {
                    this.showReduced(false, false);
                    this.useScrollPane(true, true);
                    this.console.setScaleToFit(false);
                    this.console.setScale(1.0, 1.0);
                } else {
                    this.showReduced(true, false);
                    this.useScrollPane(true, false);
                    this.console.setScaleToFit(false);
                    if (mi == this.sc50) {
                        this.console.setScale(0.5, 0.5);
                    } else if (mi == this.sc25) {
                        this.console.setScale(0.25, 0.25);
                    }
                }
            }
            this.setExclusive((CheckboxMenuItem)mi);
            this.handleFocus(null);
        } else if (mi == this.itemChat) {
            if (this.chat != null) {
                if (e2.getStateChange() == 1) {
                    if (!this.wlChatReg) {
                        final CheckboxMenuItem myItem = (CheckboxMenuItem)e2.getSource();
                        this.chat.getAsWindow().addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent e2) {
                                myItem.setState(false);
                            }
                        });
                        this.wlChatReg = true;
                    }
                    this.chat.setVisible(true);
                } else {
                    this.chat.setVisible(false);
                }
            }
            this.handleFocus(null);
        } else if (mi == this.itemSoftKbd) {
            final CheckboxMenuItem myItem = (CheckboxMenuItem)mi;
            if (null == this.softkbdwin && myItem.getState()) {
                this.softkbd = KbdFactory.getInstance().getSoftKbd(this.keh, this.curmapping, this.boardname, true);
                if (this.softkbd != null) {
                    this.softkbdwin = this.softkbd.getAsWindow(this);
                    this.softkbdwin.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e2) {
                            myItem.setState(false);
                        }
                    });
                } else {
                    myItem.setState(false);
                    this.softkbdwin = null;
                    this.logger.println("Show failed, please choose a soft keyboard mapping first");
                }
            }
            if (myItem.getState() && this.softkbdwin != null) {
                ServerConsolePanelBase scp = this;
                Point p = scp.getLocationOnScreen();
                Dimension scpdim = scp.getSize();
                Dimension softdim = this.softkbdwin.getSize();
                int x = scpdim.width - softdim.width + 4;
                int y = scpdim.height - softdim.height + 4;
                p.translate(x, y);
                this.softkbdwin.setLocation(p);
                this.softkbdwin.show();
            } else {
                if (this.softkbdwin != null) {
                    this.softkbdwin.hide();
                    this.softkbdwin.dispose();
                }
                this.softkbdwin = null;
            }
        } else if (mi.getParent() != null && mi.getParent() == this.mapmi || mi.getParent() == this.hardmapmi) {
            MyCBMenuItem item = (MyCBMenuItem)mi;
            if (this.mapmi == mi.getParent()) {
                this.curmapping = (Locale)item.item;
                if (this.softkbd != null) {
                    this.softkbd.setMapping(this.curmapping);
                }
                if (this.forensicPanel != null) {
                    this.forensicPanel.newKbdMapping(this.curmapping);
                }
                try {
                    this.primeRFBHandler.rfbProto.writeUserPropChangeEvent("softkbd_mapping", this.curmapping.toString());
                }
                catch (Exception ec) {
                    ec.printStackTrace();
                }
            } else if (this.hardmapmi == mi.getParent()) {
                this.curhardmapping = (Locale)item.item;
                this.console.setKbdLocale(this.curhardmapping);
            }
            this.setExclusive(item);
        } else if (mi.getParent() != null && mi.getParent() == this.cursormi) {
            MyCBMenuItem item = (MyCBMenuItem)mi;
            this.currentCursor = (CursorType)item.item;
            this.cursors.setCurrentCursor(this.currentCursor);
            this.console.setCursor(this.currentCursor.cursor);
            try {
                this.primeRFBHandler.rfbProto.writeUserPropChangeEvent("local_cursor", this.currentCursor.sName);
            }
            catch (Exception ec) {
                ec.printStackTrace();
            }
            this.setExclusive(item);
        } else if (mi == this.itemVideoSettings) {
            if (e2.getStateChange() == 1) {
                if (!this.wlVideoReg) {
                    final CheckboxMenuItem myItem = (CheckboxMenuItem)e2.getSource();
                    this.vsframe.getAsWindow().addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e2) {
                            myItem.setState(false);
                        }
                    });
                    this.wlVideoReg = true;
                }
                this.vsframe.setVisible(true);
            } else {
                this.vsframe.setVisible(false);
            }
        } else if (mi == this.miMouseRel) {
            this.setMouseSingle();
        } else if (mi == this.miMouseAbs) {
            this.setMouseDouble();
        } else if (mi.getParent() == this.compSubMenu || mi.getParent() == this.colorSubMenu || mi == this.lossymi) {
            RFBEncoding enc = this.profile.encoding;
            boolean needReadjust = false;
            boolean requestFBUpdate = true;
            if (mi.getParent() == this.compSubMenu) {
                MyCBMenuItem item = (MyCBMenuItem)mi;
                String name = (String)item.item;
                String oldColorName = enc.getCurrentColorName();
                needReadjust = enc.setCompression(name);
                requestFBUpdate = !oldColorName.equals(enc.getCurrentColorName());
            } else if (mi.getParent() == this.colorSubMenu) {
                MyCBMenuItem item = (MyCBMenuItem)mi;
                String name = (String)item.item;
                needReadjust = requestFBUpdate = this.profile.encoding.setColorDepth(name);
            } else if (mi == this.lossymi) {
                needReadjust = this.profile.encoding.setLossyState(this.lossymi.getState());
            }
            if (needReadjust) {
                this.adjustEncodingSubmenus();
                this.currentRFBHandler.pendingFormatChange = true;
                if (requestFBUpdate) {
                    try {
                        this.currentRFBHandler.sendFullFramebufferUpdateRequest();
                    }
                    catch (IOException ec) {
                        this.logger.println(T._("Unable to send Full Framebuffer Update Request message"));
                    }
                }
            }
        }
    }

    private void changeMonitorState(boolean moni) {
        this.console.setMonitorMode(moni);
        this.buttonpane.setMonitorMode(moni);
        if (this.vsframe != null) {
            this.vsframe.setMonitorMode(moni);
        }
        if (this.btnRO != null) {
            this.btnRO.setImageIndex(moni ? 5 : 4);
        }
        this.handleFocus(null);
        this.allowMouseHandling(!moni);
        this.monitorModeOn = moni;
    }

    private void switchDriveRedirection() {
        this.showDriveRedirection = !this.showDriveRedirection;
        this.btnDrvRedir.setImageIndex(this.showDriveRedirection ? 7 : 6);
        DriveRedirectionContainer parent = (DriveRedirectionContainer)((Object)this.getParent());
        parent.showDriveRedirection(this.showDriveRedirection);
    }

    private void switchForensic() {
        this.showForensic = !this.showForensic;
        this.btnForensic.setImageIndex(this.showForensic ? 9 : 8);
        ServerConsoleFrame parent = (ServerConsoleFrame)this.getParent();
        parent.showForensic(this.showForensic);
    }

    private void adjustEncodingSubmenus() {
        String name;
        MyCBMenuItem ci;
        int j2;
        RFBEncoding enc = this.profile.encoding;
        Menu m = this.fixSubMenu;
        for (j2 = 0; j2 < m.getItemCount(); ++j2) {
            MenuItem mi = m.getItem(j2);
            mi.setEnabled(true);
        }
        m = this.compSubMenu;
        String currentName = enc.getCurrentCompName();
        for (j2 = 0; j2 < m.getItemCount(); ++j2) {
            ci = (MyCBMenuItem)m.getItem(j2);
            name = (String)ci.item;
            ci.setState(name.equals(currentName));
        }
        m = this.colorSubMenu;
        currentName = enc.getCurrentColorName();
        for (j2 = 0; j2 < m.getItemCount(); ++j2) {
            ci = (MyCBMenuItem)m.getItem(j2);
            name = (String)ci.item;
            ci.setEnabled(enc.isColorPossible(name));
            ci.setState(name.equals(currentName));
        }
        if (enc.isHwSupported()) {
            this.lossymi.setState(enc.isLossy());
        }
    }

    protected String get_hotkey_settings_string() {
        return new String(T._("Please define a mouse hotkey in Remote Console Settings."));
    }

    public void setWLANQuality(int quality) {
        int min_index = 0;
        int max_index = 5;
        int index = quality <= 0 ? 0 : (quality >= 100 ? max_index : (max_index - min_index) * quality / 100 + min_index + 1);
        if (this.btnWL != null) {
            this.btnWL.setImageIndex(index);
            if (this.mytooltip == null) {
                this.mytooltip = new ToolTip(this.btnWL, this.wlantext, this.scframe, this.verInfo.isMSJava());
            }
            this.wlantext.setText(T._("WLAN link quality:") + " " + quality + "%");
        }
    }

    public void setExclusiveMode(boolean ex) {
        this.exclusive = ex;
        if (this.itemExcl != null) {
            this.itemExcl.setState(this.exclusive);
        }
        this.setShareIcon();
    }

    public void setShareMode(int users) {
        this.userscount = users;
        this.setShareIcon();
    }

    private void setShareIcon() {
        if (this.btnSM == null) {
            return;
        }
        if (this.exclusive) {
            boolean co = true;
            try {
                co = this.currentRFBHandler.rfbProto.connected();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (co) {
                this.btnSM.setImageIndex(2);
            } else {
                this.btnSM.setImageIndex(3);
            }
        } else if (this.userscount > 1) {
            this.btnSM.setImageIndex(1);
        } else {
            this.btnSM.setImageIndex(0);
        }
    }

    public void setMouseSingle() {
        if (this.mhandler_rel == null) {
            String s;
            if (!this.verInfo.isJava14()) {
                s = new String(T._("Java VM version not suported. Version 1.4 or higher required."));
            } else if (this.synckey == null || this.synckey.length() == 0) {
                s = this.get_hotkey_settings_string();
            } else {
                s = this.noRelativeMouseHandlerReason;
                if (s == null) {
                    s = new String(T._("Unknown error while activating single mouse mode."));
                }
            }
            ConfirmDialog d2 = new ConfirmDialog(s, T._("Could not activate single mouse mode"), 0, true);
            d2.show();
            d2.dispose();
            d2 = null;
            this.switchMouseHandler(false);
            return;
        }
        this.switchMouseHandler(true);
        this.logger.println(T._("Single mouse mode (click into screen to start)"));
        this.saveMouseMode("yes");
    }

    public void setMouseDouble() {
        this.switchMouseHandler(false);
        this.logger.println(T._("Double mouse mode (use 'Keyboard/Mouse Settings' to setup)"));
        this.saveMouseMode("no");
    }

    public void saveMouseMode(String ss) {
        try {
            this.primeRFBHandler.rfbProto.writeUserPropChangeEvent("exclusive_mouse", ss);
        }
        catch (IOException ex) {
            this.logger.println(T._("Saving single mouse mode failed:") + " " + ex.getMessage());
        }
    }

    private Object[] toArray(Vector v) {
        Object[] os = new Object[v.size()];
        for (int i2 = 0; i2 < v.size(); ++i2) {
            os[i2] = v.elementAt(i2);
        }
        return os;
    }

    public void changeMode() {
        if (this.isFullScreenMode) {
            this.windowScreenMode();
        } else {
            this.fullScreenMode();
        }
    }

    public void fullScreenMode() {
        this.isFullScreenMode = true;
        this.comboBoxzoomStep.select("100%");
        this.itemStateChanged(new ItemEvent(this.comboBoxzoomStep, 0, null, 0));
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.graphicsDevice = env.getDefaultScreenDevice();
        this.orgdm = this.graphicsDevice.getDisplayMode();
        this.fullFrame = new JFrame("Full Screen Mode");
        this.fullFrame.setUndecorated(true);
        this.fullFrame.setDefaultCloseOperation(3);
        this.sccsp.removeAll();
        this.fullFrame.getContentPane().add(this.console);
        this.graphicsDevice.setFullScreenWindow(this.fullFrame);
        this.graphicsDevice.setDisplayMode(this.orgdm);
    }

    public void windowScreenMode() {
        this.graphicsDevice.setFullScreenWindow(null);
        this.sccsp.add(this.console);
        Container c2 = this.getParent();
        Dimension d2 = c2.getSize();
        c2.setSize(new Dimension(d2.width, d2.height + 1));
        c2.setSize(new Dimension(d2.width, d2.height));
        this.fullFrame.dispose();
        c2.setVisible(true);
        this.isFullScreenMode = false;
    }

    public void captureScreen(BufferedImage image, String filename) {
        File finalFilename = null;
        try {
            finalFilename = ComponentWriter.writeimage(image, new File(filename));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.logger.println("Screen captured to " + finalFilename.getAbsolutePath());
    }

    public void setProfile(RFBProfile profile) {
        this.profile = profile;
    }

    public void start() {
        if (ServerConsolePanelBase.availableMemory() < 0x1900000L) {
            JOptionPane.showMessageDialog(this, "Cannot start KVM due to the maximum memory limitation\n");
            return;
        }
        this.start(this.profile);
    }

    public static long availableMemory() {
        long availableMemory = Runtime.getRuntime().maxMemory() - (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
        return availableMemory;
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (e2.getSource() == this.buttonStart) {
            this.logpane.getStateline().setText("Start Video redirection");
        } else if (e2.getSource() == this.buttonStop) {
            this.logpane.getStateline().setText("Stop Video redirection");
        } else if (e2.getSource() == this.buttonFullScreen) {
            this.logpane.getStateline().setText("Full Screen");
        } else if (e2.getSource() == this.buttonScreenShot) {
            this.logpane.getStateline().setText("Screen capture");
        } else if (e2.getSource() == this.buttonQuickShot) {
            this.logpane.getStateline().setText("Quick shot screen");
        } else if (e2.getSource() == this.buttonQuickShotView) {
            this.logpane.getStateline().setText("View Quick shot images");
        } else if (e2.getSource() == this.buttonZoomIn) {
            this.logpane.getStateline().setText("Zoom in");
        } else if (e2.getSource() == this.buttonZoomOut) {
            this.logpane.getStateline().setText("Zoom out");
        } else if (e2.getSource() == this.comboBoxzoomStep) {
            this.logpane.getStateline().setText("Select scale to zoom in or zoom out");
        } else if (e2.getSource() == this.btnDrvRedir) {
            this.logpane.getStateline().setText("Dirve redirection");
        } else if (e2.getSource() == this.btnAA) {
            this.logpane.getStateline().setText("Auto adjustment");
        } else if (e2.getSource() == this.btnSM) {
            this.logpane.getStateline().setText("Share mode");
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    public void sendDVOString() {
        this.console.sendDVOString();
    }

    public void getResolution() {
        System.out.println("" + this.console.mysize.toString());
    }

    public int testVideoSignal() {
        this.orgImage = null;
        try {
            this.orgImage = ImageIO.read(new File("kvm.png"));
        }
        catch (IOException ex) {
            return 6;
        }
        this.capImage = ComponentWriter.captureScreenByRCCanvasPanel(this.console);
        if (this.capImage == null) {
            return 1;
        }
        if (this.orgImage == null) {
            return 2;
        }
        int devide = 8;
        int width = this.capImage.getWidth();
        int height = this.capImage.getHeight();
        int cellWidth = width / devide;
        int cellHeight = height / devide;
        for (int i2 = 1; i2 <= devide; ++i2) {
            for (int j2 = 1; j2 <= devide; ++j2) {
                int rgb2;
                int x = i2 * cellWidth - cellWidth / 2;
                int y = j2 * cellHeight - cellHeight / 2;
                int rgb1 = this.capImage.getRGB(x, y);
                if (rgb1 == (rgb2 = this.orgImage.getRGB(x, y))) continue;
                System.out.println("Color is different at (" + i2 + "," + j2 + ")");
                try {
                    ComponentWriter.writeimage(this.capImage, new File("kvm1.png"));
                }
                catch (IOException ex1) {
                    // empty catch block
                }
                this.orgImage = null;
                this.capImage = null;
                return 5;
            }
        }
        this.orgImage = null;
        this.capImage = null;
        return 0;
    }

    public void requestFocusForConsole() {
        this.console.requestFocus();
    }

    public RCCanvasPanel getConsole() {
        return this.console;
    }

    static {
        isAddedEncodeMenu = false;
    }

    class J14GetGraphicsConfigurationHelper {
        J14GetGraphicsConfigurationHelper() {
        }

        public Insets getScreenInsets(Frame f2) {
            GraphicsConfiguration gc = f2.getGraphicsConfiguration();
            return Toolkit.getDefaultToolkit().getScreenInsets(gc);
        }
    }

    public class TrafficLabel
    extends FixedLabel {
        TrafficLabel() {
            super(T._("   Fps: 88 In: 8888 KB/s Out: 888 KB/s "));
        }
    }
}

