/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import nn.pp.rc.GenericTimer;
import nn.pp.rc.MonitorData;
import nn.pp.rc.MonitoringStream;
import nn.pp.rc.ServerConsolePanelBase;
import nn.pp.rc.T;

public class TrafficMonitor
implements ActionListener {
    MonitoringStream in;
    MonitoringStream out;
    ServerConsolePanelBase panel;
    GenericTimer timer;
    boolean showFPS = false;
    int fpsCount = 0;

    TrafficMonitor(ServerConsolePanelBase panel) {
        this.panel = panel;
        this.timer = new GenericTimer(1000, this);
    }

    public void setStreams(MonitoringStream in, MonitoringStream out) {
        this.in = in;
        this.out = out;
        this.timer.start();
    }

    public void enableFPS(boolean fps) {
        this.showFPS = fps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseFPSCount() {
        TrafficMonitor trafficMonitor = this;
        synchronized (trafficMonitor) {
            ++this.fpsCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getAndClearFPS() {
        int ret;
        TrafficMonitor trafficMonitor = this;
        synchronized (trafficMonitor) {
            ret = this.fpsCount;
            this.fpsCount = 0;
        }
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.updateInfo();
    }

    private void updateInfo() {
        String info = "";
        MonitorData indata = this.in.getAndClearIn();
        int outc = this.out.getAndClearOut();
        if (this.showFPS) {
            info = info + " " + T._("Fps:") + " " + this.getAndClearFPS();
        }
        info = info + MessageFormat.format(" " + T._("In: {0} Out: {1}"), this.buildPart(indata.countC), this.buildPart(outc));
        this.panel.setTitle(info);
    }

    private String buildPart(int count) {
        String sval = count > 1024 ? Integer.toString(count / 1024) + " " + T._("KB/s") : Integer.toString(count) + " " + T._("B/s");
        return sval;
    }
}

