/*
 * Decompiled with CFR 0.152.
 */
package nn.pp.rc.test;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class FixedGlassPane
extends JPanel
implements MouseListener,
MouseMotionListener,
FocusListener {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    JMenuBar menuBar;
    Container contentPane;
    boolean inDrag = false;
    boolean needToRedispatch = false;

    public FixedGlassPane(JMenuBar mb, Container cp) {
        this.menuBar = mb;
        this.contentPane = cp;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(this);
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.requestFocus();
        }
        super.setVisible(v);
    }

    @Override
    public void focusLost(FocusEvent fe) {
        if (this.isVisible()) {
            this.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent fe) {
    }

    public void setNeedToRedispatch(boolean need) {
        this.needToRedispatch = need;
    }

    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.needToRedispatch) {
            this.redispatchMouseEvent(e2);
            this.inDrag = false;
        }
    }

    private void redispatchMouseEvent(MouseEvent e2) {
        boolean inButton = false;
        boolean inMenuBar = false;
        Point glassPanePoint = e2.getPoint();
        Component component = null;
        Container container = this.contentPane;
        Point containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.contentPane);
        int eventID = e2.getID();
        if (containerPoint.y < 0) {
            inMenuBar = true;
            container = this.menuBar;
            containerPoint = SwingUtilities.convertPoint(this, glassPanePoint, this.menuBar);
            this.testForDrag(eventID);
        }
        if ((component = SwingUtilities.getDeepestComponentAt(container, containerPoint.x, containerPoint.y)) == null) {
            return;
        }
        inButton = true;
        this.testForDrag(eventID);
        if (inMenuBar || inButton || this.inDrag) {
            Point componentPoint = SwingUtilities.convertPoint(this, glassPanePoint, component);
            component.dispatchEvent(new MouseEvent(component, eventID, e2.getWhen(), e2.getModifiers(), componentPoint.x, componentPoint.y, e2.getClickCount(), e2.isPopupTrigger()));
        }
    }

    private void testForDrag(int eventID) {
        if (eventID == 501) {
            this.inDrag = true;
        }
    }
}

