/*
 * Decompiled with CFR 0.152.
 */
package smc.ext;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import smc.ext.OSDMessage;
import smc.ext.OSDView;

public class OSDMessageManager {
    ArrayList<OSDMessage> osdMessages = new ArrayList();
    Image backupedImage;
    Image replacedImage;
    OSDView osdView;
    boolean osdOn = true;

    public void addOSDMessage(OSDMessage osdMessage) {
        this.osdMessages.add(osdMessage);
        osdMessage.setOsdManager(this);
        osdMessage.countDown();
        this.osdViewRepaint();
    }

    public boolean isContainOSDMessage(OSDMessage osdMessage) {
        return this.osdMessages.contains(osdMessage);
    }

    public void removeOSDMessage(OSDMessage osdMessage) {
        osdMessage.clearTimer();
        this.osdMessages.remove(osdMessage);
        this.osdViewRepaint();
    }

    public void removeAllOSD() {
        this.osdMessages.clear();
        this.osdViewRepaint();
    }

    private void osdViewRepaint() {
        if (this.osdView != null) {
            this.osdView.repaintOSD();
        }
    }

    private BufferedImage generateOSDImage(Image img, OSDMessage osdMessage) {
        Graphics tempG = img.getGraphics();
        Dimension fontDimension = osdMessage.getDrawDimension(img.getGraphics());
        tempG.dispose();
        Rectangle r = new Rectangle(osdMessage.x, osdMessage.y, fontDimension.width, fontDimension.height);
        BufferedImage clippedImage = this.makeClippedImage(img, r);
        Graphics2D g2 = clippedImage.createGraphics();
        osdMessage.drawOSD(g2);
        g2.dispose();
        return clippedImage;
    }

    private BufferedImage makeClippedImage(Image orgImage, Rectangle r) {
        int w = r.width;
        int h2 = r.height;
        int type = 1;
        BufferedImage image = new BufferedImage(w, h2, type);
        Graphics2D g2 = image.createGraphics();
        g2.translate(-r.x, -r.y);
        g2.drawImage(orgImage, 0, 0, null);
        g2.dispose();
        return image;
    }

    public void processOSDMessage(Image orgImage) {
        if (this.osdMessages.size() == 0 || !this.osdOn) {
            this.backupedImage = orgImage;
            this.replacedImage = orgImage;
            return;
        }
        this.backupedImage = orgImage;
        Rectangle r = new Rectangle(0, 0, orgImage.getWidth(null), orgImage.getHeight(null));
        BufferedImage copyImage = this.makeClippedImage(orgImage, r);
        Graphics g2 = copyImage.getGraphics();
        for (int i2 = 0; i2 < this.osdMessages.size(); ++i2) {
            OSDMessage osdMessage = this.osdMessages.get(i2);
            BufferedImage osdImage = this.generateOSDImage(copyImage, osdMessage);
            g2.drawImage(osdImage, osdMessage.x, osdMessage.y, null);
        }
        g2.dispose();
        this.replacedImage = copyImage;
    }

    public void drawOSDMessageDirectlyByGraphics(Graphics g2) {
        Graphics2D g22 = (Graphics2D)g2;
        for (int i2 = 0; i2 < this.osdMessages.size(); ++i2) {
            OSDMessage osdMessage = this.osdMessages.get(i2);
            osdMessage.drawOSD(g22, osdMessage.x, osdMessage.y);
        }
    }

    public Image getBackupedImage() {
        return this.backupedImage;
    }

    public Image getReplacedImage() {
        return this.replacedImage;
    }

    public boolean isOsdOn() {
        return this.osdOn;
    }

    public OSDView getOsdView() {
        return this.osdView;
    }

    public void setOsdOn(boolean osdOn) {
        this.osdOn = osdOn;
    }

    public void setOsdView(OSDView osdView) {
        this.osdView = osdView;
    }

    public void OSDTest() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                int count = 0;
                OSDMessage osdMessage = new OSDMessage("", 100, 100);
                osdMessage.timeout = 1;
                while (true) {
                    osdMessage.message = "Supermicro " + count++;
                    if (OSDMessageManager.this.isContainOSDMessage(osdMessage)) {
                        OSDMessageManager.this.removeOSDMessage(osdMessage);
                    } else {
                        OSDMessageManager.this.addOSDMessage(osdMessage);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }
}

