/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.gui.JViewerApp;
import java.awt.Dimension;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;

public class JViewer {
    public static final String appTypeJviewer = "JViewer";
    public static final String appTypePlayer = "PlayVideo";
    public static final String appTypeDownloadSave = "SaveVideo";
    private static JFrame mainFrame;
    private static JDesktopPane mainPane;
    private static String apptype;
    private static boolean standalone;
    private static boolean webPreviewer;
    private static String ip;
    private static byte[] ServerIp;
    private static int port;
    private static int SecureChannel;
    private static int VMSecureChannel;
    private static int UserPrivileges;
    private static int cdserver_port;
    private static int fdserver_port;
    private static int hdserver_port;
    private static byte Num_CD;
    private static byte Num_FD;
    private static byte Num_HD;
    private static int CD_State;
    private static int FD_State;
    private static int HD_State;
    private static boolean UseSSL;
    private static boolean VMUseSSL;
    private static String webSessionToken;
    private static String kvmToken;
    private static String lang;
    private static int webPort;
    private static int webSecure;
    private static String videoFile;

    public static void main(String[] args) {
        mainFrame = new JFrame(appTypeJviewer);
        mainFrame.setMinimumSize(new Dimension(800, 600));
        mainFrame.setDefaultCloseOperation(0);
        standalone = true;
        JViewer.ParseCmd(args);
        String[] localarg = new String[args.length - 1];
        for (int p = 0; p < args.length - 1; ++p) {
            localarg[p] = args[p + 1];
        }
        if (JViewer.isjviewerapp()) {
            Debug.out.println("JViewer Application Initialised");
            JViewer.redirect();
        } else if (JViewer.isplayerapp()) {
            Debug.out.println("Player Application  Initialised");
            JViewer.recording();
        } else if (JViewer.isdownloadapp()) {
            Debug.out.println("Downlaod and save Application  Initialised");
            JViewer.recording();
        } else {
            JViewer.printUsage();
        }
    }

    public static boolean isjviewerapp() {
        return apptype != null && apptype.compareToIgnoreCase(appTypeJviewer) == 0;
    }

    public static boolean isplayerapp() {
        return apptype != null && apptype.compareToIgnoreCase(appTypePlayer) == 0;
    }

    public static boolean isdownloadapp() {
        return apptype != null && apptype.compareToIgnoreCase(appTypeDownloadSave) == 0;
    }

    public static String getIp() {
        return ip;
    }

    public static void launch(JFrame frame, JDesktopPane pane, String[] args) {
        standalone = false;
        mainFrame = frame;
        mainPane = pane;
        JViewer.redirect();
    }

    public static void recording() {
        String port = Integer.toString(webPort);
        JViewerApp.getInstance().Ondisplayvideo(ip, port, webSessionToken, webSecure, videoFile);
    }

    public static void redirect() {
        JViewerApp.getInstance().OnConnectToServer(ServerIp, port, kvmToken, UseSSL, VMUseSSL, cdserver_port, fdserver_port, hdserver_port, Num_CD, Num_FD, Num_HD, CD_State, FD_State, HD_State, UserPrivileges, webSessionToken);
        JViewerApp.getInstance().create_IUSBSession();
    }

    public static void ParseCmd(String[] args) {
        int i = 0;
        String arg = null;
        while (i < args.length && args[i].startsWith("-")) {
            if ((arg = args[i++]).equals("-apptype")) {
                if (i < args.length) {
                    apptype = args[i++];
                    continue;
                }
                System.err.println("-apptype requires a apptype name");
            }
            if (arg.equals("-hostname")) {
                ip = args[i];
                if ((ServerIp = JViewer.getServerIP(args[i++])) != null) continue;
                JViewer.printUsage();
                return;
            }
            if (arg.equals("-kvmtoken")) {
                try {
                    kvmToken = args[i++];
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-kvmsecure")) {
                try {
                    SecureChannel = Integer.parseInt(args[i++]);
                    if (SecureChannel != 0 && SecureChannel != 1) {
                        JViewer.printUsage();
                        return;
                    }
                    UseSSL = SecureChannel == 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-kvmport")) {
                try {
                    port = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-vmsecure")) {
                try {
                    VMSecureChannel = Integer.parseInt(args[i++]);
                    if (VMSecureChannel != 0 && VMSecureChannel != 1) {
                        JViewer.printUsage();
                        return;
                    }
                    VMUseSSL = VMSecureChannel == 1;
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-cdstate")) {
                try {
                    CD_State = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-cdport")) {
                try {
                    cdserver_port = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-cdnum")) {
                try {
                    Num_CD = (byte)Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-fdstate")) {
                try {
                    FD_State = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-fdport")) {
                try {
                    fdserver_port = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-fdnum")) {
                try {
                    Num_FD = (byte)Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-hdstate")) {
                try {
                    HD_State = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-hdport")) {
                try {
                    hdserver_port = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-hdnum")) {
                try {
                    Num_HD = (byte)Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-userpriv")) {
                try {
                    UserPrivileges = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-lang")) {
                try {
                    lang = args[i++];
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-webcookie")) {
                try {
                    webSessionToken = args[i++];
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-websecure")) {
                try {
                    webSecure = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (arg.equals("-webport")) {
                try {
                    webPort = Integer.parseInt(args[i++]);
                    continue;
                }
                catch (NumberFormatException e) {
                    JViewer.printUsage();
                    return;
                }
            }
            if (!arg.equals("-videofile")) continue;
            try {
                videoFile = args[i++];
            }
            catch (NumberFormatException e) {
                JViewer.printUsage();
                return;
            }
        }
    }

    public static void printUsage() {
        Debug.out.println("Invalid arguments, please try again");
        Debug.out.println("Usage: java -jar JViewer.jar <apptype> <ip address> <KVM port number> <token> <ssl for KVM> <ssl for vmedia> <Number of parallel Floppy Redirection> <Number of parallel CD/DVD Redirection>  <Number of parallel Hard disk Redirection> <cdserver port> <fdserver port> <hdserver port> <user privileges> <language> <token>");
        Debug.out.println("<apptype> JViewer for JViewer App,Player for playing the video,SAveVideo for download and save video in cleint system");
        Debug.out.println("<ssl for KVM> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<ssl for vmedia> 1 for secure connection and 0 for non-secure ");
        Debug.out.println("<user privileges> ");
        Debug.out.println("                  0x00000020 - VKVM permissions only");
        Debug.out.println("                  0x00000040 - VMedia permissions only");
        Debug.out.println("                  0x00000060 - VKVM & VMedia permissions");
        Debug.out.println("<language> ");
        Debug.out.println("                  EN - English");
        if (JViewer.isStandalone()) {
            System.exit(0);
        } else {
            JViewerApp.getInstance().getMainWindow().dispose();
        }
    }

    public static byte[] getServerIP(String ipStr) {
        byte[] ipDgt = null;
        try {
            InetAddress hostAddress = InetAddress.getByName(ipStr);
            ipStr = hostAddress.getHostAddress();
            ipDgt = InetAddress.getByName(ipStr).getAddress();
            Debug.out.println("Resolving to IPAddress " + ipStr);
            for (int i = 0; i < ipDgt.length; ++i) {
                Debug.out.print(ipDgt[i]);
            }
        }
        catch (UnknownHostException e) {
            Debug.out.println("Error Resolving IP address");
        }
        return ipDgt;
    }

    public static JFrame getMainFrame() {
        return mainFrame;
    }

    public static void setMainFrame(JFrame mainFrame) {
        JViewer.mainFrame = mainFrame;
    }

    public static JDesktopPane getMainPane() {
        return mainPane;
    }

    public static void setMainPane(JDesktopPane mainPane) {
        JViewer.mainPane = mainPane;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static void setStandalone(boolean standalone) {
        JViewer.standalone = standalone;
    }

    public static void setWebPreviewer(boolean status) {
        webPreviewer = status;
    }

    public static boolean isWebPreviewer() {
        return webPreviewer;
    }

    static {
        webPreviewer = false;
        port = 7578;
        SecureChannel = 0;
        VMSecureChannel = 0;
        UserPrivileges = 0;
        cdserver_port = 0;
        fdserver_port = 0;
        hdserver_port = 0;
        Num_CD = 1;
        Num_FD = 1;
        Num_HD = 1;
        CD_State = 0;
        FD_State = 0;
        HD_State = 0;
        UseSSL = false;
        VMUseSSL = false;
        webSessionToken = null;
        kvmToken = null;
        lang = null;
        webPort = 0;
        webSecure = 0;
        videoFile = null;
    }
}

