/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.gui.JViewerApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DevicePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int DEVICE_TYPE_CDROM = 0;
    public static final int DEVICE_TYPE_FLOPPY = 1;
    public static final int DEVICE_TYPE_HD_USB = 2;
    private static final int DEFAULT_NUM_DRIVES = 1;
    public static final int IMAGE_TYPE_CDROM = 1;
    public static final int IMAGE_TYPE_FLOPPY = 2;
    public static final int IMAGE_TYPE_HARDDISK = 3;
    private ButtonGroup m_deviceButtonGroup;
    private JRadioButton[] m_deviceButtons;
    public JButton m_browseButton;
    public JComboBox m_imagePath;
    public String ImagepathSelect;

    public DevicePanel(String[] driveList, int deviceType) {
        super(new GridLayout(driveList != null && driveList.length > 1 ? driveList.length + 1 : 2, 1, 0, 0));
        int totalDrives = driveList != null ? driveList.length + 1 : 1;
        this.m_deviceButtons = new JRadioButton[totalDrives];
        this.m_deviceButtonGroup = new ButtonGroup();
        switch (deviceType) {
            case 0: {
                this.m_deviceButtons[0] = new JRadioButton("ISO Image");
                break;
            }
            case 1: {
                this.m_deviceButtons[0] = new JRadioButton("Floppy Image");
                break;
            }
            case 2: {
                this.m_deviceButtons[0] = new JRadioButton("HD/USB Image");
            }
        }
        this.m_deviceButtons[0].setBackground(Color.WHITE);
        this.m_deviceButtons[0].addChangeListener(new radiobuttonlistener());
        this.m_deviceButtonGroup.add(this.m_deviceButtons[0]);
        this.m_deviceButtons[0].setSelected(true);
        int r_ix = 1;
        int d_ix = 0;
        while (r_ix < totalDrives) {
            this.m_deviceButtons[r_ix] = new JRadioButton(driveList[d_ix]);
            this.m_deviceButtons[r_ix].setBackground(Color.WHITE);
            this.m_deviceButtonGroup.add(this.m_deviceButtons[r_ix]);
            ++r_ix;
            ++d_ix;
        }
        JPanel panelImage = new JPanel(new BorderLayout(2, 0));
        panelImage.setBackground(Color.WHITE);
        switch (deviceType) {
            case 0: {
                this.m_imagePath = new JComboBox<String>(JViewerApp.Imagepath_CD);
                break;
            }
            case 1: {
                this.m_imagePath = new JComboBox<String>(JViewerApp.Imagepath_Floppy);
                break;
            }
            case 2: {
                this.m_imagePath = new JComboBox<String>(JViewerApp.Imagepath_Harddsik);
            }
        }
        this.m_imagePath.setEditable(false);
        this.m_imagePath.setBackground(Color.white);
        this.m_imagePath.setBorder(null);
        this.m_imagePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String Imagepath = (String)cb.getSelectedItem();
                DevicePanel.this.setImagepathSelect(Imagepath);
            }
        });
        this.m_browseButton = new JButton("Browse");
        panelImage.add((Component)this.m_deviceButtons[0], "West");
        panelImage.add((Component)this.m_imagePath, "Center");
        panelImage.add((Component)this.m_browseButton, "East");
        this.add(panelImage);
        for (int r_ix2 = 1; r_ix2 < totalDrives; ++r_ix2) {
            this.add(this.m_deviceButtons[r_ix2]);
        }
        this.setBackground(Color.WHITE);
    }

    public boolean isImageSelected() {
        return this.m_deviceButtons[0].getModel() == this.m_deviceButtonGroup.getSelection();
    }

    public void setImagePath(String path, int devicetype) {
        this.m_imagePath.insertItemAt(path, 0);
        this.m_imagePath.setSelectedIndex(0);
    }

    public String getImagePath() {
        String path = (String)this.m_imagePath.getSelectedItem();
        if (path == null) {
            path = "";
        }
        return path;
    }

    public String selectedDeviceString() {
        Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (b.getModel() != this.m_deviceButtonGroup.getSelection()) continue;
            return b.getText();
        }
        return "";
    }

    public void disableAll() {
        for (int i = 0; i < this.m_deviceButtons.length; ++i) {
            this.m_deviceButtons[i].setEnabled(false);
        }
        this.m_browseButton.setEnabled(false);
        this.m_imagePath.setEnabled(false);
    }

    public void enableAll() {
        for (int i = 0; i < this.m_deviceButtons.length; ++i) {
            this.m_deviceButtons[i].setEnabled(true);
        }
        if (this.m_deviceButtons[0].isSelected()) {
            this.m_browseButton.setEnabled(true);
            this.m_imagePath.setEnabled(true);
        }
    }

    public void SelectRadioButton_StateChange(String strRedirectedDevice, boolean state) {
        Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
        while (e.hasMoreElements()) {
            JRadioButton b = (JRadioButton)e.nextElement();
            if (!b.getText().equals(strRedirectedDevice) || b.isEnabled() == state) continue;
            this.m_deviceButtons[0].setSelected(true);
            b.setEnabled(state);
            return;
        }
    }

    public void SelectRadioButton(String strRedirectedDevice) {
        JRadioButton b;
        Enumeration<AbstractButton> e = this.m_deviceButtonGroup.getElements();
        while (e.hasMoreElements()) {
            b = (JRadioButton)e.nextElement();
            if (!b.getText().equals(strRedirectedDevice)) continue;
            b.setSelected(true);
            return;
        }
        e = this.m_deviceButtonGroup.getElements();
        if (e.hasMoreElements()) {
            b = (JRadioButton)e.nextElement();
            b.setSelected(true);
        }
    }

    public String getImagepathSelect() {
        return this.ImagepathSelect;
    }

    public void setImagepathSelect(String imagepathSelect) {
        this.ImagepathSelect = imagepathSelect;
    }

    public void saveImagepath(String imagePath, int devicetype) {
        File directory = new File(imagePath);
        String ParentDir = directory.getParent();
        switch (devicetype) {
            case 1: {
                JViewerApp.Imagepath_CD = this.saveRecentPath(JViewerApp.Imagepath_CD, ParentDir);
                break;
            }
            case 2: {
                JViewerApp.Imagepath_Floppy = this.saveRecentPath(JViewerApp.Imagepath_Floppy, ParentDir);
                break;
            }
            case 3: {
                JViewerApp.Imagepath_Harddsik = this.saveRecentPath(JViewerApp.Imagepath_Harddsik, ParentDir);
            }
        }
    }

    private String[] saveRecentPath(String[] path, String ParentDir) {
        if (path[0] == null) {
            path[0] = ParentDir;
            return path;
        }
        int i = 0;
        for (int j = 1; j < path.length; ++j) {
            path[j] = path[i++];
        }
        path[0] = ParentDir;
        return path;
    }

    class radiobuttonlistener
    implements ChangeListener {
        radiobuttonlistener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (DevicePanel.this.m_deviceButtons[0].isSelected()) {
                if (DevicePanel.this.m_browseButton != null) {
                    DevicePanel.this.m_browseButton.setEnabled(true);
                }
                if (DevicePanel.this.m_imagePath != null) {
                    DevicePanel.this.m_imagePath.setEnabled(true);
                }
            } else {
                DevicePanel.this.m_browseButton.setEnabled(false);
                if (DevicePanel.this.m_imagePath != null) {
                    DevicePanel.this.m_imagePath.setEnabled(false);
                }
            }
        }
    }
}

