/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.gui;

import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.avistream.AVIOutputStream;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.VideoRecord;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class ImagesToVideo
extends TimerTask {
    private AVIOutputStream out = null;
    private String movFile;
    private String imagePath;
    private long numOfFrames;
    private long duration;
    private int i = 1;
    private long count;
    private double scalex;
    private double scaley;
    private File frameFile;
    private BufferedImage image;
    private boolean singleVideo;
    public Timer imagesToVideo;

    public ImagesToVideo(String movFile, String imagePath, long numOfFrames, long duration) {
        this.movFile = movFile;
        this.imagePath = imagePath;
        this.numOfFrames = numOfFrames;
        this.duration = duration;
        this.singleVideo = JViewerApp.getInstance().getM_videorecord().singleVideo;
        try {
            this.out = new AVIOutputStream(new File(movFile), AVIOutputStream.VideoFormat.JPG, this.singleVideo);
            this.out.setVideoCompressionQuality(1.0f);
            this.out.setTimeScale(duration);
            this.out.setFrameRate(numOfFrames);
            this.image = new BufferedImage(1024, 768, 1);
            this.imagesToVideo = new Timer(true);
            this.imagesToVideo.schedule((TimerTask)this, 0L);
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.count = 0L;
            while (this.count < this.numOfFrames) {
                if (!this.singleVideo && this.out.streamClosed) {
                    this.multipleVideos();
                }
                String fileName = "file" + this.count + ".jpeg";
                this.frameFile = new File(this.imagePath, fileName);
                this.image = ImageIO.read(this.frameFile);
                if (this.singleVideo && (this.image.getWidth() != 1024 || this.image.getHeight() != 768)) {
                    this.image = this.singleVideo(this.image);
                }
                if (this.out.writeFrame(this.image)) {
                    this.frameFile.delete();
                }
                ++this.count;
            }
            this.out.close();
            this.cancel();
            if (!JViewer.isdownloadapp()) {
                JViewerApp.getInstance().getM_wndFrame().getWindowMenu().setMessage("");
            }
            JVFrame mframe = JViewerApp.getInstance().getMainWindow();
            VideoRecord.Record_Processing = false;
            if (JViewerApp.getInstance().getM_frame().videoStopError != null) {
                JViewerApp.getInstance().getM_frame().videoStopError.dispose();
            } else if (JViewer.isdownloadapp()) {
                JViewerApp.getInstance().getVideorecordapp().disposeInformationDialog();
                JOptionPane.showMessageDialog(mframe, "Completed Video Recording.\nThe video file is saved as " + this.movFile + "\nThe application will close now.", "Video Recording Complete", 1);
                JViewerApp.getInstance().getM_frame().windowClosed();
            } else {
                JOptionPane.showMessageDialog(mframe, "Completed Video Recording at an Average " + (int)VideoRecord.Avg_fps + " Frame(s) Per Second", "Video Recording Complete", 1);
            }
            if (!JViewer.isdownloadapp()) {
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
                JViewerApp.getInstance().getJVMenu().notifyMenuStateEnable("VideoRecordSettings", true);
            }
        }
        catch (IOException ie) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.cancel();
            String errorMsg = "Video Recording Stopped due to Insufficient Disk Space. Video data prior to the error has been recorded.";
            JViewerApp.getInstance().getM_videorecord().OnLowDiskSpace(this.frameFile, errorMsg);
        }
        finally {
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private BufferedImage singleVideo(BufferedImage img) {
        BufferedImage tempimg = new BufferedImage(1024, 768, 1);
        this.scalex = 1024.0 / (double)img.getWidth();
        this.scaley = 768.0 / (double)img.getHeight();
        AffineTransform affine = AffineTransform.getScaleInstance(this.scalex, this.scaley);
        Graphics2D g2d = tempimg.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2d.drawRenderedImage(img, affine);
        return tempimg;
    }

    private void multipleVideos() {
        try {
            --this.count;
            this.out.streamClosed = false;
            this.out = new AVIOutputStream(new File(this.movFile + "_" + this.i + ".avi"), AVIOutputStream.VideoFormat.JPG, this.singleVideo);
            this.out.setFrameRate(this.numOfFrames);
            this.out.setTimeScale(this.duration);
            this.out.setVideoCompressionQuality(1.0f);
            ++this.i;
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
    }
}

