/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.hid;

import com.ami.kvm.jviewer.hid.USBMessage;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KMCrypt;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class USBMouseRep
extends USBMessage {
    private static final int DIRABS_MAX_SCALED_X = Short.MAX_VALUE;
    private static final int DIRABS_MAX_SCALED_Y = Short.MAX_VALUE;
    public static byte RELATIVE_MOUSE_MODE = 1;
    public static byte ABSOLUTE_MOUSE_MODE = (byte)2;
    public static byte INVALID_MOUSE_MODE = (byte)3;
    private byte m_MouseMode = INVALID_MOUSE_MODE;
    public static byte m_btnStatus = 0;
    public double m_xDisp;
    public double m_yDisp;
    private ByteBuffer m_repBuf;
    private byte[] m_report;
    private static int SeqNum = 0;
    private double m_screenwidth;
    private double m_screenheight;
    private byte m_wheelrotation;

    public USBMouseRep() {
        this(0, 0, 0, 0);
    }

    public USBMouseRep(byte btnStatus, int xDisp, int yDisp, byte wheelrotation) {
        m_btnStatus = btnStatus;
        this.m_xDisp = xDisp;
        this.m_yDisp = yDisp;
        this.m_wheelrotation = wheelrotation;
    }

    public void set(byte btnStatus, double xDisp, double yDisp, byte MouseMode, int view_width, int view_height, byte Wheelrotation) {
        m_btnStatus = btnStatus;
        this.m_xDisp = xDisp;
        this.m_yDisp = yDisp;
        this.m_MouseMode = MouseMode;
        this.m_screenwidth = view_width;
        this.m_screenheight = view_height;
        if (this.m_screenwidth == 832.0) {
            this.m_screenwidth = 800.0;
        }
        this.m_wheelrotation = Wheelrotation;
    }

    public byte[] ABSreport(KMCrypt crypt) {
        short X = (short)(this.m_xDisp * 32767.0 / this.m_screenwidth + 0.5);
        short Y = (short)(this.m_yDisp * 32767.0 / this.m_screenheight + 0.5);
        if (crypt != null) {
            this.m_vHdr = new IVTPPktHdr(1, 41, 0);
            this.m_report = new byte[49];
        } else {
            this.m_vHdr = new IVTPPktHdr(1, 39, 0);
            this.m_report = new byte[47];
        }
        int DataPktLen = 7;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        if (crypt != null) {
            this.m_vHdr.setSize(41);
            this.m_vHdr.setStatus((short)255);
        } else {
            this.m_vHdr.setSize(39);
            this.m_vHdr.setStatus((short)0);
        }
        this.m_repBuf.put(this.m_vHdr.array());
        this.m_repBuf.put(this.m_signature);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(DataPktLen);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)49);
        this.m_repBuf.put((byte)32);
        this.m_repBuf.put((byte)-128);
        this.m_repBuf.put((byte)2);
        this.m_repBuf.put((byte)1);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.putInt(SeqNum);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)0);
        this.m_repBuf.put((byte)6);
        if (crypt != null) {
            byte[] orig_data = new byte[6];
            ByteBuffer tmpbuf = ByteBuffer.wrap(orig_data);
            tmpbuf.order(ByteOrder.LITTLE_ENDIAN);
            tmpbuf.put(m_btnStatus);
            tmpbuf.putShort(X);
            tmpbuf.putShort(Y);
            tmpbuf.put(this.m_wheelrotation);
            byte[] encrypt_data = crypt.encrypt(orig_data);
            if (encrypt_data == null) {
                return this.ABSreport(null);
            }
            this.m_repBuf.put(encrypt_data);
        } else {
            this.m_repBuf.put(m_btnStatus);
            this.m_repBuf.putShort(X);
            this.m_repBuf.putShort(Y);
            this.m_repBuf.put(this.m_wheelrotation);
        }
        int temp = 0;
        for (int i = 8; i < 40; ++i) {
            temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
        }
        this.m_repBuf.put(19, -((byte)(temp & 0xFF)));
        ++SeqNum;
        return this.m_report;
    }

    public byte[] RELreport(KMCrypt crypt) {
        if (crypt != null) {
            this.m_vHdr = new IVTPPktHdr(1, 41, 0);
            this.m_report = new byte[49];
        } else {
            this.m_vHdr = new IVTPPktHdr(1, 37, 0);
            this.m_report = new byte[45];
        }
        int DataPktLen = 5;
        this.m_repBuf = ByteBuffer.wrap(this.m_report);
        this.m_repBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.m_repBuf.position(0);
        if (crypt != null) {
            this.m_vHdr.setSize(41);
            this.m_vHdr.setStatus((short)255);
        } else {
            this.m_vHdr.setSize(37);
            this.m_vHdr.setStatus((short)0);
        }
        try {
            this.m_repBuf.put(this.m_vHdr.array());
            this.m_repBuf.put(this.m_signature);
            this.m_repBuf.put((byte)1);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)32);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.putInt(DataPktLen);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)49);
            this.m_repBuf.put((byte)32);
            this.m_repBuf.put((byte)-128);
            this.m_repBuf.put((byte)2);
            this.m_repBuf.put((byte)1);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.putInt(SeqNum);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)0);
            this.m_repBuf.put((byte)4);
            if (crypt != null) {
                byte[] orig_data = new byte[4];
                ByteBuffer tmpbuf = ByteBuffer.wrap(orig_data);
                tmpbuf.put(m_btnStatus);
                tmpbuf.put((byte)this.m_xDisp);
                tmpbuf.put((byte)this.m_yDisp);
                tmpbuf.put(this.m_wheelrotation);
                byte[] encrypt_data = crypt.encrypt(orig_data);
                if (encrypt_data == null) {
                    return this.RELreport(null);
                }
                this.m_repBuf.put(encrypt_data);
            } else {
                this.m_repBuf.put(m_btnStatus);
                this.m_repBuf.put((byte)this.m_xDisp);
                this.m_repBuf.put((byte)this.m_yDisp);
                this.m_repBuf.put(this.m_wheelrotation);
            }
            int temp = 0;
            for (int i = 8; i < 40; ++i) {
                temp = temp + (this.m_repBuf.get(i) & 0xFF) & 0xFF;
            }
            this.m_repBuf.put(19, -((byte)(temp & 0xFF)));
            ++SeqNum;
            return this.m_report;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] report() {
        if (this.m_MouseMode == ABSOLUTE_MOUSE_MODE) {
            return this.ABSreport(null);
        }
        return this.RELreport(null);
    }

    @Override
    public byte[] encryptedReport(KMCrypt crypt) {
        if (this.m_MouseMode == ABSOLUTE_MOUSE_MODE) {
            return this.ABSreport(crypt);
        }
        return this.RELreport(crypt);
    }
}

