/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.kvmpkts.FragNumReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KVMClient;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.NullReader;
import java.net.Socket;
import java.nio.ByteBuffer;

public class HeaderReader
implements KVMReader {
    private KVMClient m_client;
    private byte[] m_hdrBuf;
    private ByteBuffer m_hdrByteBuf;
    private IVTPPktHdr m_pktHdr;
    private int m_hdrIx;

    public HeaderReader(KVMClient client) {
        this.m_client = client;
        this.m_hdrBuf = new byte[8];
        this.m_hdrByteBuf = ByteBuffer.wrap(this.m_hdrBuf);
        this.m_pktHdr = new IVTPPktHdr();
        this.m_hdrIx = 0;
    }

    @Override
    public void initialize() {
        this.m_hdrIx = 0;
        this.m_hdrByteBuf.clear();
    }

    @Override
    public int read(Socket sockCh) {
        try {
            byte[] read_hdrByteBuf = new byte[this.m_hdrByteBuf.remaining()];
            this.m_hdrIx = this.m_client.read_data(sockCh, read_hdrByteBuf);
            this.m_hdrByteBuf.put(read_hdrByteBuf);
            if (this.m_hdrIx < 0) {
                return -1;
            }
            if (8 <= this.m_hdrIx) {
                this.m_pktHdr.set(this.m_hdrByteBuf);
                this.m_client.m_pktHdr = this.m_pktHdr;
                KVMReader reader = null;
                Boolean success = this.OnGetReader(this.m_pktHdr.type);
                if (!success.booleanValue()) {
                    if (this.m_pktHdr.pktSize > 0) {
                        Debug.out.println("Control\n");
                        reader = this.m_client.getCtrlReader();
                        reader.initialize();
                        this.m_client.setState(reader);
                    } else {
                        Debug.out.println("Control No Body\n");
                        this.m_client.onControlMessage();
                        reader = this.m_client.getHdrReader();
                        reader.initialize();
                        this.m_client.setState(reader);
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.out.println("HDR_RDR " + e);
            return -1;
        }
        return 0;
    }

    private Boolean OnGetReader(short type) {
        if (type == 25) {
            if (this.m_client.m_isBlank) {
                this.m_client.m_isBlank = false;
            }
            Debug.out.println("Video Fragment\n");
            FragNumReader reader = this.m_client.getFragNumReader();
            reader.initialize();
            this.m_client.setState(reader);
        } else if (type == 17) {
            Debug.out.println("BW Detect\n");
            NullReader reader = this.m_client.getNullReader();
            reader.initialize();
            this.m_client.setState(reader);
        } else {
            KVMReader reader = this.m_client.getSocReader(this.m_pktHdr.type);
            if (reader == null) {
                return false;
            }
            reader.initialize();
            this.m_client.setState(reader);
        }
        return true;
    }
}

