/*
 * Decompiled with CFR 0.152.
 */
package com.ami.kvm.jviewer.kvmpkts;

import com.ami.kvm.jviewer.Debug;
import com.ami.kvm.jviewer.JViewer;
import com.ami.kvm.jviewer.communication.Client;
import com.ami.kvm.jviewer.communication.NWListener;
import com.ami.kvm.jviewer.gui.JVFrame;
import com.ami.kvm.jviewer.gui.JViewerApp;
import com.ami.kvm.jviewer.gui.KVMSharing;
import com.ami.kvm.jviewer.gui.vMediaDialog;
import com.ami.kvm.jviewer.hid.USBMessage;
import com.ami.kvm.jviewer.jvvideo.JVVideo;
import com.ami.kvm.jviewer.kvmpkts.AutoDetectBw;
import com.ami.kvm.jviewer.kvmpkts.CfgBandwidth;
import com.ami.kvm.jviewer.kvmpkts.ConfPkt;
import com.ami.kvm.jviewer.kvmpkts.CtrlReader;
import com.ami.kvm.jviewer.kvmpkts.FragNumReader;
import com.ami.kvm.jviewer.kvmpkts.FragReader;
import com.ami.kvm.jviewer.kvmpkts.HeaderReader;
import com.ami.kvm.jviewer.kvmpkts.IVTPPktHdr;
import com.ami.kvm.jviewer.kvmpkts.KMCrypt;
import com.ami.kvm.jviewer.kvmpkts.KVMReader;
import com.ami.kvm.jviewer.kvmpkts.NullReader;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class KVMClient
extends Client {
    public static final int MAX_SCREEN_WIDTH = 1920;
    public static final int MAX_SCREEN_HEIGHT = 1200;
    public static final int MAX_FRAGMENT_SIZE = 4608000;
    public IVTPPktHdr m_pktHdr;
    public short m_fragNum;
    public ByteBuffer m_ctrlMsg;
    private HeaderReader m_hdrReader;
    private FragNumReader m_fragNumReader;
    private FragReader m_fragReader;
    private CtrlReader m_ctrlReader;
    private NullReader m_nullReader;
    private KVMReader m_reader;
    private JVVideo m_vidClnt;
    private NWListener m_NWListener;
    private volatile Thread m_NWThread;
    private boolean m_redirection = false;
    private KMCrypt m_kmCrypt;
    private boolean m_encrypt = false;
    public static final int INVALID_SESSION = 0;
    public static final int VALID_SESSION = 0;
    public static final int STOP_SESSION_IMMEDIATE = 2;
    public static final int INVALID_VIDEO_SESSION_TOKEN = 3;
    public static final int INVALID_CDROM_SESSION_TOKEN = 4;
    public static final int INVALID_FLOPPY_SESSION_TOKEN = 5;
    public static boolean DISABLE_ENCRPT_FLAG = false;
    public static final int STOP_SESSION_CONF_CHANGE = 5;
    public static final int STOP_SESSION_WEB_LOGOUT = 7;
    public IVTPPktHdr m_pktPreLoginHdr = null;
    private boolean m_bUseSSL = false;
    public boolean m_isBlank = false;
    private long m_startTS;
    private long m_stopTS;
    private ConfPkt[] confPacket = null;

    public KVMClient(byte[] ipAddr, int port, JVVideo vidClnt, boolean bUseSSL) {
        super(ipAddr, port);
        this.m_vidClnt = vidClnt;
        this.m_hdrReader = new HeaderReader(this);
        this.m_fragNumReader = new FragNumReader(this);
        this.m_fragReader = new FragReader(this);
        this.m_ctrlReader = new CtrlReader(this);
        this.m_nullReader = new NullReader(this);
        this.m_bUseSSL = bUseSSL;
        this.m_reader = this.m_hdrReader;
        this.m_kmCrypt = new KMCrypt();
    }

    @Override
    public void onReadEvent() {
        int iStatus = this.m_reader.read(this.getSocket());
        JVFrame mframe = JViewerApp.getInstance().getMainWindow();
        if (-1 == iStatus) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!JViewer.isWebPreviewer()) {
                JOptionPane.showMessageDialog(mframe, "Video Socket Error:Abnormal Termination", "Socket Failure", 0);
                JViewerApp.getInstance().getMainWindow().windowClosed();
            }
        }
    }

    public void setState(KVMReader reader) {
        this.m_reader = reader;
    }

    public HeaderReader getHdrReader() {
        return this.m_hdrReader;
    }

    public FragNumReader getFragNumReader() {
        return this.m_fragNumReader;
    }

    public FragReader getFragReader() {
        return this.m_fragReader;
    }

    public CtrlReader getCtrlReader() {
        return this.m_ctrlReader;
    }

    public NullReader getNullReader() {
        return this.m_nullReader;
    }

    public boolean onNewFrame(ByteBuffer frame) {
        if (JViewerApp.getInstance().m_refresh) {
            JViewerApp.getInstance().m_refresh = false;
            JViewerApp.getInstance().OnVideoPauseRedirection();
        }
        if (this.m_vidClnt.onNewFrame(frame) != 0) {
            Debug.out.println("onNewFrame failed.");
            return false;
        }
        return true;
    }

    public void onControlMessage() {
        Debug.out.println("CMDTYPE::" + this.m_pktHdr.type);
        switch (this.m_pktHdr.type) {
            case 9: {
                Debug.out.println("*** Blank screen");
                if (this.m_isBlank) break;
                this.m_vidClnt.onBlankScreen();
                this.m_isBlank = true;
                break;
            }
            case 8: {
                Debug.out.println("*** Stop session");
                if (this.m_pktHdr.status() == 5) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), "Redirection configuration has been changed. Redirection engine will restart.\nCurrent session has been closed by redirection service. Please connect again.", "Information", 0);
                }
                if (this.m_pktHdr.status() == 7) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), "Due to Web Session Logout.Closing the Viewer... ", "Information", 0);
                }
                if (this.m_pktHdr.status() == 2) {
                    JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), "Redirection Engine has instructed Viewer to Close. Closing the Viewer... ", "Information", 0);
                }
                JViewerApp.getInstance().OnVideoStopRedirection();
                JViewerApp.getInstance().getM_frame().windowClosed();
                break;
            }
            case 14: {
                Debug.out.println("*** Encryption Status");
                JViewerApp.getInstance().OnEncryptionStatus();
                break;
            }
            case 15: {
                Debug.out.println("*** Initial Encryption Status");
                JViewerApp.getInstance().OnInitialEncryptionStatus();
                break;
            }
            case 10: {
                Debug.out.println("*** Get Mouse Mode Response");
                JViewerApp.getInstance().OnGetMouseMode(this.m_ctrlMsg.get());
                break;
            }
            case 19: {
                Debug.out.println("*** ADVISER_VALIDATE_VIDEO_SESSION_RESPONSE");
                JViewerApp.getInstance().OnValidateVideoSessionResp(this.m_ctrlMsg.get());
                break;
            }
            case 20: {
                byte status = this.m_ctrlMsg.get();
                if (JViewer.isWebPreviewer()) break;
                JViewerApp.getInstance().onKeybdLED(status);
                JViewerApp.getInstance().getM_wndFrame().getM_status().setKeyboardLEDStatus(status);
                break;
            }
            case 23: {
                if (JViewer.isWebPreviewer()) {
                    JViewerApp.getInstance().onSendWebPreviewerSession();
                    break;
                }
                JViewerApp.getInstance().OnsendWebsessionToken();
                break;
            }
            case 22: {
                JViewerApp.getInstance().OnVideoStopRedirection();
                JOptionPane.showMessageDialog(JViewerApp.getInstance().getRCView(), "Maximum number of allowable sessions reached. Please close other sessions and try again", "Information", 0);
                if (JViewer.isStandalone()) {
                    System.exit(0);
                    break;
                }
                JViewerApp.getInstance().getMainWindow().dispose();
                break;
            }
            case 33: {
                if (KVMSharing.KVM_PRIV_RES_USER != KVMSharing.KVM_PRIV_RES_USER2) {
                    KVMSharing.KVM_REQ_GIVEN = 0;
                    Debug.out.println("else if IVTPPktHdr.KVM_REQ_GIVEN == IVTPPktHdr.KVM_REQ_PARTIAL");
                }
                JViewerApp.getInstance().onStopConcurrentSession();
                break;
            }
            case 32: {
                if (this.m_pktHdr.pktSize > 0) {
                    byte[] Other_UserName = null;
                    Other_UserName = new byte[this.m_pktHdr.pktSize];
                    for (int i = 0; i < this.m_pktHdr.pktSize; ++i) {
                        Other_UserName[i] = this.m_ctrlMsg.get();
                    }
                    String temp = new String(Other_UserName);
                    String Other_UserName_Trim = temp.substring(0, 63);
                    String userIpTrim = temp.substring(64, 97);
                    KVMSharing.KVM_CLIENT_USERNAME = Other_UserName_Trim.trim();
                    KVMSharing.KVM_CLIENT_IP = userIpTrim.trim();
                }
                JViewerApp.getInstance().OnKvmPrevilage(this.m_pktHdr.status);
                break;
            }
            case 27: {
                JViewerApp.getInstance().setWebPreviewerCaptureStatus(this.m_ctrlMsg.get());
                break;
            }
            case 34: {
                byte pwrStatus = (byte)this.m_pktHdr.status();
                Debug.out.println("POWER STATUS : " + pwrStatus);
                JViewerApp.getInstance().onGetPowerControlStatus(pwrStatus);
                break;
            }
            case 36: {
                byte pwrCtrlResponse = (byte)this.m_pktHdr.status();
                Debug.out.println("RESPONSE : " + pwrCtrlResponse);
                JViewerApp.getInstance().onPowerControlResponse(pwrCtrlResponse);
                break;
            }
            case 37: {
                this.readConfServiceData();
                break;
            }
            case 38: {
                this.onreadmouse_media_count();
                break;
            }
            default: {
                JViewerApp.getInstance().getSockvmclient().onSocControlMessage(this.m_pktHdr, this.m_ctrlMsg);
            }
        }
    }

    public boolean redirection() {
        return this.m_redirection;
    }

    public int OnFormIVTPHdr_Send(short packettype, int packetsize, short status) {
        IVTPPktHdr ivtphdr = new IVTPPktHdr(packettype, packetsize, status);
        int ret = this.sendMessage(ivtphdr.array(), ivtphdr.size());
        if (ret != ivtphdr.size()) {
            return -1;
        }
        return ret;
    }

    public void resumeRedirection() {
        this.m_redirection = true;
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)6, 0, (short)0);
        this.m_vidClnt.refresh();
    }

    public void Stop_Cmd_Redirection() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)8, 0, (short)0);
    }

    public void sendLEDrequest() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)20, 0, (short)0);
    }

    public void sendPowerStatusRequest() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)34, 0, (short)0);
    }

    public void sendPowerControlCommand(byte command) {
        this.OnFormIVTPHdr_Send((short)35, 0, command);
    }

    public int startRedirection() {
        if (this.m_redirection) {
            return 0;
        }
        if (-1 == this.connectVideo(this.m_bUseSSL)) {
            return -1;
        }
        Debug.out.println("Video socket approval received");
        this.m_NWListener = new NWListener(this);
        this.m_NWThread = new Thread((Runnable)this.m_NWListener, "listener");
        this.m_NWListener.startListener();
        this.m_NWThread.start();
        return 0;
    }

    public int OnValidVideoSession() {
        this.m_redirection = true;
        JViewerApp.getSoc_manager().getSOCApp().SOC_Session_validated();
        this.sendPowerStatusRequest();
        Debug.out.println("KVM Redirection Started!");
        return 0;
    }

    public boolean isKMEncryptionEnabled() {
        return this.m_encrypt;
    }

    public void notifyEncryption(boolean flag) {
        if (!this.m_redirection) {
            return;
        }
        this.m_encrypt = flag;
    }

    public void stopRedirection() {
        if (!this.m_redirection) {
            return;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.VideoSocketclose();
        this.m_NWListener.destroyListener();
        this.m_redirection = false;
        try {
            this.m_vidClnt.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_kmCrypt.close();
    }

    public void pauseRedirection() {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)4, 0, (short)0);
        this.m_vidClnt.reset();
        this.m_redirection = false;
    }

    public void MediaRedirectionState(byte state) {
        if (!this.m_redirection) {
            return;
        }
        this.OnFormIVTPHdr_Send((short)24, 0, state);
    }

    public int read_data(Socket sockch, byte[] read_buf) {
        int dwIndex = 0;
        int bytes_to_read = read_buf.length;
        int m_readIx = -1;
        while (bytes_to_read != 0) {
            try {
                m_readIx = sockch.getInputStream().read(read_buf, dwIndex, bytes_to_read);
            }
            catch (IOException e) {
                Debug.out.println(e);
                return m_readIx;
            }
            if (m_readIx <= 0) {
                return m_readIx;
            }
            bytes_to_read -= m_readIx;
            dwIndex += m_readIx;
        }
        m_readIx = read_buf.length;
        return m_readIx;
    }

    public int sendKMMessage(USBMessage msg) {
        if (this.m_redirection) {
            byte[] msgArray = this.m_encrypt && this.m_kmCrypt.isInitialized() ? msg.encryptedReport(this.m_kmCrypt) : msg.report();
            if (JViewerApp.getInstance().getM_view().getM_USBKeyRep().KeyBoardDataNull) {
                JViewerApp.getInstance().getM_view().getM_USBKeyRep().KeyBoardDataNull = false;
                return 0;
            }
            if (msgArray == null) {
                return 0;
            }
            if (this.sendMessage(msgArray, msgArray.length) != msgArray.length) {
                Debug.out.println("Error sending USB Keyboard/Mouse packet");
                return -1;
            }
        }
        return 0;
    }

    public int SendKVMPrevilage(byte User2_status) {
        Debug.out.println("User2_status" + User2_status);
        short send_status = (short)(1 + (User2_status << 8));
        Debug.out.println("send_status" + send_status);
        IVTPPktHdr KVMPrevilage = new IVTPPktHdr(32, 0, send_status);
        if (this.sendMessage(KVMPrevilage.array(), KVMPrevilage.size()) != KVMPrevilage.size()) {
            return 1;
        }
        return 0;
    }

    public int SendMouseMode(byte mouseMode) {
        Debug.out.println("MouseMode" + mouseMode);
        IVTPPktHdr MouseMode = new IVTPPktHdr(28, 0, mouseMode);
        if (this.sendMessage(MouseMode.array(), MouseMode.size()) != MouseMode.size()) {
            return 1;
        }
        return 0;
    }

    public void setEncryption(boolean state) {
        if (!this.m_redirection) {
            return;
        }
        if (state) {
            this.m_encrypt = true;
            this.OnFormIVTPHdr_Send((short)12, 0, (short)0);
        } else {
            this.m_encrypt = false;
            DISABLE_ENCRPT_FLAG = true;
            this.OnFormIVTPHdr_Send((short)13, 0, (short)0);
        }
    }

    public KMCrypt getCrypt() {
        return this.m_kmCrypt;
    }

    public int setBandwidth(int bandwidth) {
        if (!this.m_redirection) {
            return -1;
        }
        CfgBandwidth cfgBw = new CfgBandwidth(bandwidth);
        if (cfgBw.size() != this.sendMessage(cfgBw.report(), cfgBw.size())) {
            Debug.out.println("Failed to send Config Bandwidth message");
            return -1;
        }
        return 0;
    }

    public int autoDetect() {
        if (!this.m_redirection) {
            return -1;
        }
        AutoDetectBw ad = new AutoDetectBw(0xC80000);
        if (ad.size() != this.sendMessage(ad.report(), ad.size())) {
            Debug.out.println("Failed to send auto detect message");
            return -1;
        }
        return 0;
    }

    public void onStartReading() {
        this.m_startTS = System.currentTimeMillis();
    }

    public void onStopReading() {
        this.m_stopTS = System.currentTimeMillis();
        int bandwidth = CfgBandwidth.determineBandwidth(this.m_stopTS - this.m_startTS);
        Debug.out.println("Time " + (this.m_stopTS - this.m_startTS) + ", Bandwidth " + bandwidth);
        String bwMsg = "unknown";
        JViewerApp.getInstance().OnOptionsBandwidth(bandwidth);
        switch (bandwidth) {
            case 0xC80000: {
                bwMsg = "100mbps";
                break;
            }
            case 0x140000: {
                bwMsg = "10mbps";
                break;
            }
            case 131072: {
                bwMsg = "1mbps";
                break;
            }
            case 65536: {
                bwMsg = "512kbps";
                break;
            }
            case 32768: {
                bwMsg = "256kbps";
            }
        }
        JViewerApp.getInstance().updateBandwidthMsg(bwMsg);
    }

    public KVMReader getSocReader(short s) {
        return (KVMReader)JViewerApp.getInstance().getSockvmclient().getSOCReader(s);
    }

    public boolean isM_redirection() {
        return this.m_redirection;
    }

    public void setM_redirection(boolean m_redirection) {
        this.m_redirection = m_redirection;
    }

    public void readConfServiceData() {
        block6: {
            if (this.m_pktHdr.pktSize <= 0) break block6;
            byte[] confDataBuffer = new byte[255];
            this.m_ctrlMsg.get(confDataBuffer);
            int iteration = 0;
            if (this.confPacket == null) {
                this.confPacket = new ConfPkt[5];
                byte[] tempDataBuffer = new byte[51];
                for (int i = 0; i < 5; ++i) {
                    for (int j = 0; j < 51; ++j) {
                        tempDataBuffer[j] = confDataBuffer[j + iteration];
                    }
                    this.confPacket[i] = new ConfPkt(tempDataBuffer);
                    iteration += 51;
                }
            } else {
                ConfPkt[] tempconfPacket = new ConfPkt[5];
                byte[] tempDataBuffer = new byte[51];
                for (int index = 0; index < 5; ++index) {
                    for (int j = 0; j < 51; ++j) {
                        tempDataBuffer[j] = confDataBuffer[j + iteration];
                    }
                    tempconfPacket[index] = new ConfPkt(tempDataBuffer);
                    this.compareConfData(tempconfPacket[index], index);
                    iteration += 51;
                }
            }
        }
    }

    public void compareConfData(ConfPkt compObj, int index) {
        String errorString = "";
        if (compObj.getCurrentState() != this.confPacket[index].getCurrentState()) {
            errorString = compObj.getCurrentState() == 0 ? errorString + "* Curruent State : Inactive\n" : errorString + "* Curruent State : Active\n";
            this.confPacket[index].setCurrentState(compObj.getCurrentState());
            this.onChangeState(compObj, compObj.getServiceName());
        }
        if (!compObj.getInterfaceName().equals(this.confPacket[index].getInterfaceName())) {
            errorString = errorString + "* Interface\n";
            this.confPacket[index].setInterfaceName(compObj.getInterfaceName().toCharArray());
        }
        if (compObj.getNonSecureAccessPort() != this.confPacket[index].getNonSecureAccessPort()) {
            errorString = errorString + "* Non-secure Port Number\n";
            this.confPacket[index].setNonSecureAccessPort(compObj.getNonSecureAccessPort());
            this.onChangeNonSecurePort(compObj, compObj.getServiceName());
        }
        if (compObj.getSecureAccessPort() != this.confPacket[index].getSecureAccessPort()) {
            errorString = errorString + "* Secure port Number\n";
            this.confPacket[index].setSecureAccessPort(compObj.getSecureAccessPort());
            this.onChangeSecurePort(compObj, compObj.getServiceName());
        }
        if (compObj.getSessionInactivityTimeout() != this.confPacket[index].getSessionInactivityTimeout()) {
            errorString = errorString + "* Session Inactivity Timeout\n";
            this.confPacket[index].setSessionInactivityTimeout(compObj.getSessionInactivityTimeout());
        }
        if (compObj.getMaxAllowedSessions() != this.confPacket[index].getMaxAllowedSessions()) {
            errorString = errorString + "* Maximum Sessions Allowed\n";
            this.confPacket[index].setMaxAllowedSessions(compObj.getMaxAllowedSessions());
        }
        if (compObj.getMaxSessionInactivityTimeout() != this.confPacket[index].getMaxSessionInactivityTimeout()) {
            errorString = errorString + "* MAximum Session Inactivity Timeout\n";
            this.confPacket[index].setMaxSessionInactivityTimeout(compObj.getMaxSessionInactivityTimeout());
        }
        if (compObj.getMinSessionInactivityTimeout() != this.confPacket[index].getMinSessionInactivityTimeout()) {
            errorString = errorString + "* Minimum Session Inactivity Timeout\n";
            this.confPacket[index].setMinSessionInactivityTimeout(compObj.getMinSessionInactivityTimeout());
        }
        if (!errorString.equals(null) && errorString.length() != 0) {
            this.confPacket[index].showConfDataChangeMsg(errorString);
        }
    }

    public void onChangeState(ConfPkt compObj, String serviceName) {
        if (serviceName.equals("cd-media")) {
            JViewerApp.getInstance().setM_cdStatus(compObj.getCurrentState());
        }
        if (serviceName.equals("fd-media")) {
            JViewerApp.getInstance().setM_fdStatus(compObj.getCurrentState());
        }
        if (serviceName.equals("hd-media")) {
            JViewerApp.getInstance().setM_hdStatus(compObj.getCurrentState());
        }
    }

    public void onChangeSecurePort(ConfPkt compObj, String serviceName) {
        if (!JViewerApp.getInstance().isM_bVMUseSSL()) {
            return;
        }
        if (serviceName.compareTo("cd-media") == 0) {
            JViewerApp.getInstance().setM_cdPort(compObj.getSecureAccessPort());
        }
        if (serviceName.compareTo("fd-media") == 0) {
            JViewerApp.getInstance().setM_fdPort(compObj.getSecureAccessPort());
        }
        if (serviceName.compareTo("hd-media") == 0) {
            JViewerApp.getInstance().setM_hdPort(compObj.getSecureAccessPort());
        }
        if (JViewerApp.getInstance().m_mediaDlg != null) {
            JViewerApp.getInstance().m_mediaDlg.setVisible(false);
        }
    }

    public void onChangeNonSecurePort(ConfPkt compObj, String serviceName) {
        if (JViewerApp.getInstance().isM_bVMUseSSL()) {
            return;
        }
        if (serviceName.compareTo("cd-media") == 0) {
            JViewerApp.getInstance().setM_cdPort(compObj.getNonSecureAccessPort());
        }
        if (serviceName.compareTo("fd-media") == 0) {
            JViewerApp.getInstance().setM_fdPort(compObj.getNonSecureAccessPort());
        }
        if (serviceName.compareTo("hd-media") == 0) {
            JViewerApp.getInstance().setM_hdPort(compObj.getNonSecureAccessPort());
        }
        if (JViewerApp.getInstance().m_mediaDlg != null) {
            JViewerApp.getInstance().m_mediaDlg.setVisible(false);
        }
    }

    private void onreadmouse_media_count() {
        byte[] Mouse_media = new byte[this.m_pktHdr.pktSize()];
        this.m_ctrlMsg.get(Mouse_media);
        ByteBuffer dataBuffer = ByteBuffer.wrap(Mouse_media);
        dataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte mouse_mode = 0;
        int attach_cd = 0;
        int attach_fd = 0;
        int attach_hd = 0;
        int enable_boot_once = 0;
        int num_cd = 0;
        int num_fd = 0;
        int num_hd = 0;
        int lmedia_enable = 0;
        mouse_mode = dataBuffer.get();
        attach_cd = dataBuffer.getInt();
        attach_fd = dataBuffer.getInt();
        attach_hd = dataBuffer.getInt();
        enable_boot_once = dataBuffer.getInt();
        num_cd = dataBuffer.getInt();
        num_fd = dataBuffer.getInt();
        num_hd = dataBuffer.getInt();
        lmedia_enable = dataBuffer.getInt();
        boolean changed = false;
        if (JViewerApp.getInstance().getM_cdNum() != num_cd) {
            changed = true;
        }
        if (JViewerApp.getInstance().getM_fdNum() != num_fd) {
            changed = true;
        }
        if (JViewerApp.getInstance().getM_hdNum() != num_hd) {
            changed = true;
        }
        if (changed) {
            JViewerApp.getInstance().syncVMediaRedirection();
            if (JViewerApp.getInstance().getM_mediaDlg() != null) {
                vMediaDialog vmDialog = JViewerApp.getInstance().getM_mediaDlg();
                JOptionPane.showMessageDialog(vmDialog, "VMedia configuration changed. Closing the VMedia dialog.", "VMedia Configuration Change", 1);
                vmDialog.dispose();
            } else {
                JFrame parent = JViewer.getMainFrame();
                JOptionPane.showMessageDialog(parent, "VMedia configuration changed. Closing any active redirections.", "VMedia Configuration Change", 1);
            }
            JViewerApp.getInstance().setM_cdNum(num_cd);
            JViewerApp.getInstance().setM_fdNum(num_fd);
            JViewerApp.getInstance().setM_hdNum(num_hd);
            JViewerApp.getInstance().create_IUSBSession();
        }
        if (JViewerApp.getInstance().getRCView().GetUSBMouseMode() != mouse_mode) {
            JViewerApp.getInstance().getRCView().removeKMListener();
            JViewerApp.getInstance().getRCView().USBsyncCursor(false);
            JViewerApp.getInstance().OnGetMouseMode(mouse_mode);
        }
    }
}

