/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.LogUtil;
import com.supermicro.ipmi.MessageCenter;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.text.MOut;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.CRC32;

public class IPMIAMIYAFUCommand
extends IPMICommand {
    MOut mout = MOut.G();
    public static String YAFU_FLASH_VERSION = "V2.0";
    Progress progress;
    YafuStatus yafuStatus = new YafuStatus();
    FirmwareFile preLoadFirmwareFile;

    public void setMOut(MOut mout) {
        this.mout = mout;
    }

    public IPMIAMIYAFUCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    public IPMIMessage getFlashInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 1;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)1, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFirmwareInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 2;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)2, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getFMHInfoCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 3;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)3, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 4;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)4, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage activateFlashModeCommand(byte[] mode) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 16;
        ByteUtility.intTo2Bytes(header.datalen, 0, mode.length);
        header.calCRC32(mode);
        byte[] headerBytes = header.toRaw();
        byte[] data = new byte[headerBytes.length + mode.length];
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        System.arraycopy(mode, 0, data, headerBytes.length, 2);
        ipmiMessage.setCommandAndData((byte)-56, (byte)16, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage allocateMemoryCommand(byte[] size) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 32;
        ByteUtility.intTo2Bytes(header.datalen, 0, size.length);
        header.calCRC32(size);
        byte[] headerBytes = header.toRaw();
        byte[] data = new byte[headerBytes.length + size.length];
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        System.arraycopy(size, 0, data, headerBytes.length, 4);
        ipmiMessage.setCommandAndData((byte)-56, (byte)32, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage freeMemoryCommand(byte[] addrtobeFreed) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 33;
        ByteUtility.intTo2Bytes(header.datalen, 0, addrtobeFreed.length);
        header.calCRC32(addrtobeFreed);
        byte[] data = new byte[header.toRaw().length + addrtobeFreed.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        System.arraycopy(addrtobeFreed, 0, data, headerBytes.length, 4);
        ipmiMessage.setCommandAndData((byte)-56, (byte)33, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readFlashCommand(byte[] offsetToRead, byte readWidth, byte[] sizeToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 34;
        ByteUtility.intTo2Bytes(header.datalen, 0, offsetToRead.length + 1 + sizeToRead.length);
        header.resetCRC32();
        header.updateCRC32(offsetToRead);
        header.updateCRC32(readWidth);
        header.updateCRC32(sizeToRead);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + offsetToRead.length + 1 + sizeToRead.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(offsetToRead, 0, data, index, offsetToRead.length);
        data[index += offsetToRead.length] = readWidth;
        System.arraycopy(sizeToRead, 0, data, ++index, sizeToRead.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)34, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeFlashCommand(byte[] offsetToWrite, byte writeWidth, byte[] rawToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 35;
        ByteUtility.intTo2Bytes(header.datalen, 0, offsetToWrite.length + 1 + rawToWrite.length);
        header.resetCRC32();
        header.updateCRC32(offsetToWrite);
        header.updateCRC32(writeWidth);
        header.updateCRC32(rawToWrite);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + offsetToWrite.length + 1 + rawToWrite.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(offsetToWrite, 0, data, index, offsetToWrite.length);
        data[index += offsetToWrite.length] = writeWidth;
        System.arraycopy(rawToWrite, 0, data, ++index, rawToWrite.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)35, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage eraseFlashCommand(byte[] blkNumToErase) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 36;
        ByteUtility.intTo2Bytes(header.datalen, 0, blkNumToErase.length);
        header.calCRC32(blkNumToErase);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + blkNumToErase.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(blkNumToErase, 0, data, index, blkNumToErase.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)36, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage protectFlashCommand(byte[] blkNum, byte protect) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 37;
        ByteUtility.intTo2Bytes(header.datalen, 0, blkNum.length + 1);
        header.resetCRC32();
        header.updateCRC32(blkNum);
        header.updateCRC32(protect);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + 4 + 1];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(blkNum, 0, data, index, blkNum.length);
        data[index += blkNum.length] = protect;
        ipmiMessage.setCommandAndData((byte)-56, (byte)37, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage eraseCopyFlashCommand(byte[] memOffset, byte[] flashOffset, byte[] sizeToCopy) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 38;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffset.length + flashOffset.length + sizeToCopy.length);
        header.updateCRC32(memOffset);
        header.updateCRC32(flashOffset);
        header.updateCRC32(sizeToCopy);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffset.length + flashOffset.length + sizeToCopy.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffset, 0, data, index, memOffset.length);
        System.arraycopy(flashOffset, 0, data, index += memOffset.length, flashOffset.length);
        System.arraycopy(sizeToCopy, 0, data, index += flashOffset.length, sizeToCopy.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)38, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getECFStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 4;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)40, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getVerifyStatusCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 4;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)41, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage verifyFlashCommand(byte[] memOffset, byte[] flashOffset, byte[] sizeToVerify) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 39;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffset.length + flashOffset.length + sizeToVerify.length);
        header.resetCRC32();
        header.updateCRC32(memOffset);
        header.updateCRC32(flashOffset);
        header.updateCRC32(sizeToVerify);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffset.length + flashOffset.length + sizeToVerify.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffset, 0, data, index, memOffset.length);
        System.arraycopy(flashOffset, 0, data, index += memOffset.length, flashOffset.length);
        System.arraycopy(sizeToVerify, 0, data, index += flashOffset.length, sizeToVerify.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)39, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readMemoryCommand(byte[] memOffset, byte readWidth, byte[] sizeToRead) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 48;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffset.length + 1 + sizeToRead.length);
        header.resetCRC32();
        header.updateCRC32(memOffset);
        header.updateCRC32(readWidth);
        header.updateCRC32(sizeToRead);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffset.length + 1 + sizeToRead.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffset, 0, data, index, memOffset.length);
        data[index += memOffset.length] = readWidth;
        System.arraycopy(sizeToRead, 0, data, ++index, sizeToRead.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)48, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeMemoryCommand(byte[] memOffset, byte writeWidth, byte[] rawToWrite) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 49;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffset.length + 1 + rawToWrite.length);
        header.resetCRC32();
        header.updateCRC32(memOffset);
        header.updateCRC32(writeWidth);
        header.updateCRC32(rawToWrite);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffset.length + 1 + rawToWrite.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffset, 0, data, index, memOffset.length);
        data[index += memOffset.length] = writeWidth;
        System.arraycopy(rawToWrite, 0, data, ++index, rawToWrite.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)49, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage copyMemoryCommand(byte[] memOffsetSrc, byte[] memOffsetDest, byte[] sizeToCopy) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 50;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffsetSrc.length + memOffsetDest.length + sizeToCopy.length);
        header.resetCRC32();
        header.updateCRC32(memOffsetSrc);
        header.updateCRC32(memOffsetDest);
        header.updateCRC32(sizeToCopy);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffsetSrc.length + memOffsetDest.length + sizeToCopy.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffsetSrc, 0, data, index, memOffsetSrc.length);
        System.arraycopy(memOffsetDest, 0, data, index += memOffsetSrc.length, memOffsetDest.length);
        System.arraycopy(sizeToCopy, 0, data, index += memOffsetDest.length, sizeToCopy.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)50, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage compareMemoryCommand(byte[] memOffset1, byte[] memOffset2, byte[] sizeToComp) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 51;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffset1.length + memOffset2.length + sizeToComp.length);
        header.resetCRC32();
        header.updateCRC32(memOffset1);
        header.updateCRC32(memOffset2);
        header.updateCRC32(sizeToComp);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffset1.length + memOffset2.length + sizeToComp.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffset1, 0, data, index, memOffset1.length);
        System.arraycopy(memOffset2, 0, data, index += memOffset1.length, memOffset2.length);
        System.arraycopy(sizeToComp, 0, data, index += memOffset2.length, sizeToComp.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)51, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage clearMemoryCommand(byte[] memOffToClear, byte[] sizeToClear) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 52;
        ByteUtility.intTo2Bytes(header.datalen, 0, memOffToClear.length + sizeToClear.length);
        header.resetCRC32();
        header.updateCRC32(memOffToClear);
        header.updateCRC32(sizeToClear);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + memOffToClear.length + sizeToClear.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(memOffToClear, 0, data, index, memOffToClear.length);
        System.arraycopy(sizeToClear, 0, data, index += memOffToClear.length, sizeToClear.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)52, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBootConfigCommand(byte[] varName) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 64;
        byte[] varName65Byte = new byte[65];
        System.arraycopy(varName, 0, varName65Byte, 0, varName.length);
        ByteUtility.intTo2Bytes(header.datalen, 0, varName65Byte.length);
        header.calCRC32(varName65Byte);
        byte[] data = new byte[header.toRaw().length + varName65Byte.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        System.arraycopy(varName, 0, data, headerBytes.length, varName.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)64, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setBootConfigCommand(byte[] varName, byte[] value) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 65;
        byte[] varName65Byte = new byte[65];
        System.arraycopy(varName, 0, varName65Byte, 0, varName.length);
        ByteUtility.intTo2Bytes(header.datalen, 0, varName65Byte.length + value.length);
        header.resetCRC32();
        header.updateCRC32(varName65Byte);
        header.updateCRC32(value);
        int index = 0;
        byte[] data = new byte[header.toRaw().length + varName65Byte.length + value.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        index = headerBytes.length;
        System.arraycopy(varName65Byte, 0, data, index, varName65Byte.length);
        System.arraycopy(value, 0, data, index += varName65Byte.length, value.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)65, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getBootVarsCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 66;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)66, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage deactivateFlashCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 80;
        byte[] data = header.toRaw();
        ipmiMessage.setCommandAndData((byte)-56, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public void resetDeviceCommand(byte[] waitSec) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        YafuHeader header = new YafuHeader();
        header.yafuCmd[0] = 81;
        ByteUtility.intTo2Bytes(header.datalen, 0, waitSec.length);
        header.calCRC32(waitSec);
        byte[] data = new byte[header.toRaw().length + waitSec.length];
        byte[] headerBytes = header.toRaw();
        System.arraycopy(headerBytes, 0, data, 0, headerBytes.length);
        System.arraycopy(waitSec, 0, data, headerBytes.length, waitSec.length);
        ipmiMessage.setCommandAndData((byte)-56, (byte)81, data);
        this.ipmiInterface.drop(ipmiMessage);
    }

    private void API____________() {
    }

    public FlashInfo getFlashInfo() throws Exception {
        IPMIMessage resMessage = this.getFlashInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            FlashInfo flashDetails = new FlashInfo();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, flashDetails.raw, 0, flashDetails.raw.length);
            yafuHeader.fromRaw(yafuHeader.raw);
            flashDetails.formRaw(flashDetails.raw);
            return flashDetails;
        }
        throw new IPMIException("Call getFlashInfoCommand failed");
    }

    public FirmwareInfo getFirmwareInfo() throws Exception {
        IPMIMessage resMessage = this.getFirmwareInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            FirmwareInfo firmwareInfo = new FirmwareInfo();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, firmwareInfo.raw, 0, firmwareInfo.raw.length);
            yafuHeader.fromRaw(yafuHeader.raw);
            firmwareInfo.formRaw(firmwareInfo.raw);
            return firmwareInfo;
        }
        throw new IPMIException("Call getFirmwareInfoCommand failed");
    }

    public FMHInfo[] getFMHInfo() throws Exception {
        IPMIMessage resMessage = this.getFMHInfoCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] reversed = new byte[2];
            byte[] numFMH = new byte[2];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, reversed, 0, reversed.length);
            System.arraycopy(resMessage.data, index += reversed.length, numFMH, 0, numFMH.length);
            index += numFMH.length;
            int numOfFMH = ByteUtility.twoBytesToIntLSB(numFMH);
            FMHInfo[] fmhInfos = new FMHInfo[numOfFMH];
            for (int i = 0; i < fmhInfos.length; ++i) {
                byte[] raw = new byte[64];
                System.arraycopy(resMessage.data, index, raw, 0, raw.length);
                index += raw.length;
                fmhInfos[i] = new FMHInfo();
                fmhInfos[i].fromRaw(raw);
            }
            return fmhInfos;
        }
        throw new IPMIException("Call getFMHInfoCommand failed");
    }

    public Status getStatus() throws Exception {
        IPMIMessage resMessage = this.getStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            Status status = new Status();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, status.raw, 0, status.raw.length);
            yafuHeader.fromRaw(yafuHeader.raw);
            status.formRaw(status.raw);
            return status;
        }
        throw new IPMIException("Call getStatusCommand failed");
    }

    public byte activateFlashMode() throws Exception {
        byte[] mode = new byte[]{0, 0};
        IPMIMessage resMessage = this.activateFlashModeCommand(mode);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte delay = 0;
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            yafuHeader.fromRaw(yafuHeader.raw);
            index = yafuHeader.raw.length;
            delay = resMessage.data[index];
            return delay;
        }
        throw new IPMIException("Call activateFlashModeCommand failed");
    }

    public int allocateMemory(int size) throws Exception {
        byte[] sizeBytes = new byte[4];
        ByteUtility.intTo4Bytes(sizeBytes, 0, size);
        IPMIMessage resMessage = this.allocateMemoryCommand(sizeBytes);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] addofAllocMem = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            yafuHeader.fromRaw(yafuHeader.raw);
            System.arraycopy(resMessage.data, index, addofAllocMem, 0, addofAllocMem.length);
            int addr = ByteUtility.fourBytesToIntByLSBFirst(addofAllocMem);
            return addr;
        }
        throw new IPMIException("Call allocateMemory failed");
    }

    public byte freeMemory(int intAddrToBeFreed) throws Exception {
        byte[] addrToBeFreed = new byte[4];
        ByteUtility.intTo4Bytes(addrToBeFreed, 0, intAddrToBeFreed);
        IPMIMessage resMessage = this.freeMemoryCommand(addrToBeFreed);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            return status;
        }
        throw new IPMIException("Call freeMemoryCommand failed");
    }

    public byte[] readFlash(int intOffsetToRead, byte readWidth, int intSizeToRead) throws Exception {
        byte[] offsetToRead = new byte[4];
        ByteUtility.intTo4Bytes(offsetToRead, 0, intOffsetToRead);
        byte[] sizeToRead = new byte[2];
        ByteUtility.intTo2Bytes(sizeToRead, 0, intSizeToRead);
        IPMIMessage resMessage = this.readFlashCommand(offsetToRead, readWidth, sizeToRead);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            yafuHeader.fromRaw(yafuHeader.raw);
            byte[] raw = new byte[resMessage.data.length - yafuHeader.raw.length];
            System.arraycopy(resMessage.data, index, raw, 0, raw.length);
            return raw;
        }
        throw new IPMIException("Call readFlashCommand failed");
    }

    public int writeFlash(byte[] offsetToWrite, byte writeWidth, byte[] rawToWrite) throws Exception {
        IPMIMessage resMessage = this.writeFlashCommand(offsetToWrite, writeWidth, rawToWrite);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] sizeWritten = new byte[2];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, sizeWritten, 0, sizeWritten.length);
            return ByteUtility.twoBytesToInt(sizeWritten);
        }
        throw new IPMIException("Call writeFlashCommand failed");
    }

    public byte eraseFlash(byte[] blkNumToErase) throws Exception {
        IPMIMessage resMessage = this.eraseFlashCommand(blkNumToErase);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            return status;
        }
        throw new IPMIException("Call eraseFlashCommand failed");
    }

    public byte protectFlash(byte[] blkNum, byte protect) throws Exception {
        IPMIMessage resMessage = this.protectFlashCommand(blkNum, protect);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            return status;
        }
        throw new IPMIException("Call protectFlashCommand failed");
    }

    public int eraseCopyFlash(int intMemOffset, int intFlashOffset, int intSizeToCopy) throws Exception {
        byte[] memOffset = new byte[4];
        ByteUtility.intTo4Bytes(memOffset, 0, intMemOffset);
        byte[] flashOffset = new byte[4];
        ByteUtility.intTo4Bytes(flashOffset, 0, intFlashOffset);
        byte[] sizeToCopy = new byte[4];
        ByteUtility.intTo4Bytes(sizeToCopy, 0, intSizeToCopy);
        IPMIMessage resMessage = this.eraseCopyFlashCommand(memOffset, flashOffset, sizeToCopy);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] sizeCopied = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, sizeCopied, 0, sizeCopied.length);
            return ByteUtility.fourBytesToIntByLSBFirst(sizeCopied);
        }
        throw new IPMIException("Call eraseCopyFlashCommand failed");
    }

    public ECFStatus getECFStatus() throws Exception {
        IPMIMessage resMessage = this.getECFStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            ECFStatus ecsStatus = new ECFStatus();
            System.arraycopy(resMessage.data, index, ecsStatus.status, 0, 4);
            System.arraycopy(resMessage.data, index + 4, ecsStatus.progress, 0, 2);
            return ecsStatus;
        }
        throw new IPMIException("Call getECFStatusCommand failed");
    }

    public VerifyStatus getVerifyStatus() throws Exception {
        IPMIMessage resMessage = this.getVerifyStatusCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            VerifyStatus verifyStatus = new VerifyStatus();
            System.arraycopy(resMessage.data, index, verifyStatus.status, 0, 2);
            System.arraycopy(resMessage.data, index + 4, verifyStatus.offset, 0, 4);
            System.arraycopy(resMessage.data, index + 8, verifyStatus.progress, 0, 2);
            return verifyStatus;
        }
        throw new IPMIException("Call getVerifyStatusCommand failed");
    }

    public byte[] verifyFlash(int intMemOffset, int intFlashOffset, int intSizeToVerify) throws Exception {
        byte[] memOffset = new byte[4];
        ByteUtility.intTo4Bytes(memOffset, 0, intMemOffset);
        byte[] flashOffset = new byte[4];
        ByteUtility.intTo4Bytes(flashOffset, 0, intFlashOffset);
        byte[] sizeToVerify = new byte[4];
        ByteUtility.intTo4Bytes(sizeToVerify, 0, intSizeToVerify);
        IPMIMessage resMessage = this.verifyFlashCommand(memOffset, flashOffset, sizeToVerify);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] offset = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, offset, 0, offset.length);
            return offset;
        }
        throw new IPMIException("Call verifyFlashCommand failed");
    }

    public byte[] readMemory(int intMemOffset, byte readWidth, byte[] sizeToRead) throws Exception {
        byte[] memOffset = new byte[4];
        ByteUtility.intTo4Bytes(memOffset, 0, intMemOffset);
        IPMIMessage resMessage = this.readMemoryCommand(memOffset, readWidth, sizeToRead);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            byte[] raw = new byte[resMessage.data.length - yafuHeader.raw.length];
            System.arraycopy(resMessage.data, index, raw, 0, raw.length);
            return raw;
        }
        throw new IPMIException("Call readMemoryCommand failed");
    }

    public int writeMemory(int intMemOffset, byte writeWidth, byte[] rawToWrite) throws Exception {
        byte[] memOffset = new byte[4];
        ByteUtility.intTo4Bytes(memOffset, 0, intMemOffset);
        IPMIMessage resMessage = this.writeMemoryCommand(memOffset, writeWidth, rawToWrite);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] sizeWritten = new byte[2];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, sizeWritten, 0, sizeWritten.length);
            return ByteUtility.twoBytesToInt(sizeWritten);
        }
        throw new IPMIException("Call writeMemoryCommand failed");
    }

    public int copyMemory(byte[] memOffsetSrc, byte[] memOffsetDest, byte[] sizeToCopy) throws Exception {
        IPMIMessage resMessage = this.copyMemoryCommand(memOffsetSrc, memOffsetDest, sizeToCopy);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] sizeCopied = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, sizeCopied, 0, sizeCopied.length);
            return ByteUtility.fourBytesToIntByLSBFirst(sizeCopied);
        }
        throw new IPMIException("Call copyMemoryCommand failed");
    }

    public byte[] compareMemory(byte[] memOffset1, byte[] memOffset2, byte[] sizeToComp) throws Exception {
        IPMIMessage resMessage = this.compareMemoryCommand(memOffset1, memOffset2, sizeToComp);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] offset = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, offset, 0, offset.length);
            return offset;
        }
        throw new IPMIException("Call compareMemoryCommand failed");
    }

    public int clearMemory(byte[] memOffsetToClear, byte[] sizeToClear) throws Exception {
        IPMIMessage resMessage = this.clearMemoryCommand(memOffsetToClear, sizeToClear);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            byte[] sizeCleared = new byte[4];
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            System.arraycopy(resMessage.data, index, sizeCleared, 0, sizeCleared.length);
            return ByteUtility.fourBytesToIntByLSBFirst(sizeCleared);
        }
        throw new IPMIException("Call clearMemoryCommand failed");
    }

    public StatusResult getBootConfig(byte[] varName) throws Exception {
        IPMIMessage resMessage = this.getBootConfigCommand(varName);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            byte[] result = new byte[resMessage.data.length - ++index];
            System.arraycopy(resMessage.data, index, result, 0, result.length);
            StatusResult statusResult = new StatusResult();
            statusResult.status = status;
            statusResult.result = result;
            return statusResult;
        }
        throw new IPMIException("Call getBootConfig failed");
    }

    public byte setBootConfig(byte[] varName, byte[] value) throws Exception {
        IPMIMessage resMessage = this.setBootConfigCommand(varName, value);
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            return status;
        }
        throw new IPMIException("Call setBootConfig failed");
    }

    public StatusResult getBootVars() throws Exception {
        IPMIMessage resMessage = this.getBootVarsCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            byte[] result = new byte[resMessage.data.length - ++index];
            System.arraycopy(resMessage.data, index, result, 0, result.length);
            StatusResult statusResult = new StatusResult();
            statusResult.status = status;
            statusResult.result = result;
            return statusResult;
        }
        throw new IPMIException("Call getBootVarsCommand failed");
    }

    public byte deactivateFlash() throws Exception {
        IPMIMessage resMessage = this.deactivateFlashCommand();
        if (resMessage != null && resMessage.completionCode == 0) {
            byte code = this.yafuStatus.isFail(resMessage.data);
            if (code != 0) {
                throw new IPMIException(this.yafuStatus.getErrorMessage(code));
            }
            YafuHeader yafuHeader = new YafuHeader();
            int index = 0;
            System.arraycopy(resMessage.data, index, yafuHeader.raw, 0, yafuHeader.raw.length);
            index = yafuHeader.raw.length;
            byte status = resMessage.data[index];
            return status;
        }
        throw new IPMIException("Call deactivateFlashCommand failed");
    }

    public void dropResetDevice(int waitSec) throws Exception {
        byte[] waitSecBytes = new byte[2];
        ByteUtility.intTo2Bytes(waitSecBytes, 0, waitSec);
        this.resetDeviceCommand(waitSecBytes);
    }

    private void INNER_CLASS____________() {
    }

    public FirmwareFile getFirmwareFile(String filename) {
        return new FirmwareFile(filename);
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void setPreLoadFirmwareFile(FirmwareFile preLoadFirmwareFile) {
        this.preLoadFirmwareFile = preLoadFirmwareFile;
    }

    public Progress getProgress() {
        return this.progress;
    }

    public FirmwareFile getPreLoadFirmwareFile() {
        return this.preLoadFirmwareFile;
    }

    private void FUNCTION____________() {
    }

    public SortedMap<String, byte[]> backupBootConfig() throws Exception {
        TreeMap<String, byte[]> bootConfig = new TreeMap<String, byte[]>();
        StatusResult statusResut = this.getBootVars();
        for (int i = 0; i < statusResut.result.length; ++i) {
            if (statusResut.result[i] != 0) continue;
            statusResut.result[i] = 32;
        }
        StringTokenizer st = new StringTokenizer(new String(statusResut.result), " ");
        while (st.hasMoreTokens()) {
            String var = st.nextToken();
            StatusResult sResult = this.getBootConfig(var.getBytes());
            bootConfig.put(var, sResult.result);
        }
        return bootConfig;
    }

    public void restoreBootConfig(SortedMap<String, byte[]> bootConfig) throws Exception {
        for (String var : bootConfig.keySet()) {
            byte[] value = (byte[])bootConfig.get(var);
            this.setBootConfig(var.getBytes(), value);
        }
    }

    private void flashWorker(FirmwareFile firmwareFile, boolean isUpgradeBoot, boolean isUpgradeConfig) throws Exception {
        int totalTimeSpentCount;
        int chunkSize = 512;
        int upgradedBytes = 0;
        int sizeToFlash = 0;
        int eraseBlockSize = 0;
        int totalTimeSpentCountBak = totalTimeSpentCount = 5;
        long[] timeSpent = new long[totalTimeSpentCount];
        long avgTimeSpent = 0L;
        boolean alreadySkipConfig = false;
        boolean alreadySkipBoot = false;
        FMHInfo bootFMHInfo = firmwareFile.getBootFMH();
        FMHInfo configFHMInfo = firmwareFile.getConfigFMH();
        FlashInfo flashInfo = this.getFlashInfo();
        FirmwareInfo firmwareInfo = this.getFirmwareInfo();
        Status status = this.getStatus();
        RandomAccessFile raf = new RandomAccessFile(firmwareFile.firmware, "r");
        eraseBlockSize = ByteUtility.fourBytesToIntByLSBFirst(flashInfo.flashEraseBlkSize);
        while ((long)upgradedBytes < firmwareFile.fileSize()) {
            int configLocation;
            int bootLocation;
            Calendar chuckstartTime = Calendar.getInstance();
            if (!(isUpgradeBoot || upgradedBytes != (bootLocation = ByteUtility.fourBytesToIntByLSBFirst(bootFMHInfo.fmhLocation)) && upgradedBytes + eraseBlockSize <= bootLocation || alreadySkipBoot)) {
                upgradedBytes += ByteUtility.fourBytesToIntByLSBFirst(bootFMHInfo.allocatedSize);
                alreadySkipBoot = true;
                continue;
            }
            if (!(isUpgradeConfig || upgradedBytes != (configLocation = ByteUtility.fourBytesToIntByLSBFirst(configFHMInfo.fmhLocation)) && upgradedBytes + eraseBlockSize <= configLocation || alreadySkipConfig)) {
                upgradedBytes += ByteUtility.fourBytesToIntByLSBFirst(configFHMInfo.allocatedSize);
                alreadySkipConfig = true;
                continue;
            }
            sizeToFlash = (long)(upgradedBytes + eraseBlockSize) > firmwareFile.fileSize() ? (int)(firmwareFile.fileSize() - (long)upgradedBytes) : eraseBlockSize;
            int startMemaddr = this.allocateMemory(sizeToFlash);
            int offset = upgradedBytes;
            int memaddr = startMemaddr;
            while (offset < upgradedBytes + sizeToFlash) {
                int sizeToRead = offset + chunkSize > offset + sizeToFlash ? offset + sizeToFlash - offset : chunkSize;
                byte[] buffer = new byte[sizeToRead];
                raf.seek(offset);
                raf.read(buffer);
                int writeMemoryRetryCount = 0;
                boolean isWriteMemoryDone = false;
                do {
                    try {
                        this.writeMemory(memaddr, (byte)8, buffer);
                        isWriteMemoryDone = true;
                    }
                    catch (IPMIException ex) {
                        if (++writeMemoryRetryCount <= 3) continue;
                        throw ex;
                    }
                } while (!isWriteMemoryDone);
                offset += sizeToRead;
                memaddr += sizeToRead;
            }
            int sizeCopied = this.eraseCopyFlash(startMemaddr, upgradedBytes, sizeToFlash);
            if (sizeCopied != sizeToFlash) {
                throw new Exception("Error in EraaseAndFlash");
            }
            this.verifyFlash(startMemaddr, upgradedBytes, sizeToFlash);
            byte freeStatus = this.freeMemory(startMemaddr);
            if (freeStatus != 0) {
                throw new Exception("Error in freeMemory");
            }
            if ((long)(upgradedBytes + eraseBlockSize) > firmwareFile.fileSize()) {
                sizeToFlash = (int)(firmwareFile.fileSize() - (long)upgradedBytes);
            }
            upgradedBytes += sizeToFlash;
            Calendar chuckEndTime = Calendar.getInstance();
            long leftTime = 0L;
            if (--totalTimeSpentCount >= 0) {
                timeSpent[totalTimeSpentCount] = chuckEndTime.getTime().getTime() - chuckstartTime.getTime().getTime();
                if (totalTimeSpentCount == 0) {
                    for (int i = 0; i < totalTimeSpentCountBak; ++i) {
                        avgTimeSpent += timeSpent[i];
                    }
                    avgTimeSpent /= (long)totalTimeSpentCountBak;
                }
            } else {
                long leftChunks = (firmwareFile.fileSize() - (long)upgradedBytes) / (long)sizeToFlash;
                leftTime = avgTimeSpent * leftChunks;
                if (this.progress != null) {
                    this.progress.left(leftTime);
                }
            }
            if (this.progress != null) {
                this.progress.setValue((int)((long)(upgradedBytes * 100) / firmwareFile.fileSize()));
                this.progress.message("" + (long)(upgradedBytes * 100) / firmwareFile.fileSize() + "%" + " ( " + this.separatedNumber(upgradedBytes) + " bytes / " + this.separatedNumber(firmwareFile.fileSize()) + " bytes )");
                continue;
            }
            this.mout.print(".");
            if ((long)(upgradedBytes + chunkSize) < firmwareFile.fileSize()) continue;
            this.mout.println("");
        }
        if (this.progress != null) {
            this.progress.left(0L);
        }
        raf.close();
    }

    private void flashWorker_ATEN2AMI(FirmwareFile firmwareFile) throws Exception {
        int totalTimeSpentCount;
        int chunkSize = 512;
        int upgradedBytes = 0;
        int sizeToFlash = 0;
        int eraseBlockSize = 0;
        int totalTimeSpentCountBak = totalTimeSpentCount = 5;
        long[] timeSpent = new long[totalTimeSpentCount];
        long avgTimeSpent = 0L;
        FMHInfo bootFMHInfo = firmwareFile.getBootFMH();
        FMHInfo configFHMInfo = firmwareFile.getConfigFMH();
        FlashInfo flashInfo = this.getFlashInfo();
        FirmwareInfo firmwareInfo = this.getFirmwareInfo();
        Status status = this.getStatus();
        RandomAccessFile raf = new RandomAccessFile(firmwareFile.firmware, "r");
        eraseBlockSize = ByteUtility.fourBytesToIntByLSBFirst(flashInfo.flashEraseBlkSize);
        while ((long)upgradedBytes < firmwareFile.fileSize()) {
            Calendar chuckstartTime = Calendar.getInstance();
            sizeToFlash = (long)(upgradedBytes + eraseBlockSize) > firmwareFile.fileSize() ? (int)(firmwareFile.fileSize() - (long)upgradedBytes) : eraseBlockSize;
            int startMemaddr = this.allocateMemory(sizeToFlash);
            int offset = upgradedBytes;
            int memaddr = startMemaddr;
            while (offset < upgradedBytes + sizeToFlash) {
                int sizeToRead = offset + chunkSize > offset + sizeToFlash ? offset + sizeToFlash - offset : chunkSize;
                byte[] buffer = new byte[sizeToRead];
                raf.seek(offset);
                raf.read(buffer);
                int writeMemoryRetryCount = 0;
                boolean isWriteMemoryDone = false;
                do {
                    try {
                        this.writeMemory(memaddr, (byte)8, buffer);
                        isWriteMemoryDone = true;
                    }
                    catch (IPMIException ex) {
                        if (++writeMemoryRetryCount <= 3) continue;
                        throw ex;
                    }
                } while (!isWriteMemoryDone);
                offset += sizeToRead;
                memaddr += sizeToRead;
            }
            int sizeCopied = this.eraseCopyFlash(startMemaddr, upgradedBytes, sizeToFlash);
            if (sizeCopied != sizeToFlash) {
                throw new Exception("Error in EraaseAndFlash");
            }
            this.verifyFlash(startMemaddr, upgradedBytes, sizeToFlash);
            byte freeStatus = this.freeMemory(startMemaddr);
            if (freeStatus != 0) {
                throw new Exception("Error in freeMemory");
            }
            if ((long)(upgradedBytes + eraseBlockSize) > firmwareFile.fileSize()) {
                sizeToFlash = (int)(firmwareFile.fileSize() - (long)upgradedBytes);
            }
            upgradedBytes += sizeToFlash;
            Calendar chuckEndTime = Calendar.getInstance();
            long leftTime = 0L;
            if (--totalTimeSpentCount >= 0) {
                timeSpent[totalTimeSpentCount] = chuckEndTime.getTime().getTime() - chuckstartTime.getTime().getTime();
                if (totalTimeSpentCount == 0) {
                    for (int i = 0; i < totalTimeSpentCountBak; ++i) {
                        avgTimeSpent += timeSpent[i];
                    }
                    avgTimeSpent /= (long)totalTimeSpentCountBak;
                }
            } else {
                long leftChunks = (firmwareFile.fileSize() - (long)upgradedBytes) / (long)sizeToFlash;
                leftTime = avgTimeSpent * leftChunks;
                if (this.progress != null) {
                    this.progress.left(leftTime);
                }
            }
            if (this.progress != null) {
                this.progress.setValue((int)((long)(upgradedBytes * 100) / firmwareFile.fileSize()));
                this.progress.message("" + (long)(upgradedBytes * 100) / firmwareFile.fileSize() + "%" + " ( " + this.separatedNumber(upgradedBytes) + " bytes / " + this.separatedNumber(firmwareFile.fileSize()) + " bytes )");
                continue;
            }
            this.mout.print(".");
            if ((long)(upgradedBytes + chunkSize) < firmwareFile.fileSize()) continue;
            this.mout.println("");
        }
        if (this.progress != null) {
            this.progress.left(0L);
        }
        raf.close();
    }

    private void flashWorker90(FirmwareFile firmwareFile) throws Exception {
        int sizeCopied;
        int chunkSize = 1024;
        int upgradedBytes = 0;
        int sizeToFlash = 0;
        int eraseBlockSize = 0;
        int startMemAddr = 0;
        int currentProgress = 0;
        int lastProgress = 0;
        Calendar chuckstartTime = Calendar.getInstance();
        Status status = this.getStatus();
        RandomAccessFile raf = new RandomAccessFile(firmwareFile.firmware, "r");
        FlashInfo flashInfo = this.getFlashInfo();
        eraseBlockSize = ByteUtility.fourBytesToIntByLSBFirst(flashInfo.flashEraseBlkSize);
        sizeToFlash = (int)firmwareFile.fileSize();
        int memaddr = startMemAddr = this.allocateMemory(sizeToFlash);
        currentProgress = 0;
        lastProgress = 0;
        if (this.progress == null) {
            this.mout.print("Uploading ");
        }
        while (upgradedBytes < sizeToFlash) {
            int sizeToRead = upgradedBytes + chunkSize > sizeToFlash ? sizeToFlash - upgradedBytes : chunkSize;
            byte[] buffer = new byte[sizeToRead];
            raf.seek(upgradedBytes);
            raf.read(buffer);
            int writeMemoryRetryCount = 0;
            boolean isWriteMemoryDone = false;
            do {
                try {
                    this.writeMemory(memaddr, (byte)8, buffer);
                    isWriteMemoryDone = true;
                }
                catch (IPMIException ex) {
                    chunkSize = 128;
                    this.mout.println("writeMemory got error #" + ++writeMemoryRetryCount + ",reduce chunkSize =" + chunkSize);
                    if (writeMemoryRetryCount <= 3) continue;
                    throw ex;
                }
            } while (!isWriteMemoryDone);
            memaddr += sizeToRead;
            int p = (int)((long)(upgradedBytes += sizeToRead) * 100L / firmwareFile.fileSize());
            if (this.progress != null) {
                this.progress.setValue(p);
                this.progress.message("Uploading " + p + "%" + " ( " + this.separatedNumber(upgradedBytes) + " bytes / " + this.separatedNumber(firmwareFile.fileSize()) + " bytes )");
                continue;
            }
            currentProgress = p;
            if (currentProgress <= lastProgress) continue;
            for (int i = 0; i < currentProgress - lastProgress; ++i) {
                if ((i + lastProgress) % 2 != 0) continue;
                this.mout.print(".");
            }
            lastProgress = currentProgress;
        }
        this.sendMessage("100% ");
        currentProgress = 0;
        lastProgress = 0;
        if (this.progress == null) {
            this.mout.print("Upgrading ");
        }
        if ((sizeCopied = this.eraseCopyFlash(startMemAddr, 0, sizeToFlash)) != sizeToFlash) {
            throw new IPMIException("Error in EraaseAndFlash");
        }
        int getECFStatusExceptionCount = 0;
        boolean isECFStatusPassed = false;
        do {
            ECFStatus ecfStatus;
            try {
                ecfStatus = this.getECFStatus();
            }
            catch (Exception e) {
                if (++getECFStatusExceptionCount != 10) continue;
                throw new IPMIException("ECFStatusException error (retry Count = 10)");
            }
            if (ecfStatus.progress[0] == 100) {
                isECFStatusPassed = true;
            } else {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.progress != null) {
                byte p = ecfStatus.progress[0];
                this.progress.setValue(p);
                this.progress.message("Upgrading " + p + "%");
                continue;
            }
            currentProgress = ecfStatus.progress[0];
            if (currentProgress <= lastProgress) continue;
            for (int i = 0; i < currentProgress - lastProgress; ++i) {
                if ((i + lastProgress) % 2 != 0) continue;
                this.mout.print(".");
            }
            lastProgress = currentProgress;
        } while (!isECFStatusPassed);
        this.sendMessage("100% ");
        currentProgress = 0;
        lastProgress = 0;
        if (this.progress == null) {
            this.mout.print("Verifying ");
        }
        this.verifyFlash(startMemAddr, 0, sizeToFlash);
        boolean isVerifyStatusPassed = false;
        do {
            VerifyStatus verifyStatus = this.getVerifyStatus();
            if (verifyStatus.progress[0] == 100) {
                isVerifyStatusPassed = true;
            } else {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            if (this.progress != null) {
                byte p = verifyStatus.progress[0];
                this.progress.setValue(p);
                this.progress.message("Verifying " + p + "%");
                continue;
            }
            currentProgress = verifyStatus.progress[0];
            if (currentProgress <= lastProgress) continue;
            for (int i = 0; i < currentProgress - lastProgress; ++i) {
                if ((i + lastProgress) % 2 != 0) continue;
                this.mout.print(".");
            }
            lastProgress = currentProgress;
        } while (!isVerifyStatusPassed);
        this.sendMessage("100% ");
        byte freeStatus = this.freeMemory(startMemAddr);
        if (freeStatus != 0) {
            throw new IPMIException("Error in freeMemory");
        }
        raf.close();
    }

    private String separatedNumber(long value) {
        DecimalFormatSymbols commaSyz = new DecimalFormatSymbols();
        commaSyz.setGroupingSeparator(',');
        String putCommas = "###,###,###,###";
        DecimalFormat largeNumberFormat = new DecimalFormat(putCommas, commaSyz);
        largeNumberFormat.setGroupingSize(3);
        String sepratedNumber = largeNumberFormat.format(value);
        return sepratedNumber;
    }

    public boolean flashFlow(String filename, boolean isUpgradeBoot, boolean isUpgradeConfig, boolean isBackupBootVariable) throws Exception {
        SortedMap<String, byte[]> bootConfig = null;
        FirmwareFile firmwareFile = null;
        this.sendMessage("Reading Firmware file ...");
        firmwareFile = this.preLoadFirmwareFile != null ? this.preLoadFirmwareFile : new FirmwareFile(filename);
        this.sendMessage("Getting Boot FMHInfo ...");
        FMHInfo bootFMHInfo = firmwareFile.getBootFMH();
        if (bootFMHInfo == null) {
            throw new Exception("File format error");
        }
        this.sendMessage("Getting Config FMHInfo ...");
        FMHInfo configFHMInfo = firmwareFile.getConfigFMH();
        if (bootFMHInfo == null) {
            throw new Exception("File format error");
        }
        this.sendMessage("Enter to Flash Mode");
        byte delay = this.activateFlashMode();
        try {
            Thread.sleep(delay * 500);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (isBackupBootVariable) {
            this.sendMessage("Backup boot config");
            bootConfig = this.backupBootConfig();
        }
        this.flashWorker(firmwareFile, isUpgradeBoot, isUpgradeConfig);
        if (isBackupBootVariable) {
            this.sendMessage("Restore boot config");
            this.restoreBootConfig(bootConfig);
        }
        this.sendMessage("Deactivate flash Mode");
        this.deactivateFlash();
        this.sendMessage("Resetting the firmware After 5 second");
        this.dropResetDevice(5);
        this.sendMessage("Finished. (BMC takes 1 minute to restart)");
        return true;
    }

    public String checkFirmwareVersion(String filename) throws Exception {
        FirmwareFile firmwareFile = null;
        File f = new File(filename);
        if (!f.isFile()) {
            throw new IPMIException("File is not found");
        }
        firmwareFile = new FirmwareFile(filename);
        FMHInfo rainerFMHInfo = firmwareFile.getRainerFMH();
        if (rainerFMHInfo == null) {
            throw new IPMIException("File format error");
        }
        String ver = firmwareFile.getFirmwareVersionString();
        if (ver == null) {
            ver = "" + rainerFMHInfo.moduleVersion[0] + "." + ByteUtility.bcdToInt(rainerFMHInfo.moduleVersion[1]);
        }
        return ver;
    }

    public boolean flashFlow90(String filename, boolean isBackupBootVariable) throws Exception {
        SortedMap<String, byte[]> bootConfig = null;
        FirmwareFile firmwareFile = null;
        firmwareFile = this.preLoadFirmwareFile != null ? this.preLoadFirmwareFile : new FirmwareFile(filename);
        if (this.progress != null) {
            this.sendMessage("Check file...");
        } else {
            this.mout.print("Check firmware file...");
        }
        FMHInfo rainerFMHInfo = firmwareFile.getRainerFMH();
        if (rainerFMHInfo == null) {
            throw new IPMIException("File format error");
        }
        if (this.progress == null) {
            String ver = firmwareFile.getFirmwareVersionString();
            if (ver == null) {
                ver = "" + rainerFMHInfo.moduleVersion[0] + "." + rainerFMHInfo.moduleVersion[1];
            }
            this.mout.println(" Done (ver:" + ver + ")");
        }
        if (this.progress != null) {
            this.sendMessage("Check BMC status...");
        } else {
            this.mout.print("Check BMC status...");
        }
        FlashInfo flashDetails = this.getFlashInfo();
        FirmwareInfo firmwareInfo = this.getFirmwareInfo();
        FMHInfo[] fmhInfos = this.getFMHInfo();
        boolean rainerFlag = false;
        for (int i = 0; i < fmhInfos.length; ++i) {
            if (!"rainier".equals(new String(fmhInfos[i].moduleName).trim())) continue;
            rainerFlag = true;
        }
        if (!rainerFlag) {
            throw new IPMIException("Firmware type mismatch");
        }
        if (this.progress == null) {
            this.mout.println(" Done (ver:" + firmwareInfo.getVersionString() + ")");
        }
        this.sendMessage("Enter to Flash Mode");
        byte delay = this.activateFlashMode();
        try {
            Thread.sleep(delay * 5000);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (isBackupBootVariable) {
            bootConfig = this.backupBootConfig();
        }
        this.flashWorker90(firmwareFile);
        if (isBackupBootVariable) {
            this.restoreBootConfig(bootConfig);
        }
        this.deactivateFlash();
        this.sendMessage("Resetting BMC");
        this.dropResetDevice(5);
        this.sendMessage("Done. (BMC needs 1 minute to restart)");
        if (this.progress == null) {
            this.mout.println("Please reset system for board configuration");
        }
        return true;
    }

    public boolean flashFlow_ATEN2AMI(String filename) throws Exception {
        Object bootConfig = null;
        FirmwareFile firmwareFile = null;
        this.sendMessage("Reading Firmware file ...");
        firmwareFile = this.preLoadFirmwareFile != null ? this.preLoadFirmwareFile : new FirmwareFile(filename);
        this.sendMessage("Enter to Flash Mode");
        byte delay = this.activateFlashMode();
        try {
            Thread.sleep(delay * 500);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.flashWorker_ATEN2AMI(firmwareFile);
        this.sendMessage("Deactivate flash Mode");
        this.deactivateFlash();
        this.sendMessage("Resetting the firmware After 5 second");
        this.dropResetDevice(5);
        this.sendMessage("Finished. (BMC needs 1 minute to restart)");
        return true;
    }

    public void flash(String filename, boolean isUpgradeBoot, boolean isUpgradeConfig, boolean isBackupBootVariable, String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return;
        }
        try {
            ipmiAMIYAFUCommand.flashFlow(filename, isUpgradeBoot, isUpgradeConfig, isBackupBootVariable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean flash90(String filename, boolean isBackupBootVariable, String ip, String username, String password) throws Exception {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp(ip);
        config.setUserName(username);
        config.setPassword(password);
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        config.setRetry(10);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            ipmiAMIYAFUCommand.flashFlow90(filename, isBackupBootVariable);
            this.printTimeString("Total Elapse Time", System.currentTimeMillis() - start);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void backupFirmware(String filename) throws Exception {
        this.mout.println("Enter to Flash Mode");
        this.sendMessage("Enter to Flash Mode");
        byte delay = this.activateFlashMode();
        try {
            Thread.sleep(delay * 1000);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.mout.println("Getting Current fimrware structure ...");
        FlashInfo flashInfo = this.getFlashInfo();
        this.mout.println("flashInfo =" + flashInfo.toString());
        this.mout.println("finished");
        int backupedBytes = ByteUtility.fourBytesToIntByLSBFirst(flashInfo.flashAddress);
        int sizeToRead = 768;
        int flashsize = ByteUtility.fourBytesToIntByLSBFirst(flashInfo.flashSize);
        for (int i = backupedBytes = 0; i < backupedBytes + flashsize; i += sizeToRead) {
            this.mout.println("start to read flash");
            byte[] raw = this.readFlash(i, (byte)8, sizeToRead);
            this.mout.println("raw = " + raw);
        }
    }

    public FirmwareFile createFirmwareFile(String filename) {
        FirmwareFile f = new FirmwareFile(filename);
        return f;
    }

    private void sendMessage(String message) {
        if (this.progress != null) {
            this.progress.message(message);
        } else {
            this.mout.println(message);
        }
    }

    public void printTimeString(String label, long diffMillis) {
        if (diffMillis == 0L) {
            return;
        }
        long diffDays = diffMillis / 86400000L;
        long leftHours = diffMillis % 86400000L / 3600000L;
        long leftMins = diffMillis % 86400000L % 3600000L / 60000L;
        long leftSecs = diffMillis % 86400000L % 3600000L % 60000L / 1000L;
        this.mout.println(label + ": " + leftMins + " min " + leftSecs + " sec(s)");
    }

    private void MAIN____________() {
    }

    public static void main(String[] args) {
        IPMIAMIYAFUCommand.main_checkFirmware(args);
    }

    public static void main_checkFirmware(String[] args) {
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        FirmwareFile f = ipmiAMIYAFUCommand.getFirmwareFile("c:\\17.ima");
        try {
            FMHInfo fmh = f.getRainerFMH();
            System.out.println(fmh.toString());
            System.out.println("ver = " + f.firmwareVersionString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main_(String[] args) {
        byte[] longbb = new byte[]{0, 0, 0, 0, 8, 0, 0, 0, 0};
        CRC32 crc32 = new CRC32();
        crc32.reset();
        crc32.update(new byte[]{0, 0, 0, 0});
        crc32.update(8);
        crc32.update(new byte[]{0, 0, 0, 0});
        long crcValue = crc32.getValue();
        byte[] bytes = new byte[4];
        ByteUtility.longTo4Bytes(bytes, 0, crcValue);
    }

    public static void main_test(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.80");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiAMIYAFUCommand.setIPMIInterface(rmcp);
        try {
            System.out.println("getFlashInfo()");
            FlashInfo flashDetails = ipmiAMIYAFUCommand.getFlashInfo();
            System.out.println(flashDetails.toString());
            System.out.println("getFirmwareInfo()");
            FirmwareInfo firmwareInfo = ipmiAMIYAFUCommand.getFirmwareInfo();
            System.out.println(firmwareInfo.toString());
            System.out.println("getFMHInfo()");
            FMHInfo[] fmhInfos = ipmiAMIYAFUCommand.getFMHInfo();
            for (int i = 0; i < fmhInfos.length; ++i) {
                System.out.println("i = " + i);
                System.out.println(fmhInfos[i].toString());
            }
            System.out.println("activeFlashMode()");
            byte delay = ipmiAMIYAFUCommand.activateFlashMode();
            System.out.println("activate delay = " + delay);
            try {
                Thread.sleep(delay * 1000);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            System.out.println("allocatememory()");
            int address = ipmiAMIYAFUCommand.allocateMemory(0x2000000);
            System.out.println("alloc addr = " + address);
            System.out.println("backupBootConfig()");
            SortedMap<String, byte[]> bootConfig = ipmiAMIYAFUCommand.backupBootConfig();
            System.out.println("Start restore boot config, Time:" + LogUtil.getSystemDateTime());
            for (String item : bootConfig.keySet()) {
                byte[] bytes = (byte[])bootConfig.get(item);
                System.out.println(item.toString() + " = " + new String(bytes) + " ,  " + ByteUtility.bytesToHex(bytes));
            }
            System.out.println("restoreBootConfig()");
            ipmiAMIYAFUCommand.restoreBootConfig(bootConfig);
            System.out.println("Finish restore boot config, Time:" + LogUtil.getSystemDateTime());
            System.out.println("deactivateFlash");
            ipmiAMIYAFUCommand.deactivateFlash();
            System.out.println("reset");
            ipmiAMIYAFUCommand.dropResetDevice(1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
        System.out.println("end of test");
    }

    public static void main_test_firmwareInfo(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.147");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        ISessionController sessionController = IPMIVersion.getSessionController(config);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        IPMINetworkInterface rmcp = sessionController.startup(config);
        if (rmcp == null) {
            MessageCenter.getInstance().put("Network error");
            return;
        }
        MessageCenter.getInstance().put("RMCP Login successfully");
        ipmiAMIYAFUCommand.setIPMIInterface(rmcp);
        try {
            System.out.println("getFlashInfo()");
            FlashInfo flashDetails = ipmiAMIYAFUCommand.getFlashInfo();
            System.out.println(flashDetails.toString());
            System.out.println("getFirmwareInfo()");
            FirmwareInfo firmwareInfo = ipmiAMIYAFUCommand.getFirmwareInfo();
            System.out.println(firmwareInfo.toString());
            System.out.println("getFMHInfo()");
            FMHInfo[] fmhInfos = ipmiAMIYAFUCommand.getFMHInfo();
            for (int i = 0; i < fmhInfos.length; ++i) {
                System.out.println("i = " + i);
                System.out.println(fmhInfos[i].toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        sessionController.closeSession();
        System.out.println("end of test");
    }

    public static void main_flashATEN2AMI(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.157");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return;
        }
        try {
            System.out.println("Start Time = " + LogUtil.getSystemDateTime());
            ipmiAMIYAFUCommand.flashFlow_ATEN2AMI("c:\\Aten_129_12312009.bin");
            System.out.println("End Time =" + LogUtil.getSystemDateTime());
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ex) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main_flashTest(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.12.163");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return;
        }
        try {
            System.out.println("Start Time = " + LogUtil.getSystemDateTime());
            ipmiAMIYAFUCommand.flashFlow("d:\\fw\\ami\\X7DCT-L_091.ima", false, false, false);
            System.out.println("End Time =" + LogUtil.getSystemDateTime());
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ex) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main_flashTest90Facade(String[] args) {
        MessageCenter.getInstance().deleteObservers();
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        try {
            ipmiAMIYAFUCommand.flash90("c:\\15.ima", true, "192.168.23.80", "ADMIN", "ADMIN");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main_flashTest90(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.80");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return;
        }
        try {
            System.out.println("Start Time = " + LogUtil.getSystemDateTime());
            ipmiAMIYAFUCommand.flashFlow90("c:\\17.ima", true);
            System.out.println("End Time =" + LogUtil.getSystemDateTime());
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ex) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main_backupFirmware(String[] args) {
        IPMIInterfaceConfig config = new IPMIInterfaceConfig();
        config.setIp("192.168.23.80");
        config.setUserName("ADMIN");
        config.setPassword("ADMIN");
        config.setPrivilege((byte)4);
        config.setTimeout(15);
        IPMIAMIYAFUCommand ipmiAMIYAFUCommand = new IPMIAMIYAFUCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(config, ipmiAMIYAFUCommand);
        if (sessionController == null) {
            return;
        }
        try {
            System.out.println("Start Time = " + LogUtil.getSystemDateTime());
            ipmiAMIYAFUCommand.backupFirmware(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main________(String[] args) {
        DecimalFormatSymbols commaSyz = new DecimalFormatSymbols();
        commaSyz.setGroupingSeparator(',');
        String putCommas = "###,###,###,###";
        DecimalFormat largeNumberFormat = new DecimalFormat(putCommas, commaSyz);
        largeNumberFormat.setGroupingSize(3);
        long l = 12323421L;
        String sepratedNumber = largeNumberFormat.format(l);
        System.out.println(sepratedNumber);
    }

    public static interface Progress {
        public void setValue(int var1);

        public void message(String var1);

        public void left(long var1);
    }

    public class FirmwareFile {
        String filename;
        File firmware;
        ArrayList<FMHInfo> fmhInfos;
        String firmwareVersionString;

        public FirmwareFile(String filename) {
            this.filename = filename;
            this.firmware = new File(this.filename);
        }

        public FirmwareFile() {
        }

        public long fileSize() {
            return this.firmware.length();
        }

        public String getFirmwareVersionString() {
            return this.firmwareVersionString;
        }

        public ArrayList<FMHInfo> getFMHInfos_old() throws Exception {
            ArrayList<FMHInfo> fmhInfoList = new ArrayList<FMHInfo>();
            String fmhSignature = "$MODULE$";
            int fmhStructureSize = 64;
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            int i = 0;
            while ((long)i < this.firmware.length()) {
                byte[] chunk = new byte[64];
                raf.seek(i);
                int count = raf.read(chunk);
                if (count != 64) {
                    throw new Exception("File read error");
                }
                byte[] tempSignatureBytes = new byte[8];
                System.arraycopy(chunk, 0, tempSignatureBytes, 0, tempSignatureBytes.length);
                if (fmhSignature.equals(new String(tempSignatureBytes))) {
                    FMHInfo fmhInfo = new FMHInfo();
                    fmhInfo.fromRaw(chunk);
                    fmhInfoList.add(fmhInfo);
                }
                i += fmhStructureSize;
            }
            this.fmhInfos = fmhInfoList;
            raf.close();
            return fmhInfoList;
        }

        public FMHInfo getBootFMH() throws Exception {
            if (this.fmhInfos == null) {
                this.getFMHInfos();
            }
            for (int i = 0; i < this.fmhInfos.size(); ++i) {
                if (!"boot".equals(new String(this.fmhInfos.get((int)i).moduleName).trim())) continue;
                return this.fmhInfos.get(i);
            }
            return null;
        }

        public FMHInfo getConfigFMH() throws Exception {
            if (this.fmhInfos == null) {
                this.getFMHInfos();
            }
            for (int i = 0; i < this.fmhInfos.size(); ++i) {
                if (!"params".equals(new String(this.fmhInfos.get((int)i).moduleName).trim())) continue;
                return this.fmhInfos.get(i);
            }
            return null;
        }

        public FMHInfo getHermonFMH() throws Exception {
            if (this.fmhInfos == null) {
                this.getFMHInfos();
            }
            for (int i = 0; i < this.fmhInfos.size(); ++i) {
                if (!"hermon".equals(new String(this.fmhInfos.get((int)i).moduleName).trim())) continue;
                return this.fmhInfos.get(i);
            }
            return null;
        }

        public FMHInfo getRainerFMH() throws Exception {
            if (this.fmhInfos == null) {
                this.getFMHInfos();
            }
            for (int i = 0; i < this.fmhInfos.size(); ++i) {
                if (!"rainier".equals(new String(this.fmhInfos.get((int)i).moduleName).trim())) continue;
                return this.fmhInfos.get(i);
            }
            return null;
        }

        public ArrayList<FMHInfo> getFMHInfos() throws Exception {
            ArrayList<FMHInfo> fmhInfoList = new ArrayList<FMHInfo>();
            RandomAccessFile raf = new RandomAccessFile(this.firmware, "r");
            String fmhSignature = "$MODULE$";
            String firmwareVersionSignature = "FW_VERSION=";
            int fmhStructureSize = 64;
            int chunkSize = 8192;
            int i = 0;
            while ((long)i < this.firmware.length()) {
                int fwVerIndex;
                byte[] chunk = new byte[chunkSize];
                raf.seek(i);
                int count = raf.read(chunk);
                if (count != chunkSize) {
                    throw new Exception("File read error");
                }
                String chunkString = new String(chunk, "8859_1");
                int index = chunkString.indexOf(fmhSignature);
                if (index != -1) {
                    byte[] fmhBytes = new byte[fmhStructureSize];
                    System.arraycopy(chunk, index, fmhBytes, 0, fmhBytes.length);
                    FMHInfo fmhInfo = new FMHInfo();
                    fmhInfo.fromRaw(fmhBytes);
                    fmhInfoList.add(fmhInfo);
                }
                if ((fwVerIndex = chunkString.indexOf(firmwareVersionSignature)) != -1) {
                    byte[] fwVerBytes = new byte[7];
                    System.arraycopy(chunk, fwVerIndex + firmwareVersionSignature.length(), fwVerBytes, 0, fwVerBytes.length);
                    this.firmwareVersionString = new String(fwVerBytes);
                }
                i += chunkSize;
            }
            this.fmhInfos = fmhInfoList;
            raf.close();
            return fmhInfoList;
        }
    }

    public class YafuStatus {
        Hashtable ht = new Hashtable();

        public YafuStatus() {
            this.ht.put("00", "YAFU_CC_NORMAL");
            this.ht.put("CC", "YAFU_CC_INVALID_DATLEN");
            this.ht.put("02", "YAFU_CC_ALLOC_ERR");
            this.ht.put("03", "YAFU_CC_DEV_OPEN_ERR");
            this.ht.put("04", "YAFU_CC_SEEK_ERR");
            this.ht.put("05", "YAFU_CC_READ_ERR");
            this.ht.put("06", "YAFU_CC_WRITE_ERR");
            this.ht.put("07", "YAFU_CC_MEM_ERASE_ERR");
            this.ht.put("08", "YAFU_CC_IN_DEACTIVATE");
            this.ht.put("09", "YAFU_OFFSET_NOT_IN_REASE_BOUNDARY");
            this.ht.put("10", "YAFU_SIZE_NOT_IN_REASE_BOUNDARY");
            this.ht.put("11", "YAFU_FLASH_ERASE_FAILURE");
            this.ht.put("12", "YAFU_INVALID_CHECKSUM");
        }

        public String getErrorMessage(byte code) {
            String codeStr = ByteUtility.byteToHex(code);
            String errorMessage = (String)this.ht.get(codeStr);
            if (errorMessage == null) {
                return "Udefined";
            }
            return errorMessage;
        }

        public byte isFail(byte[] yafuHeaderRaw) {
            if (yafuHeaderRaw[3] != -1) {
                return 0;
            }
            return yafuHeaderRaw[11];
        }
    }

    public class FMHInfo {
        public byte[] fmhSignature = new byte[8];
        public byte[] fmhVersion = new byte[2];
        public byte[] fmhSize = new byte[2];
        public byte[] allocatedSize = new byte[4];
        public byte[] fmhLocation = new byte[4];
        public byte[] fmhReserved = new byte[3];
        public byte headerChecksum;
        public byte[] moduleName = new byte[8];
        public byte[] moduleVersion = new byte[2];
        public byte[] moduleType = new byte[2];
        public byte[] moduleLocation = new byte[4];
        public byte[] moduleSize = new byte[4];
        public byte[] moduelFlags = new byte[2];
        public byte[] moduleLoadAddress = new byte[4];
        public byte[] moduleChecksum = new byte[4];
        public byte[] moduleReserved = new byte[8];
        public byte[] endSignature = new byte[2];
        public byte[] raw;
        private Hashtable ht;

        public FMHInfo() {
            if (this.ht == null) {
                this.ht = new Hashtable();
                this.ht.put("00", "Unknown");
                this.ht.put("01", "Boot Loader");
                this.ht.put("02", "Firmware");
                this.ht.put("03", "OS Kernel");
                this.ht.put("04", "FPGA Microcode");
                this.ht.put("05", "ELF Executable");
                this.ht.put("06", "Linux Image (UImage)");
                this.ht.put("07", "Cramfs Initrd");
                this.ht.put("08", "Linux Kernel");
                this.ht.put("09", "Linux Root FileSystem");
                this.ht.put("10", "JFFS File System");
                this.ht.put("11", "JFFS2 File System");
                this.ht.put("20", "Configuration (JFFS)");
                this.ht.put("21", "Configuration(JFFS2)");
                this.ht.put("30", "Configuration (>= 1.4)");
                this.ht.put("40", "Web Pages");
                this.ht.put("50", "PDK");
            }
        }

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.fmhSignature, 0, this.fmhSignature.length);
            System.arraycopy(raw, index += this.fmhSignature.length, this.fmhVersion, 0, this.fmhVersion.length);
            System.arraycopy(raw, index += this.fmhVersion.length, this.fmhSize, 0, this.fmhSize.length);
            System.arraycopy(raw, index += this.fmhSize.length, this.allocatedSize, 0, this.allocatedSize.length);
            System.arraycopy(raw, index += this.allocatedSize.length, this.fmhLocation, 0, this.fmhLocation.length);
            System.arraycopy(raw, index += this.fmhLocation.length, this.fmhReserved, 0, this.fmhReserved.length);
            this.headerChecksum = raw[index += this.fmhReserved.length];
            System.arraycopy(raw, ++index, this.moduleName, 0, this.moduleName.length);
            System.arraycopy(raw, index += this.moduleName.length, this.moduleVersion, 0, this.moduleVersion.length);
            System.arraycopy(raw, index += this.moduleVersion.length, this.moduleType, 0, this.moduleType.length);
            System.arraycopy(raw, index += this.moduleType.length, this.moduleLocation, 0, this.moduleLocation.length);
            System.arraycopy(raw, index += this.moduleLocation.length, this.moduleSize, 0, this.moduleSize.length);
            System.arraycopy(raw, index += this.moduleSize.length, this.moduelFlags, 0, this.moduelFlags.length);
            System.arraycopy(raw, index += this.moduelFlags.length, this.moduleLoadAddress, 0, this.moduleLoadAddress.length);
            System.arraycopy(raw, index += this.moduleLoadAddress.length, this.moduleChecksum, 0, this.moduleChecksum.length);
            System.arraycopy(raw, index += this.moduleChecksum.length, this.moduleReserved, 0, this.moduleReserved.length);
            System.arraycopy(raw, index += this.moduleReserved.length, this.endSignature, 0, this.endSignature.length);
            index += this.endSignature.length;
            this.raw = raw;
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "fmhSignature = " + ByteUtility.bytesToHex(this.fmhSignature) + "(" + new String(this.fmhSignature) + "}" + "\n";
            retStr = retStr + "fmhVersion = " + ByteUtility.bytesToHex(this.fmhVersion) + "\n";
            retStr = retStr + "fmhSize = " + ByteUtility.bytesToHex(this.fmhSize) + "(" + ByteUtility.twoBytesToIntLSB(this.fmhSize) + ")" + "\n";
            retStr = retStr + "allocatedSize = " + ByteUtility.bytesToHex(this.allocatedSize) + "(" + ByteUtility.fourBytesToIntByLSBFirst(this.allocatedSize) + ")" + "\n";
            retStr = retStr + "fmhLocation = " + ByteUtility.bytesToHex(this.fmhLocation) + "(" + ByteUtility.fourBytesToIntByLSBFirst(this.fmhLocation) + ")" + "\n";
            retStr = retStr + "fmhReserved = " + ByteUtility.bytesToHex(this.fmhReserved) + "\n";
            retStr = retStr + "headerChecksum = " + ByteUtility.byteToHex(this.headerChecksum) + "\n";
            retStr = retStr + "moduleName = " + ByteUtility.bytesToHex(this.moduleName) + "(" + new String(this.moduleName) + ")" + "\n";
            retStr = retStr + "moduleVersion = " + ByteUtility.bytesToHex(this.moduleVersion) + "\n";
            retStr = retStr + "moduleType = " + ByteUtility.bytesToHex(this.moduleType) + "(" + this.ht.get(ByteUtility.byteToHex(this.moduleType[0])) + ")" + "\n";
            retStr = retStr + "moduleLocation = " + ByteUtility.bytesToHex(this.moduleLocation) + "\n";
            retStr = retStr + "moduleSize = " + ByteUtility.bytesToHex(this.moduleSize) + "(" + ByteUtility.fourBytesToIntByLSBFirst(this.moduleSize) + ")" + "\n";
            retStr = retStr + "moduelFlags = " + ByteUtility.bytesToHex(this.moduelFlags) + "\n";
            retStr = retStr + "moduleLoadAddress = " + ByteUtility.bytesToHex(this.moduleLoadAddress) + "\n";
            retStr = retStr + "moduleChecksum = " + ByteUtility.bytesToHex(this.moduleChecksum) + "\n";
            retStr = retStr + "moduleReserved = " + ByteUtility.bytesToHex(this.moduleReserved) + "\n";
            retStr = retStr + "endSignature = " + ByteUtility.bytesToHex(this.endSignature) + "\n";
            return retStr;
        }
    }

    public class YafuHeader {
        public byte[] seqnum;
        public byte[] yafuCmd;
        public byte[] datalen;
        public byte[] crc32CheckSum;
        public byte[] raw;
        CRC32 crc32 = new CRC32();

        public YafuHeader() {
            this.seqnum = new byte[]{0, 0, 0, 2};
            this.yafuCmd = new byte[2];
            this.datalen = new byte[2];
            this.crc32CheckSum = new byte[4];
            this.raw = new byte[this.seqnum.length + this.yafuCmd.length + this.datalen.length + this.crc32CheckSum.length];
        }

        public String toString() {
            String retStr = "";
            retStr = retStr + "seqnum = " + ByteUtility.bytesToHex(this.seqnum) + "\n";
            retStr = retStr + "yafuCmd = " + ByteUtility.bytesToHex(this.yafuCmd) + "\n";
            retStr = retStr + "datalen = " + ByteUtility.bytesToHex(this.datalen) + "\n";
            retStr = retStr + "crc32CheckSum = " + ByteUtility.bytesToHex(this.crc32CheckSum) + "\n";
            retStr = retStr + "raw = " + ByteUtility.bytesToHex(this.raw) + "\n";
            return retStr;
        }

        public void fromRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.seqnum, 0, this.seqnum.length);
            System.arraycopy(raw, index += this.seqnum.length, this.yafuCmd, 0, this.yafuCmd.length);
            System.arraycopy(raw, index += this.yafuCmd.length, this.datalen, 0, this.datalen.length);
            System.arraycopy(raw, index += this.datalen.length, this.crc32CheckSum, 0, this.crc32CheckSum.length);
        }

        public byte[] toRaw() {
            byte[] raw = new byte[this.seqnum.length + this.yafuCmd.length + this.datalen.length + this.crc32CheckSum.length];
            int index = 0;
            System.arraycopy(this.seqnum, 0, raw, index, this.seqnum.length);
            System.arraycopy(this.yafuCmd, 0, raw, index += this.seqnum.length, this.yafuCmd.length);
            System.arraycopy(this.datalen, 0, raw, index += this.yafuCmd.length, this.datalen.length);
            System.arraycopy(this.crc32CheckSum, 0, raw, index += this.datalen.length, this.crc32CheckSum.length);
            return raw;
        }

        public void calCRC32(byte[] data) {
            this.calCRC32(data, 0, data.length);
        }

        public void calCRC32(byte[] data, int offset, int len) {
            this.crc32.reset();
            this.crc32.update(data, offset, len);
            long crcValue = this.crc32.getValue();
            ByteUtility.longTo4Bytes(this.crc32CheckSum, 0, crcValue);
        }

        public void updateCRC32(byte data) {
            this.crc32.update(data);
            long crcValue = this.crc32.getValue();
            ByteUtility.longTo4Bytes(this.crc32CheckSum, 0, crcValue);
        }

        public void updateCRC32(byte[] data) {
            this.crc32.update(data);
            long crcValue = this.crc32.getValue();
            ByteUtility.longTo4Bytes(this.crc32CheckSum, 0, crcValue);
        }

        public void resetCRC32() {
            this.crc32.reset();
        }

        public int size() {
            return this.seqnum.length + this.yafuCmd.length + this.datalen.length + this.crc32CheckSum.length;
        }
    }

    public class FlashInfo {
        public byte[] flashSize = new byte[4];
        public byte[] flashAddress = new byte[4];
        public byte[] flashEraseBlkSize = new byte[4];
        public byte[] flashProductID = new byte[2];
        public byte flashWidth;
        public byte FMHCompliance;
        public byte[] reserved = new byte[2];
        public byte[] noEraseBlks = new byte[2];
        public byte[] raw = new byte[this.flashSize.length + this.flashAddress.length + this.flashEraseBlkSize.length + this.flashProductID.length + 1 + 1 + this.reserved.length + this.noEraseBlks.length];

        public String toString() {
            String retStr = "";
            retStr = retStr + "flashSize = " + ByteUtility.bytesToHex(this.flashSize) + "\n";
            retStr = retStr + "flashAddress = " + ByteUtility.bytesToHex(this.flashAddress) + "\n";
            retStr = retStr + "flashEraseBlkSize = " + ByteUtility.bytesToHex(this.flashEraseBlkSize) + "\n";
            retStr = retStr + "flashProductID = " + ByteUtility.bytesToHex(this.flashProductID) + "\n";
            retStr = retStr + "flashWidth = " + ByteUtility.byteToHex(this.flashWidth) + "\n";
            retStr = retStr + "FMHCompliance = " + ByteUtility.byteToHex(this.FMHCompliance) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "noEraseBlks = " + ByteUtility.bytesToHex(this.noEraseBlks) + "\n";
            retStr = retStr + "raw = " + ByteUtility.bytesToHex(this.raw) + "\n";
            return retStr;
        }

        public void formRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.flashSize, 0, this.flashSize.length);
            System.arraycopy(raw, index += this.flashSize.length, this.flashAddress, 0, this.flashAddress.length);
            System.arraycopy(raw, index += this.flashAddress.length, this.flashEraseBlkSize, 0, this.flashEraseBlkSize.length);
            System.arraycopy(raw, index += this.flashEraseBlkSize.length, this.flashProductID, 0, this.flashProductID.length);
            this.flashWidth = raw[index += this.flashProductID.length];
            this.FMHCompliance = raw[++index];
            System.arraycopy(raw, ++index, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.noEraseBlks, 0, this.noEraseBlks.length);
        }
    }

    public class FirmwareInfo {
        public byte firmwareMajorVersion;
        public byte firmwareMinorVersion;
        public byte[] firmwareAuxVersion = new byte[2];
        public byte[] firmwareBuildNumber = new byte[4];
        public byte[] reserved = new byte[4];
        public byte[] firmwareName = new byte[8];
        public byte[] firmwareSize = new byte[4];
        public byte[] productID = new byte[4];
        public byte[] raw = new byte[2 + this.firmwareAuxVersion.length + this.firmwareBuildNumber.length + this.reserved.length + this.firmwareName.length + this.firmwareSize.length + this.productID.length];

        public String toString() {
            String retStr = "";
            retStr = retStr + "firmwareMajorVersion = " + ByteUtility.byteToHex(this.firmwareMajorVersion) + "\n";
            retStr = retStr + "firmwareMinorVersion = " + ByteUtility.byteToHex(this.firmwareMinorVersion) + "\n";
            retStr = retStr + "firmwareAuxVersion = " + ByteUtility.bytesToHex(this.firmwareAuxVersion) + "\n";
            retStr = retStr + "firmwareBuildNumber = " + ByteUtility.bytesToHex(this.firmwareBuildNumber) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "firmwareName = " + ByteUtility.bytesToHex(this.firmwareName) + "(" + new String(this.firmwareName) + ")\n";
            retStr = retStr + "firmwareSize = " + ByteUtility.bytesToHex(this.firmwareSize) + "\n";
            retStr = retStr + "productID = " + ByteUtility.bytesToHex(this.productID) + "\n";
            retStr = retStr + "raw = " + ByteUtility.bytesToHex(this.raw) + "\n";
            return retStr;
        }

        public void formRaw(byte[] raw) {
            int index = 0;
            this.firmwareMajorVersion = raw[index];
            this.firmwareMinorVersion = raw[++index];
            System.arraycopy(raw, ++index, this.firmwareAuxVersion, 0, this.firmwareAuxVersion.length);
            System.arraycopy(raw, index += this.firmwareAuxVersion.length, this.firmwareBuildNumber, 0, this.firmwareBuildNumber.length);
            System.arraycopy(raw, index += this.firmwareBuildNumber.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.firmwareName, 0, this.firmwareName.length);
            System.arraycopy(raw, index += this.firmwareName.length, this.firmwareSize, 0, this.firmwareSize.length);
            System.arraycopy(raw, index += this.firmwareSize.length, this.productID, 0, this.productID.length);
        }

        public String getVersionString() {
            String ver = "" + this.firmwareMajorVersion + "." + this.firmwareMinorVersion + "." + this.firmwareAuxVersion[0];
            return ver;
        }
    }

    public class Status {
        public byte[] lastStatusCode = new byte[2];
        public byte[] yafuState = new byte[2];
        public byte[] mode = new byte[2];
        public byte[] reserved = new byte[2];
        public byte[] message = new byte[65];
        public byte[] raw = new byte[this.lastStatusCode.length + this.yafuState.length + this.mode.length + this.reserved.length + this.message.length];

        public String toString() {
            String retStr = "";
            retStr = retStr + "lastStatusCode = " + ByteUtility.bytesToHex(this.lastStatusCode) + "\n";
            retStr = retStr + "yafuState = " + ByteUtility.bytesToHex(this.yafuState) + "\n";
            retStr = retStr + "mode = " + ByteUtility.bytesToHex(this.mode) + "\n";
            retStr = retStr + "reserved = " + ByteUtility.bytesToHex(this.reserved) + "\n";
            retStr = retStr + "message = " + ByteUtility.bytesToHex(this.message) + "(" + new String(this.message) + ")\n";
            retStr = retStr + "raw = " + ByteUtility.bytesToHex(this.raw) + "\n";
            return retStr;
        }

        public void formRaw(byte[] raw) {
            int index = 0;
            System.arraycopy(raw, index, this.lastStatusCode, 0, this.lastStatusCode.length);
            System.arraycopy(raw, index += this.lastStatusCode.length, this.yafuState, 0, this.yafuState.length);
            System.arraycopy(raw, index += this.yafuState.length, this.mode, 0, this.mode.length);
            System.arraycopy(raw, index += this.mode.length, this.reserved, 0, this.reserved.length);
            System.arraycopy(raw, index += this.reserved.length, this.message, 0, this.message.length);
        }
    }

    public class StatusResult {
        public byte status;
        public byte[] result;
    }

    public class VerifyStatus {
        public byte[] status = new byte[4];
        public byte[] offset = new byte[4];
        public byte[] progress = new byte[2];
    }

    public class ECFStatus {
        public byte[] status = new byte[4];
        public byte[] progress = new byte[2];
    }
}

