/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMICommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIInterface;
import com.supermicro.ipmi.IPMIMessage;

public class IPMIItaniumOEMCommand
extends IPMICommand {
    public IPMIItaniumOEMCommand(IPMIInterface ipmiInterface) {
        super(ipmiInterface);
    }

    private void OEM_CMD____________() {
    }

    public IPMIMessage getCPUModuleCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setCPUModuleTurnOffLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setCPUModuleTurnOnLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readCPUROMCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{32};
        ipmiMessage.setCommandAndData((byte)-64, (byte)80, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getIOModuleCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)81, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIOModuleTurnOffLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)81, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setIOModuleTurnOnLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)81, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getPowerModuleCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerModuleTurnOffLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{16, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage setPowerModuleTurnOnLineCommand(byte index) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{17, index};
        ipmiMessage.setCommandAndData((byte)-64, (byte)82, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage getMISCCommand() {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[]{1};
        ipmiMessage.setCommandAndData((byte)-64, (byte)83, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage readI2CCommand(byte i2cBus, byte slaveAddress, byte length, byte[] dataBytes) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + dataBytes.length];
        data[0] = i2cBus;
        data[1] = slaveAddress;
        data[2] = length;
        System.arraycopy(dataBytes, 0, data, 3, dataBytes.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-15, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    public IPMIMessage writeI2CCommand(byte i2cBus, byte slaveAddress, byte length, byte[] dataBytes) {
        IPMIMessage ipmiMessage = new IPMIMessage();
        byte[] data = new byte[3 + dataBytes.length];
        data[0] = i2cBus;
        data[1] = slaveAddress;
        data[2] = length;
        System.arraycopy(dataBytes, 0, data, 3, dataBytes.length);
        ipmiMessage.setCommandAndData((byte)-64, (byte)-14, data);
        IPMIMessage resMessage = this.ipmiInterface.send(ipmiMessage);
        return resMessage;
    }

    private void API____________() {
    }

    public byte[] getCPUModule() throws Exception {
        IPMIMessage resMessage = this.getCPUModuleCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getCPUModuleCommand failed");
    }

    public void setCPUModuleTurnOffLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setCPUModuleTurnOffLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setCPUModuleTurnOffLine failed");
    }

    public void setCPUModuleTurnOnLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setCPUModuleTurnOnLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setCPUModuleTurnOnLine failed");
    }

    public byte[] readCPUROM() throws Exception {
        IPMIMessage resMessage = this.readCPUROMCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call readCPUROMCommand failed");
    }

    public byte[] getIOModule() throws Exception {
        IPMIMessage resMessage = this.getIOModuleCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getIOModuleCommand failed");
    }

    public void setIOModuleTurnOffLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setIOModuleTurnOffLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setIOModuleTurnOffLine failed");
    }

    public void setIOModuleTurnOnLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setIOModuleTurnOnLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setIOModuleTurnOnLine failed");
    }

    public byte[] getPowerModule() throws Exception {
        IPMIMessage resMessage = this.getPowerModuleCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getPowerModuleCommand failed");
    }

    public void setPowerModuleTurnOffLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setPowerModuleTurnOffLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setPowerModuleTurnOffLine failed");
    }

    public void setPowerModuleTurnOnLine(byte index) throws Exception {
        IPMIMessage resMessage = this.setPowerModuleTurnOnLineCommand(index);
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call setPowerModuleTurnOnLine failed");
    }

    public byte[] getMISC() throws Exception {
        IPMIMessage resMessage = this.getMISCCommand();
        if (resMessage != null) {
            if (resMessage.completionCode == 0) {
                return resMessage.data;
            }
            throw new Exception(GlobalDefine.getCompletionCodeString(resMessage.completionCode));
        }
        throw new IPMIException("Call getMISCCommand failed");
    }

    private void MAIN____________() {
    }
}

