/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IIPMIMessage;
import com.supermicro.ipmi.IPMIInterfaceConfig;
import com.supermicro.ipmi.IPMIMessage;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.ProxyConfig;
import com.supermicro.ipmi.RMCPHeader;
import com.supermicro.ipmi.RMCPPlusSession;
import com.supermicro.ipmi.SOLMessage;
import com.supermicro.ipmi.UDPSocket;
import com.supermicro.ipmi.algo.AES_CBC_128;
import com.supermicro.ipmi.algo.HMAC_MD5_128;
import com.supermicro.ipmi.algo.HMAC_SHA1_96;
import com.supermicro.ipmi.algo.MD5_128;
import com.supermicro.ipmi.algo.XRC4_128;
import com.supermicro.ipmi.algo.XRC4_40;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;

public class RMCPPlus
extends IPMINetworkInterface {
    IPMIInterfaceConfig config;
    RMCPPlusSession rmcpPlusSession;
    UDPSocket udpSocket;
    int retryForIncOneCount = 3;
    RMCPHeader header = new RMCPHeader();
    SessionHeader sessionHeader = new SessionHeader();
    Payload payload = new Payload();
    SessionTrailer sessionTrailer = new SessionTrailer();
    public static final byte PAYLOAD_IPMI_MESSAGE = 0;
    public static final byte PAYLOAD_SOL = 1;
    public static final byte PAYLOAD_OEM_EXPLICIT = 2;
    public static final byte PAYLOAD_OPEN_SESSION_REQUEST = 16;
    public static final byte PAYLOAD_OPEN_SESSION_RESPONSE = 17;
    public static final byte PAYLOAD_RAKP_MESSAGE_1 = 18;
    public static final byte PAYLOAD_RAKP_MESSAGE_2 = 19;
    public static final byte PAYLOAD_RAKP_MESSAGE_3 = 20;
    public static final byte PAYLOAD_RAKP_MESSAGE_4 = 21;
    public static final String[] RMCPPlusStatusCode = new String[]{"No errors (status code = 00h)", "Insufficient resources to create a session (status code = 01h)", "Invalid Session ID (status code = 02h)", "Invalid payload type (status code = 03h)", "Invalid authentication algorithm (status code = 04h)", "Invalid integrity algorithm (status code = 05h)", "No matching authentication payload (status code = 06h)", "No matching integrity payload (status code = 07h)", "Inactive Session ID (status code = 08h)", "Invalid role (status code = 09h)", "Unauthorized role or privilege level requested (status code = 0Ah)", "Insufficient resources to create a session at the requested role (status code = 0Bh)", "Invalid name length (status code = 0Ch)", "Unauthorized name (status code = 0Dh)", "Unauthorized GUID (status code = 0Eh). (GUID that BMC submitted in RAKP Message 2 was not accepted by remote console)", "Invalid integrity check value (status code = 0Fh)", "Invalid confidentiality algorithm (status code = 10h)", "No Cipher Suite match with proposed security algorithms (status code = 11h)", "Illegal or unrecognized parameter (status code = 12h)"};
    SOLMessage lastSOLMessage;

    public RMCPPlus() {
        this.rmcpPlusSession = new RMCPPlusSession();
    }

    public double getUDPSocketTimeout() {
        return this.udpSocket.getTimeout();
    }

    public void setUDPSocketTimeout(double sec) {
        this.udpSocket.setTimeout(sec);
    }

    public int getUDPSocketRetry() {
        return this.udpSocket.getRetry();
    }

    public void setUDPSocketRetry(int retry) {
        this.udpSocket.setRetry(retry);
    }

    public byte[] sendRAKPMessage(byte payloadType, byte[] payLoad) {
        this.sessionHeader.setPayLoadType(payloadType);
        byte[] data = new byte[this.header.size() + this.sessionHeader.size() + 2 + payLoad.length];
        int index = 0;
        System.arraycopy(this.header.raw(), 0, data, index, this.header.size());
        System.arraycopy(this.sessionHeader.rawData(), 0, data, index += this.header.size(), this.sessionHeader.size());
        byte[] payLoadLength = new byte[2];
        ByteUtility.intTo2Bytes(payLoadLength, 0, payLoad.length);
        System.arraycopy(payLoadLength, 0, data, index += this.sessionHeader.size(), payLoadLength.length);
        System.arraycopy(payLoad, 0, data, index += payLoadLength.length, payLoad.length);
        byte[] result = null;
        if (!this.udpSocket.sendPacket(data)) {
            return null;
        }
        result = this.udpSocket.result;
        return result;
    }

    @Override
    public void initialize(IPMIInterfaceConfig config) {
        this.config = config;
        try {
            this.udpSocket = new UDPSocket(config.getIp(), config.getPort(), config.getTimeout(), config.getRetry());
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        this.rmcpPlusSession.cipherSuite.setCipherSuiteById(config.getCipherSuiteID());
        ProxyConfig proxyConfig = config.getProxyConfig();
        if (proxyConfig != null && proxyConfig.isProxyEnabled) {
            this.udpSocket.setProxyConfig(proxyConfig);
            proxyConfig.startProxy(this.udpSocket, config);
        }
    }

    @Override
    public void stopProxy() {
        ProxyConfig proxyConfig = this.config.getProxyConfig();
        if (proxyConfig != null && proxyConfig.isProxyEnabled) {
            proxyConfig.stopProxy(this.udpSocket);
        }
    }

    @Override
    public synchronized void drop(IIPMIMessage ipmiMessage) {
        if (ipmiMessage instanceof IPMIMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)0);
        } else if (ipmiMessage instanceof SOLMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)1);
        }
        byte[] encryptPayLoad = this.encryptPayLoad(ipmiMessage);
        byte[] data = null;
        data = this.finalSignAuthCode(encryptPayLoad);
        this.rmcpPlusSession.IncreaseSessionSeq();
        this.udpSocket.dropPacket(data);
    }

    @Override
    public synchronized IPMIMessage send(IIPMIMessage ipmiMessage) {
        if (GlobalDefine.OOB_PROJECT) {
            this.setRetryForIncOneCount(9);
            if (!IPMIX9BIOSOEMCommand.retryTempFlag) {
                this.setUDPSocketTimeout(7.5);
            }
            this.setUDPSocketRetry(0);
        }
        if (GlobalDefine.isDisplayRaw()) {
            this.rawToBMC(ipmiMessage);
        }
        int retryCount = this.retryForIncOneCount;
        if (ipmiMessage instanceof IPMIMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)0);
        } else if (ipmiMessage instanceof SOLMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)1);
        }
        byte[] encryptPayLoad = this.encryptPayLoad(ipmiMessage);
        byte[] data = null;
        data = this.finalSignAuthCode(encryptPayLoad);
        byte[] result = null;
        while (true) {
            if (retryCount == 0) {
                return null;
            }
            --retryCount;
            if (this.udpSocket.sendPacket(data) && this.udpSocket.result != null) break;
            this.rmcpPlusSession.IncreaseSessionSeq();
            encryptPayLoad = this.encryptPayLoad(ipmiMessage);
            data = this.finalSignAuthCode(encryptPayLoad);
        }
        result = this.udpSocket.result;
        boolean checkAuthCode = this.checkReceiveAuthCode(result);
        byte[] decrypted = this.decryptPayLoad(result);
        byte[] payloadlength = new byte[2];
        byte[] payload = new byte[decrypted.length - 16];
        System.arraycopy(decrypted, 14, payloadlength, 0, 2);
        System.arraycopy(decrypted, 16, payload, 0, ByteUtility.twoBytesToInt(payloadlength));
        this.rmcpPlusSession.IncreaseSessionSeq();
        IPMIMessage resMessage = IPMIMessage.fromRaw(payload);
        if (GlobalDefine.isDisplayRaw()) {
            this.rawFromBMC(resMessage);
        }
        return resMessage;
    }

    public IPMIMessage sendNoSync(IIPMIMessage ipmiMessage) {
        if (GlobalDefine.OOB_PROJECT) {
            this.setRetryForIncOneCount(9);
            this.setUDPSocketTimeout(7.5);
            this.setUDPSocketRetry(0);
        }
        if (GlobalDefine.isDisplayRaw()) {
            this.rawToBMC(ipmiMessage);
        }
        int retryCount = this.retryForIncOneCount;
        if (ipmiMessage instanceof IPMIMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)0);
        } else if (ipmiMessage instanceof SOLMessage) {
            this.setIPMIMessagePayLoadTypeByCipherSuite((byte)1);
        }
        byte[] encryptPayLoad = this.encryptPayLoad(ipmiMessage);
        byte[] data = null;
        data = this.finalSignAuthCode(encryptPayLoad);
        byte[] result = null;
        while (true) {
            if (--retryCount == 0) {
                return null;
            }
            if (this.udpSocket.sendPacket(data) && this.udpSocket.result != null) break;
            this.rmcpPlusSession.IncreaseSessionSeq();
            encryptPayLoad = this.encryptPayLoad(ipmiMessage);
            data = this.finalSignAuthCode(encryptPayLoad);
        }
        result = this.udpSocket.result;
        boolean checkAuthCode = this.checkReceiveAuthCode(result);
        byte[] decrypted = this.decryptPayLoad(result);
        byte[] payloadlength = new byte[2];
        byte[] payload = new byte[decrypted.length - 16];
        System.arraycopy(decrypted, 14, payloadlength, 0, 2);
        System.arraycopy(decrypted, 16, payload, 0, ByteUtility.twoBytesToInt(payloadlength));
        this.rmcpPlusSession.IncreaseSessionSeq();
        IPMIMessage resMessage = IPMIMessage.fromRaw(payload);
        if (GlobalDefine.isDisplayRaw()) {
            this.rawFromBMC(resMessage);
        }
        return resMessage;
    }

    private void rawFromBMC(IPMIMessage resMessage) {
        String raw = "";
        String time = "";
        if (GlobalDefine.OOB_PROJECT) {
            SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date current = new Date();
            time = sdFormat.format(current) + " ";
        }
        switch (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL) {
            case 1: {
                raw = ByteUtility.bytesToHex(resMessage.humanReadRaw());
                System.out.println(time + "[ YOU <- BMC : " + raw + "]");
                break;
            }
            case 2: {
                raw = ByteUtility.bytesToHex(resMessage.raw());
                System.out.println(time + "[ YOU <- BMC : " + raw + "]");
                break;
            }
            case 3: {
                raw = resMessage.toString();
                System.out.println(raw);
            }
        }
    }

    private void rawToBMC(IIPMIMessage ipmiMessage) {
        String raw = "";
        String time = "";
        if (GlobalDefine.OOB_PROJECT) {
            SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date current = new Date();
            time = sdFormat.format(current) + " ";
        }
        switch (GlobalDefine.SMCIPMITOOL_DEBUG_LEVEL) {
            case 1: {
                raw = ByteUtility.bytesToHex(ipmiMessage.humanReadRaw());
                System.out.println(time + "[ YOU -> BMC : " + raw + "]");
                break;
            }
            case 2: {
                raw = ByteUtility.bytesToHex(ipmiMessage.raw());
                System.out.println(time + "[ YOU -> BMC : " + raw + "]");
                break;
            }
            case 3: {
                raw = ipmiMessage.toString();
                System.out.println(raw);
            }
        }
    }

    @Override
    public synchronized IPMIMessage receive() {
        int retryCount = this.retryForIncOneCount;
        if (!this.udpSocket.receivePacket()) {
            return null;
        }
        byte[] result = null;
        result = this.udpSocket.result;
        boolean checkAuthCode = this.checkReceiveAuthCode(result);
        byte[] decrypted = this.decryptPayLoad(result);
        byte[] payloadlength = new byte[2];
        byte[] payload = new byte[decrypted.length - 16];
        System.arraycopy(decrypted, 14, payloadlength, 0, 2);
        System.arraycopy(decrypted, 16, payload, 0, ByteUtility.twoBytesToInt(payloadlength));
        this.rmcpPlusSession.IncreaseSessionSeq();
        return IPMIMessage.fromRaw(payload);
    }

    private byte[] encryptPayLoad(IIPMIMessage ipmiMessage) {
        byte[] encrypted = null;
        switch (this.rmcpPlusSession.cipherSuite.getConfidentialityAlgorithm()) {
            case 0: {
                encrypted = this.encryptPayLoad_NONE(ipmiMessage);
                break;
            }
            case 1: {
                encrypted = this.encryptPayLoad_AES_CBC_128(ipmiMessage);
                break;
            }
            case 2: {
                encrypted = this.encryptPayLoad_XRC4_128(ipmiMessage);
                break;
            }
            case 3: {
                encrypted = this.encryptPayLoad_XRC4_40(ipmiMessage);
            }
        }
        return encrypted;
    }

    private byte[] encryptPayLoad_NONE(IIPMIMessage ipmiMessage) {
        boolean index = false;
        byte[] payLoad = null;
        payLoad = ipmiMessage.raw();
        return payLoad;
    }

    private byte[] encryptPayLoad_AES_CBC_128(IIPMIMessage ipmiMessage) {
        byte[] originalPayLoad = this.encryptPayLoad_NONE(ipmiMessage);
        byte[] iv = ByteUtility.random16Bytes();
        int padSize = 0;
        byte[] pad = null;
        if ((originalPayLoad.length + 1) % 16 == 0) {
            padSize = 0;
            pad = new byte[]{};
        } else {
            padSize = 16 - (originalPayLoad.length + 1) % 16;
            pad = new byte[padSize];
            for (int i = 0; i < padSize; ++i) {
                pad[i] = (byte)(i + 1);
            }
        }
        byte[] tobeEncryptedPayLoad = new byte[originalPayLoad.length + padSize + 1];
        System.arraycopy(originalPayLoad, 0, tobeEncryptedPayLoad, 0, originalPayLoad.length);
        System.arraycopy(pad, 0, tobeEncryptedPayLoad, originalPayLoad.length, pad.length);
        tobeEncryptedPayLoad[originalPayLoad.length + pad.length] = (byte)padSize;
        byte[] encryptedPayLoad = new AES_CBC_128().encrypt(iv, this.rmcpPlusSession.K2, tobeEncryptedPayLoad);
        byte[] AES_CBC_payLoad = new byte[iv.length + encryptedPayLoad.length];
        System.arraycopy(iv, 0, AES_CBC_payLoad, 0, 16);
        System.arraycopy(encryptedPayLoad, 0, AES_CBC_payLoad, 16, encryptedPayLoad.length);
        return AES_CBC_payLoad;
    }

    private byte[] encryptPayLoad_XRC4_128(IIPMIMessage ipmiMessage) {
        byte[] originalPayLoad = this.encryptPayLoad_NONE(ipmiMessage);
        byte[] encryptPayLoad = null;
        if (this.rmcpPlusSession.sessionSeq[0] == 1 && this.rmcpPlusSession.sessionSeq[1] == 0 && this.rmcpPlusSession.sessionSeq[2] == 0 && this.rmcpPlusSession.sessionSeq[3] == 0) {
            byte[] iv = ByteUtility.random16Bytes();
            this.rmcpPlusSession.ivForEncrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.rmcpPlusSession.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.rmcpPlusSession.keyRcForEncrypt = new MD5_128().code(null, temp);
            ByteUtility.intTo4Bytes(this.rmcpPlusSession.dataOffsetBytes, 0, 0);
            this.rmcpPlusSession.xrc4_128_encrypt = new XRC4_128();
            byte[] encrypt = this.rmcpPlusSession.xrc4_128_encrypt.encrypt(iv, this.rmcpPlusSession.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[20 + encrypt.length];
            System.arraycopy(this.rmcpPlusSession.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(iv, 0, encryptPayLoad, 4, 16);
            System.arraycopy(encrypt, 0, encryptPayLoad, 20, encrypt.length);
        } else {
            ByteUtility.intTo4Bytes(this.rmcpPlusSession.dataOffsetBytes, 0, this.rmcpPlusSession.dataOffsetForEncrypt);
            byte[] encrypt = this.rmcpPlusSession.xrc4_128_encrypt.encrypt(this.rmcpPlusSession.ivForEncrypt, this.rmcpPlusSession.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[4 + encrypt.length];
            System.arraycopy(this.rmcpPlusSession.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(encrypt, 0, encryptPayLoad, 4, encrypt.length);
        }
        this.rmcpPlusSession.dataOffsetForEncrypt += originalPayLoad.length;
        return encryptPayLoad;
    }

    private byte[] encryptPayLoad_XRC4_40(IIPMIMessage ipmiMessage) {
        byte[] originalPayLoad = this.encryptPayLoad_NONE(ipmiMessage);
        byte[] encryptPayLoad = null;
        if (this.rmcpPlusSession.sessionSeq[0] == 1 && this.rmcpPlusSession.sessionSeq[1] == 0 && this.rmcpPlusSession.sessionSeq[2] == 0 && this.rmcpPlusSession.sessionSeq[3] == 0) {
            byte[] iv = ByteUtility.random16Bytes();
            this.rmcpPlusSession.ivForEncrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.rmcpPlusSession.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.rmcpPlusSession.keyRcForEncrypt = new MD5_128().code(null, temp);
            ByteUtility.intTo4Bytes(this.rmcpPlusSession.dataOffsetBytes, 0, 0);
            this.rmcpPlusSession.xrc4_40_encrypt = new XRC4_40();
            byte[] encrypt = this.rmcpPlusSession.xrc4_40_encrypt.encrypt(iv, this.rmcpPlusSession.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[20 + encrypt.length];
            System.arraycopy(this.rmcpPlusSession.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(iv, 0, encryptPayLoad, 4, 16);
            System.arraycopy(encrypt, 0, encryptPayLoad, 20, encrypt.length);
        } else {
            ByteUtility.intTo4Bytes(this.rmcpPlusSession.dataOffsetBytes, 0, this.rmcpPlusSession.dataOffsetForEncrypt);
            byte[] encrypt = this.rmcpPlusSession.xrc4_40_encrypt.encrypt(this.rmcpPlusSession.ivForEncrypt, this.rmcpPlusSession.keyRcForEncrypt, originalPayLoad);
            encryptPayLoad = new byte[4 + encrypt.length];
            System.arraycopy(this.rmcpPlusSession.dataOffsetBytes, 0, encryptPayLoad, 0, 4);
            System.arraycopy(encrypt, 0, encryptPayLoad, 4, encrypt.length);
        }
        this.rmcpPlusSession.dataOffsetForEncrypt += originalPayLoad.length;
        return encryptPayLoad;
    }

    private byte[] finalSignAuthCode(byte[] encryptedPayLoad) {
        byte[] data = null;
        switch (this.rmcpPlusSession.cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                data = this.finalSignAuthCode_NONE(encryptedPayLoad);
                break;
            }
            case 1: {
                data = this.finalSignAuthCode_HMAC_SHA1_96(encryptedPayLoad);
                break;
            }
            case 2: {
                data = this.finalSignAuthCode_HMAC_MD5_128(encryptedPayLoad);
                break;
            }
            case 3: {
                data = this.finalSignAuthCode_MD5_128(encryptedPayLoad);
            }
        }
        return data;
    }

    private byte[] finalSignAuthCode_NONE(byte[] encryptedPayLoad) {
        int beforeSignPacketSize = this.header.size() + this.sessionHeader.size() + 2 + encryptedPayLoad.length;
        byte[] data = new byte[beforeSignPacketSize];
        int index = 0;
        System.arraycopy(this.header.raw(), 0, data, index, this.header.size());
        index += this.header.size();
        data[index++] = this.sessionHeader.AuthType;
        data[index++] = this.sessionHeader.payLoadType;
        this.sessionHeader.SessionID = this.rmcpPlusSession.sessionID;
        this.sessionHeader.SessionSeq = this.rmcpPlusSession.sessionSeq;
        System.arraycopy(this.sessionHeader.SessionID, 0, data, index, 4);
        System.arraycopy(this.sessionHeader.SessionSeq, 0, data, index += 4, 4);
        byte[] payLoadLength = new byte[2];
        ByteUtility.intTo2Bytes(payLoadLength, 0, encryptedPayLoad.length);
        System.arraycopy(payLoadLength, 0, data, index += 4, payLoadLength.length);
        System.arraycopy(encryptedPayLoad, 0, data, index += 2, encryptedPayLoad.length);
        return data;
    }

    private byte[] finalSignAuthCode_HMAC_SHA1_96(byte[] encryptedPayLoad) {
        byte[] tempData = this.finalSignAuthCode_NONE(encryptedPayLoad);
        int padSize = 4 - (tempData.length + 2) % 4;
        byte[] data = new byte[tempData.length + padSize + 2 + 12];
        System.arraycopy(tempData, 0, data, 0, tempData.length);
        for (int i = 0; i < padSize; ++i) {
            data[tempData.length + i] = -1;
        }
        data[tempData.length + padSize] = (byte)padSize;
        data[tempData.length + padSize + 1] = 7;
        byte[] temp = new byte[tempData.length + padSize + 2];
        System.arraycopy(data, 0, temp, 0, temp.length);
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] authCode = new HMAC_SHA1_96().code(this.rmcpPlusSession.K1, temp2);
        System.arraycopy(authCode, 0, data, tempData.length + padSize + 2, authCode.length);
        return data;
    }

    private byte[] finalSignAuthCode_HMAC_MD5_128(byte[] encryptedPayLoad) {
        byte[] tempData = this.finalSignAuthCode_NONE(encryptedPayLoad);
        int padSize = 4 - (tempData.length + 2) % 4;
        byte[] data = new byte[tempData.length + padSize + 2 + 16];
        System.arraycopy(tempData, 0, data, 0, tempData.length);
        for (int i = 0; i < padSize; ++i) {
            data[tempData.length + i] = -1;
        }
        data[tempData.length + padSize] = (byte)padSize;
        data[tempData.length + padSize + 1] = 7;
        byte[] temp = new byte[tempData.length + padSize + 2];
        System.arraycopy(data, 0, temp, 0, temp.length);
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] authCode = new HMAC_MD5_128().code(this.rmcpPlusSession.K1, temp2);
        System.arraycopy(authCode, 0, data, tempData.length + padSize + 2, authCode.length);
        return data;
    }

    private byte[] finalSignAuthCode_MD5_128(byte[] encryptedPayLoad) {
        byte[] tempData = this.finalSignAuthCode_NONE(encryptedPayLoad);
        int padSize = 4 - (tempData.length + 2) % 4;
        byte[] data = new byte[tempData.length + padSize + 2 + 16];
        System.arraycopy(tempData, 0, data, 0, tempData.length);
        for (int i = 0; i < padSize; ++i) {
            data[tempData.length + i] = -1;
        }
        data[tempData.length + padSize] = (byte)padSize;
        data[tempData.length + padSize + 1] = 7;
        byte[] temp = new byte[tempData.length + padSize + 2];
        System.arraycopy(data, 0, temp, 0, temp.length);
        byte[] temp2 = new byte[temp.length - 4];
        System.arraycopy(temp, 4, temp2, 0, temp2.length);
        byte[] paddingPassword = new byte[20];
        System.arraycopy(this.config.getPassword().getBytes(), 0, paddingPassword, 0, this.config.getPassword().length());
        byte[] tempAll = new byte[temp2.length + paddingPassword.length * 2];
        System.arraycopy(paddingPassword, 0, tempAll, 0, paddingPassword.length);
        System.arraycopy(temp2, 0, tempAll, paddingPassword.length, temp2.length);
        System.arraycopy(paddingPassword, 0, tempAll, temp2.length + paddingPassword.length, paddingPassword.length);
        byte[] authCode = new MD5_128().code(this.rmcpPlusSession.K1, tempAll);
        System.arraycopy(authCode, 0, data, tempData.length + padSize + 2, authCode.length);
        return data;
    }

    private void setIPMIMessagePayLoadTypeByCipherSuite(byte payLoadType) {
        if (payLoadType == 0) {
            this.sessionHeader.payLoadType = 0;
        } else if (payLoadType == 1) {
            this.sessionHeader.payLoadType = 1;
        }
        if (this.rmcpPlusSession.cipherSuite.getConfidentialityAlgorithm() > 0) {
            this.sessionHeader.payLoadType = (byte)(this.sessionHeader.payLoadType | 0xFFFFFF80);
        }
        if (this.rmcpPlusSession.cipherSuite.getIntegrityAlgorithm() > 0) {
            this.sessionHeader.payLoadType = (byte)(this.sessionHeader.payLoadType | 0x40);
        }
    }

    public void ResolvePacket(byte[] recvBuf, int authcodeflag) {
        boolean result = this.checkReceiveAuthCode(recvBuf);
        byte[] decryptRecvBuf = this.decryptPayLoad(recvBuf);
        byte[] reverseReceBuf = this.returnToOriginalRMCP(decryptRecvBuf, authcodeflag);
    }

    private byte[] decryptPayLoad(byte[] recvBuf) {
        byte[] decrypted = null;
        switch (this.rmcpPlusSession.cipherSuite.getConfidentialityAlgorithm()) {
            case 0: {
                decrypted = this.decryptPayLoad_NONE(recvBuf);
                break;
            }
            case 1: {
                decrypted = this.decryptPayLoad_AES_CBC_128(recvBuf);
                break;
            }
            case 2: {
                decrypted = this.decryptPayLoad_XRC4_128(recvBuf);
                break;
            }
            case 3: {
                decrypted = this.decryptPayLoad_XRC4_40(recvBuf);
            }
        }
        return decrypted;
    }

    private byte[] decryptPayLoad_NONE(byte[] recvBuf) {
        byte[] decrypted = new byte[recvBuf.length];
        System.arraycopy(recvBuf, 0, decrypted, 0, recvBuf.length);
        return decrypted;
    }

    private byte[] decryptPayLoad_AES_CBC_128(byte[] recvBuf) {
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] iv = new byte[16];
        byte[] encryptPayLoad = new byte[wholePayLoad.length - 16];
        System.arraycopy(wholePayLoad, 0, iv, 0, iv.length);
        System.arraycopy(wholePayLoad, iv.length, encryptPayLoad, 0, encryptPayLoad.length);
        byte[] decryptPayLoad = new AES_CBC_128().decrypt(iv, this.rmcpPlusSession.K2, encryptPayLoad);
        byte padLength = 0;
        byte[] originalPayLoad = null;
        if (decryptPayLoad[decryptPayLoad.length - 1] >= 0 && decryptPayLoad[decryptPayLoad.length - 1] <= 15) {
            padLength = decryptPayLoad[decryptPayLoad.length - 1];
            originalPayLoad = new byte[decryptPayLoad.length - padLength - 1];
        } else {
            padLength = 0;
            originalPayLoad = new byte[decryptPayLoad.length];
        }
        System.arraycopy(decryptPayLoad, 0, originalPayLoad, 0, originalPayLoad.length);
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] decryptPayLoad_XRC4_128(byte[] recvBuf) {
        byte[] originalPayLoad = null;
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] dataOffsetBytes = new byte[4];
        System.arraycopy(wholePayLoad, 0, dataOffsetBytes, 0, 4);
        if (dataOffsetBytes[0] == 0 && dataOffsetBytes[1] == 0 && dataOffsetBytes[2] == 0 && dataOffsetBytes[3] == 0) {
            byte[] iv = new byte[16];
            System.arraycopy(wholePayLoad, 4, iv, 0, 16);
            this.rmcpPlusSession.ivForDecrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.rmcpPlusSession.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.rmcpPlusSession.keyRcForDecrypt = new MD5_128().code(null, temp);
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4 - 16];
            System.arraycopy(wholePayLoad, 20, encryptPayLoad, 0, encryptPayLoad.length);
            this.rmcpPlusSession.xrc4_128_decrypt = new XRC4_128();
            originalPayLoad = this.rmcpPlusSession.xrc4_128_decrypt.decrypt(iv, this.rmcpPlusSession.keyRcForDecrypt, encryptPayLoad);
        } else {
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4];
            System.arraycopy(wholePayLoad, 4, encryptPayLoad, 0, encryptPayLoad.length);
            originalPayLoad = this.rmcpPlusSession.xrc4_128_decrypt.decrypt(this.rmcpPlusSession.ivForDecrypt, this.rmcpPlusSession.keyRcForDecrypt, encryptPayLoad);
        }
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] decryptPayLoad_XRC4_40(byte[] recvBuf) {
        byte[] originalPayLoad = null;
        byte[] payLoadLength = new byte[2];
        System.arraycopy(recvBuf, 14, payLoadLength, 0, 2);
        byte[] wholePayLoad = new byte[ByteUtility.twoBytesToInt(payLoadLength)];
        System.arraycopy(recvBuf, 16, wholePayLoad, 0, ByteUtility.twoBytesToInt(payLoadLength));
        byte[] dataOffsetBytes = new byte[4];
        System.arraycopy(wholePayLoad, 0, dataOffsetBytes, 0, 4);
        if (dataOffsetBytes[0] == 0 && dataOffsetBytes[1] == 0 && dataOffsetBytes[2] == 0 && dataOffsetBytes[3] == 0) {
            byte[] iv = new byte[16];
            System.arraycopy(wholePayLoad, 4, iv, 0, 16);
            this.rmcpPlusSession.ivForDecrypt = iv;
            byte[] temp = new byte[32];
            System.arraycopy(this.rmcpPlusSession.K2, 0, temp, 0, 16);
            System.arraycopy(iv, 0, temp, 16, 16);
            this.rmcpPlusSession.keyRcForDecrypt = new MD5_128().code(null, temp);
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4 - 16];
            System.arraycopy(wholePayLoad, 20, encryptPayLoad, 0, encryptPayLoad.length);
            this.rmcpPlusSession.xrc4_40_decrypt = new XRC4_40();
            originalPayLoad = this.rmcpPlusSession.xrc4_40_decrypt.decrypt(iv, this.rmcpPlusSession.keyRcForDecrypt, encryptPayLoad);
        } else {
            byte[] encryptPayLoad = new byte[wholePayLoad.length - 4];
            System.arraycopy(wholePayLoad, 4, encryptPayLoad, 0, encryptPayLoad.length);
            originalPayLoad = this.rmcpPlusSession.xrc4_40_decrypt.decrypt(this.rmcpPlusSession.ivForDecrypt, this.rmcpPlusSession.keyRcForDecrypt, encryptPayLoad);
        }
        byte[] originalPacket = new byte[16 + originalPayLoad.length];
        byte[] blength = new byte[2];
        ByteUtility.intTo2Bytes(blength, 0, originalPayLoad.length);
        System.arraycopy(recvBuf, 0, originalPacket, 0, 14);
        System.arraycopy(blength, 0, originalPacket, 14, 2);
        System.arraycopy(originalPayLoad, 0, originalPacket, 16, originalPayLoad.length);
        return originalPacket;
    }

    private byte[] returnToOriginalRMCP(byte[] decryptRecvBuf, int authcodeflag) {
        byte[] dumpAuthCode = new byte[]{119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119, 119};
        byte[] original = new byte[256];
        boolean oIndex = false;
        byte version = decryptRecvBuf[0];
        byte reserved = decryptRecvBuf[1];
        byte rmcpSeq = decryptRecvBuf[2];
        byte ClassOfMessage = decryptRecvBuf[3];
        byte authType = decryptRecvBuf[4];
        byte[] sessionID = new byte[4];
        byte[] sessionSeq = new byte[4];
        byte[] payloadlength = new byte[2];
        byte[] payload = new byte[decryptRecvBuf.length - 16];
        System.arraycopy(decryptRecvBuf, 6, sessionID, 0, 4);
        System.arraycopy(decryptRecvBuf, 10, sessionSeq, 0, 4);
        System.arraycopy(decryptRecvBuf, 14, payloadlength, 0, 2);
        System.arraycopy(decryptRecvBuf, 16, payload, 0, ByteUtility.twoBytesToInt(payloadlength));
        int index = 0;
        original[index++] = version;
        original[index++] = reserved;
        original[index++] = rmcpSeq;
        original[index++] = ClassOfMessage;
        original[index++] = authType;
        System.arraycopy(sessionSeq, 0, original, index, 4);
        System.arraycopy(sessionID, 0, original, index += 4, 4);
        index += 4;
        if (authcodeflag == 1) {
            System.arraycopy(dumpAuthCode, 0, original, index, 16);
            index += 16;
        }
        original[index++] = (byte)ByteUtility.twoBytesToInt(payloadlength);
        System.arraycopy(payload, 0, original, index, payload.length);
        index += payload.length;
        original[index++] = 0;
        return original;
    }

    public boolean checkReceiveAuthCode(byte[] recvBuf) {
        boolean result = false;
        switch (this.rmcpPlusSession.cipherSuite.getIntegrityAlgorithm()) {
            case 0: {
                result = this.checkRecvAuthCode_NONE(recvBuf);
                break;
            }
            case 1: {
                result = this.checkRecvAuthCode_HMAC_SHA1_96(recvBuf);
                break;
            }
            case 2: {
                result = this.checkRecvAuthCode_HMAC_MD5_128(recvBuf);
                break;
            }
            case 3: {
                result = this.checkRecvAuthCode_MD5_128(recvBuf);
            }
        }
        return result;
    }

    public boolean checkRecvAuthCode_NONE(byte[] recvBuf) {
        return true;
    }

    public boolean checkRecvAuthCode_HMAC_SHA1_96(byte[] recvBuf) {
        return true;
    }

    public boolean checkRecvAuthCode_HMAC_MD5_128(byte[] recvBuf) {
        return true;
    }

    public boolean checkRecvAuthCode_MD5_128(byte[] recvBuf) {
        return true;
    }

    @Override
    public void startListen() {
        this.udpSocket.startListen();
        this.udpSocket.addObserver(this);
    }

    @Override
    public void stopListen() {
        this.udpSocket.stopListen();
    }

    @Override
    public void update(Observable o, Object arg) {
        byte[] result = (byte[])arg;
        boolean checkAuthCode = this.checkReceiveAuthCode(result);
        byte[] decrypted = this.decryptPayLoad(result);
        byte payLoadType = decrypted[5];
        if ((payLoadType & 0x3F) != 1) {
            return;
        }
        byte[] payloadLength = new byte[2];
        byte[] payload = new byte[decrypted.length - 16];
        System.arraycopy(decrypted, 14, payloadLength, 0, 2);
        System.arraycopy(decrypted, 16, payload, 0, ByteUtility.twoBytesToInt(payloadLength));
        SOLMessage solMessage = SOLMessage.fromRaw(payload);
        if (solMessage.getPacketSequenceNumber() == 0) {
            this.setChanged();
            this.notifyObservers(new Byte(solMessage.getPacketACKandNACKSequenceNumber()));
            return;
        }
        if (solMessage.getPacketSequenceNumber() != 0) {
            SOLMessage solReplyMessage = new SOLMessage();
            solReplyMessage.setPacketSequenceNumber((byte)0);
            solReplyMessage.setPacketACKandNACKSequenceNumber(solMessage.getPacketSequenceNumber());
            solReplyMessage.setCharacterCount((byte)solMessage.getData().length);
            solReplyMessage.setOperation((byte)0);
            this.drop(solReplyMessage);
        }
        if (this.lastSOLMessage != null && solMessage.getPacketSequenceNumber() == this.lastSOLMessage.getPacketSequenceNumber()) {
            byte[] appendedScreenData = new byte[solMessage.getData().length - this.lastSOLMessage.getData().length];
            System.arraycopy(solMessage.data, this.lastSOLMessage.data.length, appendedScreenData, 0, appendedScreenData.length);
            byte[] orgScreenData = solMessage.getData();
            solMessage.setData(appendedScreenData);
            this.setChanged();
            this.notifyObservers(solMessage.getData());
            solMessage.setData(orgScreenData);
            this.lastSOLMessage = solMessage;
            return;
        }
        this.setChanged();
        this.notifyObservers(solMessage.getData());
        this.lastSOLMessage = solMessage;
    }

    public RMCPPlusSession getRmcpPlusSession() {
        return this.rmcpPlusSession;
    }

    public void setRetryForIncOneCount(int retryForIncOneCount) {
        this.retryForIncOneCount = retryForIncOneCount;
    }

    public int getRetryForIncOneCount() {
        return this.retryForIncOneCount;
    }

    public void closeSocket() {
        this.udpSocket.closeSocket();
    }

    public class SessionTrailer {
        byte[] integrityPAD;
        byte padLength;
        byte nextHeader = (byte)7;
        byte[] authCode;

        public int size() {
            return 0;
        }
    }

    public class Payload {
        byte[] payloadLength = new byte[]{0, 0};
        byte[] confidentialityHeader;
        private IPMIMessage ipmiMessage;
        byte[] confidentialityTrailer;

        private void calPayloadLength() {
            int length = this.ipmiMessage.size();
        }
    }

    public class SessionHeader {
        byte AuthType = (byte)6;
        byte payLoadType = 0;
        byte[] SessionID = new byte[]{0, 0, 0, 0};
        byte[] SessionSeq = new byte[]{0, 0, 0, 0};
        byte[] OEM_IANA = new byte[]{0, 0, 0, 0};
        byte[] OEM_Payload_ID = new byte[]{0, 0};

        public byte size() {
            return 10;
        }

        public byte[] rawData() {
            byte[] raw = new byte[this.size()];
            raw[0] = this.AuthType;
            raw[1] = this.payLoadType;
            System.arraycopy(this.SessionID, 0, raw, 2, 4);
            System.arraycopy(this.SessionSeq, 0, raw, 6, 4);
            return raw;
        }

        public void setPayLoadType(byte payLoadType) {
            this.payLoadType = payLoadType;
        }
    }
}

