/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.IPMIUserAccount;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForCreateAccount
extends Command {
    @Override
    public Result execute(Host host) {
        IPMIUserAccount userAccount = null;
        IPMIMessagingCommand ipmiMessagingCommand = new IPMIMessagingCommand(null);
        Result result = new Result(this, host);
        if (!(this.option instanceof IPMIUserAccount)) {
            result.booleanResult = false;
            result.description = "Parameter error";
            return result;
        }
        userAccount = (IPMIUserAccount)this.option;
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiMessagingCommand.setIPMIInterface(rmcp);
        boolean r1 = ipmiMessagingCommand.setUserNameByID(userAccount.userId, userAccount.username);
        boolean r2 = ipmiMessagingCommand.setUserPasswordByID(userAccount.userId, userAccount.password);
        boolean r3 = ipmiMessagingCommand.setEnableUserByID(userAccount.userId);
        boolean r4 = ipmiMessagingCommand.setUserPrivilegeByID(userAccount.userId, userAccount.userPrivilege);
        if (r1 && r2 && r3 && r4) {
            result.booleanResult = true;
            result.description = "User account created";
        } else {
            result.booleanResult = false;
            result.description = "Create user account failed";
        }
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Create Account";
    }
}

