/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.group;

import com.supermicro.ipmi.IPMILanCommand;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIVersion;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.group.Command;
import com.supermicro.ipmi.group.Host;
import com.supermicro.ipmi.group.Result;
import com.supermicro.ipmi.lang.L;

public class CommandForGettingLANConfiguration
extends Command {
    public static String IP = "IP";
    public static String MAC = "MAC";
    public static String GATEWAY_IP = "GATEWAY_IP";
    public static String GATEWAY_MAC = "GATEWAY_MAC";
    public static String SUBNET_MASK = "SUBNET_MASK";

    @Override
    public Result execute(Host host) {
        String gatewayMAC;
        String gatewayIP;
        String subnetMask;
        String mac;
        IPMILanCommand ipmiLANCommand = new IPMILanCommand(null);
        Result result = new Result(this, host);
        ISessionController sessionController = IPMIVersion.getSessionController(host.config);
        if (sessionController == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_connect_to_the_host");
            return result;
        }
        IPMINetworkInterface rmcp = sessionController.startup(host.config);
        if (rmcp == null) {
            result.booleanResult = false;
            result.description = L.t("group.Cannot_login_to") + host.getIp();
            return result;
        }
        ipmiLANCommand.setIPMIInterface(rmcp);
        result.description = result.description + "\n";
        String ip = ipmiLANCommand.getIP();
        if (ip != null) {
            result.description = result.description + "IP          = " + ip + "\n";
            result.setSingleData(IP, ip);
        }
        if ((mac = ipmiLANCommand.getMAC()) != null) {
            result.description = result.description + "MAC         = " + mac + "\n";
            result.setSingleData(MAC, mac);
        }
        if ((subnetMask = ipmiLANCommand.getSubnetMask()) != null) {
            result.description = result.description + "Subnet Mask = " + subnetMask + "\n";
            result.setSingleData(SUBNET_MASK, subnetMask);
        }
        if ((gatewayIP = ipmiLANCommand.getGatewayIP()) != null) {
            result.description = result.description + "Getway IP   = " + gatewayIP + "\n";
            result.setSingleData(GATEWAY_IP, gatewayIP);
        }
        if ((gatewayMAC = ipmiLANCommand.getGatewayMAC()) != null) {
            result.description = result.description + "Getway MAC  = " + gatewayMAC;
            result.setSingleData(GATEWAY_MAC, gatewayMAC);
        }
        result.booleanResult = true;
        sessionController.closeSession();
        return result;
    }

    public String toString() {
        return "Get LAN Configuration";
    }
}

