/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.task;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class Sum2
implements Callable<String> {
    private static final int NO_OF_THREADS = 3;
    int maxNumber;

    public Sum2(int maxNumber) {
        this.maxNumber = maxNumber;
    }

    @Override
    public String call() {
        int sum = 0;
        for (int i = 0; i <= this.maxNumber; ++i) {
            sum += this.maxNumber;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return Thread.currentThread().getName() + " count is " + sum;
    }

    public static void main(String[] args) {
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<Future<String>> list = new ArrayList<Future<String>>(10);
        for (int i = 10000; i < 10100; ++i) {
            Sum2 sum2 = new Sum2(i);
            Future<String> submit = executor.submit(sum2);
            list.add(submit);
        }
        System.out.println("submit all finished");
        for (Future future : list) {
            try {
                System.out.println("Thread " + (String)future.get());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        executor.shutdown();
        System.out.println("Finished all threads");
    }
}

