/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.IPMIX9BIOSOEMCommand;
import com.supermicro.ipmi.text.BIOSAbstractCommand;
import com.supermicro.ipmi.text.MOut;

public class BIOSSetKeyCommand
extends BIOSAbstractCommand {
    public void usage() {
        MOut.G(this).println("Product Key format: ****-****-****-****-****-****");
        MOut.G(this).println("Example:            4F15-1F39-BEB3-0EA5-2C14-41CF");
    }

    @Override
    public boolean preValidate() {
        if (this.parameters == null) {
            MOut.G(this).println("Product key is required");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        String key = this.parameters[0];
        if (!ByteUtility.validateKeyFormat(key)) {
            MOut.G(this).println("Invalid product key format");
            MOut.G(this).println("");
            this.usage();
            return false;
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        byte[] productKey = ByteUtility.fromFormatKey(this.parameters[0]);
        this.ipmiX9BIOSOEMCommand = new IPMIX9BIOSOEMCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        try {
            boolean result = this.ipmiX9BIOSOEMCommand.biosSetProductKey(productKey);
            if (result) {
                MOut.G(this).println("Product key activated");
                this.statusCode = 0;
            } else {
                MOut.G(this).println("Invalid product key");
                this.statusCode = 149;
            }
        }
        catch (IPMIException ex) {
            ex.printStackTrace();
        }
    }
}

