/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.ShellCommand;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class ExecCommand
extends Command {
    static ShellCommand shell = null;
    String filename;
    int loop = 1;
    int delay = 0;

    @Override
    public void execute() {
        boolean result = this.preValidate();
        if (!result) {
            this.statusCode = 147;
            return;
        }
        if (shell == null) {
            shell = new ShellCommand();
            shell.newParser();
        }
        shell.setConfig(this.getConfig());
        try {
            int count = 0;
            do {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(this.filename));
                while ((line = in.readLine()) != null) {
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    String numberOfLoop = this.loop == 0 ? "" : "/" + this.loop;
                    MOut.G(this).println("exec[" + (count + 1) + numberOfLoop + "][" + this.delay + "]>" + line);
                    shell.processCommand(line);
                    this.delay();
                }
                in.close();
            } while (++count != this.loop);
        }
        catch (FileNotFoundException ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 149;
            return;
        }
        catch (IOException ex) {
            this.statusCode = 148;
            MOut.G(this).println(ex.getMessage());
            return;
        }
        this.statusCode = 0;
    }

    private void delay() {
        if (this.delay == 0) {
            return;
        }
        try {
            Thread.sleep(this.delay * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void initVariable() {
        this.loop = 1;
        this.delay = 0;
    }

    private boolean preValidate() {
        this.initVariable();
        if (this.parameters == null || this.parameters.length < 1) {
            MOut.G(this).println("Usage: exec <filename> [loop] [delay]");
            MOut.G(this).println("       loop = 0 infinite loop");
            MOut.G(this).println("       delay in second");
            return false;
        }
        if (this.parameters.length >= 1) {
            this.filename = this.parameters[0];
        }
        if (this.parameters.length >= 2) {
            try {
                this.loop = Integer.parseInt(this.parameters[1]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                return false;
            }
        }
        if (this.loop < 0) {
            MOut.G(this).println("loop cannot less then 0");
            return false;
        }
        if (this.parameters.length >= 3) {
            try {
                this.delay = Integer.parseInt(this.parameters[2]);
            }
            catch (NumberFormatException ex) {
                MOut.G(this).println(ex.getMessage());
                return false;
            }
        }
        if (this.delay < 0) {
            MOut.G(this).println("delay cannot less then 0");
            return false;
        }
        return true;
    }
}

