/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class GBIPModeCommand
extends SuperBladeCommand {
    private byte gbIndex = 0;
    private byte ipMode = 0;

    @Override
    public boolean preValidate() {
        this.gbIndex = Byte.parseByte((String)this.preParameters.get(1));
        if (this.gbIndex < 1 || this.gbIndex > 4) {
            MOut.G(this).println("Gigabit switch Index out of range");
            return false;
        }
        this.ipMode = 0;
        if (this.parameters != null) {
            this.ipMode = Byte.parseByte(this.parameters[0]);
            if (this.ipMode < 1 || this.ipMode > 2) {
                MOut.G(this).println("Parameter invalid");
                return false;
            }
        }
        return true;
    }

    @Override
    public void runCommand() throws Exception {
        block7: {
            if (!this.isMaster) {
                this.printSlaveCMMUnavailableMessage();
                this.statusCode = 150;
                return;
            }
            if (!this.isGigabitPresent(this.gbIndex)) {
                MOut.G(this).println("Gigabit Switch " + this.gbIndex + " is not presented");
                this.statusCode = 151;
                return;
            }
            if (this.ipMode != 0) {
                try {
                    boolean result = this.ipmiCMMOEMCommand.setGBIPMode(this.gbIndex, this.ipMode);
                    boolean result2 = this.ipmiCMMOEMCommand.setGBCommit(this.gbIndex);
                    if (result & result2) {
                        MOut.G(this).println("Done");
                        this.statusCode = 0;
                        break block7;
                    }
                    MOut.G(this).println("Failed");
                    this.statusCode = 149;
                }
                catch (IPMIException ex) {
                    MOut.G(this).println("Set GB IP Mode failed");
                    this.statusCode = 149;
                }
            } else {
                this.showIPMode();
            }
        }
    }

    private void showIPMode() {
        try {
            byte ipMode = this.ipmiCMMOEMCommand.getGBIPMode(this.gbIndex);
            switch (ipMode) {
                case 1: {
                    MOut.G(this).println("Static IP");
                    break;
                }
                case 2: {
                    MOut.G(this).println("DHCP");
                    break;
                }
                default: {
                    MOut.G(this).println("Unknown IP Mode");
                    break;
                }
            }
        }
        catch (IPMIException ex) {
            MOut.G(this).println(ex.getMessage());
            this.statusCode = 149;
        }
    }
}

