/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIBMCFileCommand;
import com.supermicro.ipmi.IPMIChassisCommand;
import com.supermicro.ipmi.IPMIException;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.ShellStatusException;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class OOBRebootCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMIBMCFileCommand powerStatusInfo = new IPMIBMCFileCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        IPMIChassisCommand ipmiChassisCommand = new IPMIChassisCommand(this.ipmiCMMOEMCommand.getIPMIInterface());
        int softShutdownWaitingSecs = 300;
        int detectServerPowerUpSecs = 60;
        int count = 0;
        MOut.G(this).println("");
        MOut.G(this).println("====================================");
        MOut.G(this).println("Reboot & check system power status");
        MOut.G(this).println("====================================");
        try {
            if (powerStatusInfo.getPowerStatus() == 1) {
                ipmiChassisCommand.softShutdown();
                MOut.G(this).println("Going to shutdown the system softly");
                MOut.G(this).println("Wait " + softShutdownWaitingSecs + " seconds for soft shutdown. If the system does not respond, it will be forced to restart automatically.");
                while (count++ != softShutdownWaitingSecs && (count <= 10 || powerStatusInfo.getPowerStatus() != 0)) {
                    if (count % 60 == 0) {
                        if (count != softShutdownWaitingSecs) {
                            MOut.G(this).println();
                            MOut.G(this).println("Going to shutdown the system softly");
                            ipmiChassisCommand.softShutdown();
                        }
                    } else {
                        MOut.G(this).print(".");
                    }
                    Thread.sleep(1000L);
                }
                MOut.G(this).println("");
            }
            if (powerStatusInfo.getPowerStatus() == 0) {
                ipmiChassisCommand.powerUp();
                MOut.G(this).println("Going to power up the system");
            } else {
                MOut.G(this).println("\nGoing to force shutdown the system");
                ipmiChassisCommand.powerDown();
                Thread.sleep(2000L);
                int i = 0;
                MOut.G(this).print("Detecting system power status");
                while (powerStatusInfo.getPowerStatus() == 1) {
                    if (i < 10) {
                        Thread.sleep(1000L);
                        ++i;
                        continue;
                    }
                    this.statusCode = 149;
                    throw new Exception("Can not shut down this system");
                }
                MOut.G(this).println("\nSystem power status: off");
                Thread.sleep(2000L);
                MOut.G(this).print("\nGoing to power up the system");
                ipmiChassisCommand.powerUp();
            }
            MOut.G(this).println("");
            MOut.G(this).print("Detecting system power status");
            count = 0;
            while (powerStatusInfo.getPowerStatus() == 0) {
                if (count++ == detectServerPowerUpSecs) {
                    this.statusCode = 149;
                    throw new Exception("Can not turn on this system\nDetect system power status timeout");
                }
                MOut.G(this).print(".");
                Thread.sleep(1000L);
            }
            MOut.G(this).println("");
            MOut.G(this).println("System power status: on");
            this.statusCode = 0;
        }
        catch (IPMIException ie) {
            throw new ShellStatusException("\nNetwork connect failed after retry connect\nCan't connect to " + this.config.getIp(), 145);
        }
    }
}

