/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.ByteUtility;
import com.supermicro.ipmi.GlobalDefine;
import com.supermicro.ipmi.IPMIOEMCommand;
import com.supermicro.ipmi.IPMISDRCommand;
import com.supermicro.ipmi.IPMISELCommand;
import com.supermicro.ipmi.SDRInfo;
import com.supermicro.ipmi.SDRRecord;
import com.supermicro.ipmi.SELInfo;
import com.supermicro.ipmi.SELRecord;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.SuperBladeCommand;
import java.util.ArrayList;

public class SELListCommand
extends SuperBladeCommand {
    @Override
    public void runCommand() throws Exception {
        IPMISELCommand ipmiSELCommand = new IPMISELCommand(null);
        IPMISDRCommand ipmiSDRCommand = new IPMISDRCommand(null);
        IPMIOEMCommand ipmiOEMCommand = new IPMIOEMCommand(null);
        ipmiSELCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiSDRCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        ipmiOEMCommand.setIPMIInterface(this.ipmiCMMOEMCommand.getIPMIInterface());
        byte[] productID = ipmiOEMCommand.getProductID();
        if (productID == null) {
            productID = new byte[2];
        }
        MOut.G(this).println("Getting SDR records ...");
        SDRInfo sdrInfo = ipmiSDRCommand.getSDRRepositoryInfoModal();
        ipmiSDRCommand.getSDRs(sdrInfo.getRecordCount());
        SELInfo selInfo = ipmiSELCommand.getSELInfoModal();
        MOut.G(this).println("Getting SEL records ...");
        ArrayList list = ipmiSELCommand.getSELEntries(selInfo.getLogEntries());
        int count = 0;
        if (list.size() != 0) {
            for (SELRecord item : list) {
                ArrayList raw = new ArrayList();
                MOut.G(this).println("------------------------------------------------------------------");
                MOut.G(this).print("Event:" + (count + 1));
                MOut.G(this).print(" Time:" + ByteUtility.fourByteToDate(item.getTimeStamp()));
                MOut.G(this).println(" Type:" + GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                if (this.parameters != null && this.parameters.length >= 1 && this.parameters[0].equals("-v")) {
                    System.out.println(item.toString());
                }
                if ((item.getSensorType() & 0xFF) >= 193 && (item.getSensorType() & 0xFF) <= 197) {
                    if (item.getEventData1() == -64 || item.getEventData1() == -63 || item.getEventData1() == -62 || item.getEventData1() == -61) {
                        MOut.G(this).print(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()) + " " + (byte)(item.getSensorNumber() & 0xFF));
                    } else {
                        MOut.G(this).print(GlobalDefine.getSensorType(item.getSensorType() & 0xFF, item.getEventData1()));
                    }
                } else {
                    Object sensorName = SDRRecord.sensorNumberToSensorName.get("" + (item.getSensorNumber() & 0xFF));
                    if (sensorName != null) {
                        MOut.G(this).print(sensorName.toString());
                    } else {
                        MOut.G(this).print("");
                    }
                }
                String reading = "";
                if (item.getEventType() == 1) {
                    byte offset = item.getEventData1();
                    SDRRecord sdrRecord = (SDRRecord)SDRRecord.sensorNumberToSDRRecord.get("" + (item.getSensorNumber() & 0xFF));
                    if (sdrRecord != null) {
                        double readingValue = sdrRecord.calSensorReading(item.getEventData2() & 0xFF);
                        double threshold = sdrRecord.calSensorReading(item.getEventData3() & 0xFF);
                        if (item.getSensorType() == 4) {
                            reading = reading + "\nReading = " + (int)readingValue + " RPM, Threshold = " + (int)threshold + " RPM";
                        } else if (item.getSensorType() == 2) {
                            reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " V, Threshold = " + String.format("%3.2f", threshold) + " V";
                        } else if (item.getSensorType() == 1) {
                            reading = reading + "\nReading = " + String.format("%3.2f", readingValue) + " C, Threshold = " + String.format("%3.2f", threshold) + " C";
                        }
                    }
                }
                MOut.G(this).println("  " + GlobalDefine.getEventType((byte)(item.getEventDir() | item.getEventType()), item.getSensorType(), item.getEventData1(), item.getEventData2(), item.getEventData3(), productID) + reading);
                ++count;
            }
        } else {
            MOut.G(this).println("SEL empty");
        }
        this.statusCode = 0;
    }
}

