/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text;

import com.supermicro.ipmi.IPMIMessagingCommand;
import com.supermicro.ipmi.text.Command;
import com.supermicro.ipmi.text.MOut;
import com.supermicro.ipmi.text.Parser;
import com.supermicro.ipmi.text.SuperBladeCommand;

public class UKVMCommand
extends SuperBladeCommand {
    Parser parser;
    String[] subArgs;
    Command command;

    public UKVMCommand() {
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    @Override
    public void runCommand() throws Exception {
        boolean result = false;
        byte[] guid = IPMIMessagingCommand.getSystemGUIDByIP(this.config.getIp());
        if (guid == null) {
            MOut.G(this).println("Unknown KVM type");
            this.statusCode = 149;
            return;
        }
        if (IPMIMessagingCommand.isAMIAddOnGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIOnBoardGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMISIMBLGUID(guid)) {
            this.runAMIKVM();
        } else if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
            this.runAMIX9KVM();
        } else if (IPMIMessagingCommand.isATENGUID(guid)) {
            this.runATENKVM();
        } else if (IPMIMessagingCommand.isCMMGUID(guid)) {
            this.runPepperconKVM();
        } else if (IPMIMessagingCommand.isNormalBladeCMMGUID(guid)) {
            this.runPepperconKVM();
        } else if (IPMIMessagingCommand.isOfficeBladeCMMGUID(guid)) {
            this.runPepperconKVM();
        } else {
            if (IPMIMessagingCommand.isOSAGUID(guid)) {
                MOut.G(this).println("Unsupported KVM type");
                this.statusCode = 149;
                return;
            }
            if (IPMIMessagingCommand.isPepperconGUID(guid)) {
                this.runPepperconKVM();
            } else {
                if (IPMIMessagingCommand.isPepperconNoneKVMGUID(guid)) {
                    MOut.G(this).println("Unsupported KVM type");
                    this.statusCode = 149;
                    return;
                }
                if (IPMIMessagingCommand.isSIMBL(guid)) {
                    this.runPepperconKVM();
                } else if (IPMIMessagingCommand.isTwinBladeCMMGUID(guid)) {
                    this.runPepperconKVM();
                } else if (IPMIMessagingCommand.isAMIX9GUID(guid)) {
                    this.runAMIX9KVM();
                } else if (IPMIMessagingCommand.isATENAspeedGUID(guid)) {
                    this.runATENKVM();
                } else if (IPMIMessagingCommand.isAMIAspeedGUID(guid)) {
                    this.runAMIX9KVM();
                }
            }
        }
    }

    public void runPepperconKVM() {
        this.subArgs = new String[]{"kvm"};
        this.runKVM();
    }

    public void runAMIKVM() {
        this.subArgs = new String[]{"kvmw"};
        this.runKVM();
    }

    public void runAMIX9KVM() {
        this.subArgs = new String[]{"kvmwx9"};
        this.runKVM();
    }

    public void runATENKVM() {
        this.subArgs = new String[]{"kvmwa"};
        this.runKVM();
    }

    public void runKVM() {
        this.parser = new Parser();
        this.command = this.parser.parse(this.parser.argumentRoot, this.subArgs);
        this.command.setConfig(this.config);
        try {
            this.command.execute();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

