/*
 * Decompiled with CFR 0.152.
 */
package com.supermicro.ipmi.text.plug;

import com.supermicro.ipmi.ConfigAccessor;
import com.supermicro.ipmi.IPMINetworkInterface;
import com.supermicro.ipmi.IPMIPayloadCommand;
import com.supermicro.ipmi.IPMISOLCommand;
import com.supermicro.ipmi.ISessionController;
import com.supermicro.ipmi.SOLSessionController;
import com.supermicro.ipmi.SessionControllerFactory;
import com.supermicro.ipmi.sol.SOLFrameForSuperBladeTool;
import com.supermicro.ipmi.sol.SOLPacketSender;
import com.supermicro.ipmi.sol.Storage;
import com.supermicro.ipmi.text.CommandPlugIn;
import com.supermicro.ipmi.text.MOut;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import jcurses.system.InputChar;

public class SOLCommand
extends CommandPlugIn
implements Observer {
    Storage storage;
    SOLSessionController solSessionController;
    SOLPacketSender solPacketSender;
    HashMap javaKeyCodeToSOLKeyCode = new HashMap();
    boolean isLinux = false;
    SOLFrameForSuperBladeTool solFrame = null;

    public SOLCommand() {
        this.configSOLKeyMapping();
        this.isSupportBackgroundModeForTaskRunCommand = false;
    }

    private void setDefaultKeyMapping() {
        this.javaKeyCodeToSOLKeyCode.clear();
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_UP, new byte[]{27, 91, 65});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DOWN, new byte[]{27, 91, 66});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_LEFT, new byte[]{27, 91, 68});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_RIGHT, new byte[]{27, 91, 67});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F1, new byte[]{27, 79, 80, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F2, new byte[]{27, 79, 81, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F3, new byte[]{27, 79, 82, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F4, new byte[]{27, 79, 83, 0, 0, 0});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F5, new byte[]{27, 53});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F6, new byte[]{27, 54});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F7, new byte[]{27, 55});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F8, new byte[]{27, 56});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F9, new byte[]{27, 57});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F10, new byte[]{27, 48});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F11, new byte[]{27, 33});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F12, new byte[]{27, 64});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_IC, new byte[]{27, 43});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DC, new byte[]{27, 45});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_HOME, new byte[]{27, 104});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_END, new byte[]{27, 107});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_NPAGE, new byte[]{27, 63});
        this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_PPAGE, new byte[]{27, 47});
        this.javaKeyCodeToSOLKeyCode.put("10", new byte[]{13});
        this.javaKeyCodeToSOLKeyCode.put("263", new byte[]{8});
    }

    public void setKeyMapping() {
        if (this.isLinux) {
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F1, new byte[]{27, 49});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F2, new byte[]{27, 91, 49, 50, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F3, new byte[]{27, 91, 49, 51, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F4, new byte[]{27, 91, 49, 52, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_IC, new byte[]{27, 91, 50, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DC, new byte[]{27, 91, 51, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_HOME, new byte[]{27, 91, 49, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_END, new byte[]{27, 91, 52, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_PPAGE, new byte[]{27, 91, 53, 126});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_NPAGE, new byte[]{27, 91, 54, 126});
        } else {
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F1, new byte[]{27, 79, 80, 0, 0, 0});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F2, new byte[]{27, 79, 81, 0, 0, 0});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F3, new byte[]{27, 79, 82, 0, 0, 0});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_F4, new byte[]{27, 79, 83, 0, 0, 0});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_IC, new byte[]{27, 43});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_DC, new byte[]{27, 45});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_HOME, new byte[]{27, 104});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_END, new byte[]{27, 107});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_NPAGE, new byte[]{27, 63});
            this.javaKeyCodeToSOLKeyCode.put("" + InputChar.KEY_PPAGE, new byte[]{27, 47});
        }
    }

    private void configSOLKeyMapping() {
        ConfigAccessor ca = new ConfigAccessor(".", "SMCIPMITool.properties");
        String isLinuxKey = ca.getProperty("sol_key_linux");
        if (isLinuxKey != null && isLinuxKey.equalsIgnoreCase("yes")) {
            this.isLinux = true;
        }
    }

    @Override
    public String[] getSubCommandsForTabCompletion() {
        return new String[]{"activate", "deactivate", "window", "key", "bitrate"};
    }

    @Override
    public void execute() {
        if (this.parameters == null || this.parameters.length == 0) {
            this.usage();
            return;
        }
        String para1 = this.parameters[0];
        if (para1.equalsIgnoreCase("activate")) {
            this.activateSOL();
        } else if (para1.equalsIgnoreCase("deactivate")) {
            this.deactivateSOL();
        } else if (para1.equalsIgnoreCase("bitrate")) {
            this.bitrate();
        } else if (para1.equalsIgnoreCase("key")) {
            this.key();
        } else if (para1.equalsIgnoreCase("window")) {
            this.activateSOLWindow();
        } else {
            this.usage();
        }
    }

    public void usage() {
        MOut.G().printf("Available commands:\n", new Object[0]);
        MOut.G().printf("%-35s\t%-20s\n", "sol activate", "Activate SOL (Press F12 to exit)");
        MOut.G().printf("%-35s\t%-20s\n", "sol deactivate", "Deactivate SOL");
        MOut.G().printf("%-35s\t%-20s\n", "sol window", "Open SOL window GUI and activate SOL");
        MOut.G().printf("%-35s\t%-20s\n", "sol key [linux|windows]", "Key mapping for linux or windows");
        MOut.G().printf("%-35s\t%-20s\n", "sol bitrate [9.6|19.2|38.4|57.6|115.2]", "Configure SOL bit rate");
    }

    private void activateSOLWindow() {
        boolean result = GraphicsEnvironment.isHeadless();
        if (result) {
            MOut.G().print("No graphic environment here !");
            return;
        }
        if (!this.getOriginalParser().shellMode) {
            MOut.G().print("Not supported in command mode");
            return;
        }
        try {
            this.solFrame = new SOLFrameForSuperBladeTool();
            this.solFrame.setIP(this.config.getIp());
            this.solFrame.setPassword(this.config.getPassword());
            this.solFrame.setUsername(this.config.getUserName());
            this.solFrame.removeToolBar();
            this.solFrame.startSOLNoThread();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.solFrame.getSize();
            if (frameSize.height > screenSize.height) {
                frameSize.height = screenSize.height;
            }
            if (frameSize.width > screenSize.width) {
                frameSize.width = screenSize.width;
            }
            this.solFrame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
            this.solFrame.setVisible(true);
            MOut.G().println("SOL Window Started");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void activateSOL() {
        this.solSessionController = new SOLSessionController();
        this.storage = new Storage();
        IPMINetworkInterface ipmiInterface = this.solSessionController.startup(this.config);
        if (this.solSessionController.isSOLActivated) {
            MOut.G().println("SOL start OK. Press F12 to exit");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            jcurses.system.Toolkit.init();
            this.setDefaultKeyMapping();
            this.setKeyMapping();
            this.storage.reset();
            this.solPacketSender = new SOLPacketSender(this.storage, this.solSessionController);
            this.solPacketSender.start();
            ipmiInterface.addObserver(this.solSessionController);
            ipmiInterface.addObserver(this);
            this.clearScreen();
            this.getInput();
            return;
        }
        MOut.G().println("SOL start failed. Please try \"sol deactivate\" if SOL session was occupied");
        if (ipmiInterface != null) {
            this.solSessionController.closeSession();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof byte[]) {
            byte[] screenData = (byte[])arg;
            System.out.print(new String(screenData));
        }
    }

    public void getInput() {
        while (true) {
            InputChar c;
            if ((c = jcurses.system.Toolkit.readCharacter()).getCode() == InputChar.KEY_F12) {
                if (this.solSessionController == null) break;
                jcurses.system.Toolkit.shutdown();
                this.solSessionController.closeSession();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {}
                break;
            }
            byte[] keycode = (byte[])this.javaKeyCodeToSOLKeyCode.get("" + c.getCode());
            if (keycode != null) {
                this.storage.puts(keycode);
                continue;
            }
            this.storage.put((byte)c.getCode());
        }
    }

    public void clearScreen() {
        System.out.print('\u001b');
        System.out.println("[2J");
    }

    private void deactivateSOL() {
        IPMIPayloadCommand ipmiPayloadCommand = new IPMIPayloadCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiPayloadCommand);
        if (sessionController == null) {
            MOut.G().println("cannot establish connection !");
            return;
        }
        boolean result = ipmiPayloadCommand.deactivateSOLPayload();
        if (result) {
            MOut.G().println("Done");
        } else {
            MOut.G().println("Failed");
        }
    }

    private void bitrate() {
        if (this.parameters.length == 1) {
            this.showSOLBitRate();
            return;
        }
        String para2 = this.parameters[1];
        if (para2.equals("9.6")) {
            this.setSOLBitRate((byte)6);
        } else if (para2.equals("19.2")) {
            this.setSOLBitRate((byte)7);
        } else if (para2.equals("38.4")) {
            this.setSOLBitRate((byte)8);
        } else if (para2.equals("57.6")) {
            this.setSOLBitRate((byte)9);
        } else if (para2.equals("115.2")) {
            this.setSOLBitRate((byte)10);
        } else {
            this.showSOLBitRate();
        }
    }

    private void showSOLBitRate() {
        IPMISOLCommand ipmiSOLCommand = new IPMISOLCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiSOLCommand);
        if (sessionController == null) {
            MOut.G().println("cannot establish connection !");
            return;
        }
        byte bitRate = ipmiSOLCommand.getSOLBitRateVolatile();
        switch (bitRate) {
            case 6: {
                MOut.G().println("9.6 kbps");
                break;
            }
            case 7: {
                MOut.G().println("19.2 kbps");
                break;
            }
            case 8: {
                MOut.G().println("38.4 kbps");
                break;
            }
            case 9: {
                MOut.G().println("57.6 kbps");
                break;
            }
            case 10: {
                MOut.G().println("115.2 kbps");
                break;
            }
            default: {
                MOut.G().println("Unknown bitrate");
            }
        }
    }

    private void key() {
        if (this.parameters.length == 1) {
            this.printKey();
            return;
        }
        String para2 = this.parameters[1];
        if (para2.equalsIgnoreCase("linux")) {
            this.isLinux = true;
        } else if (para2.equalsIgnoreCase("windows")) {
            this.isLinux = false;
        }
        MOut.G().print("Done");
    }

    private void printKey() {
        if (this.isLinux) {
            MOut.G().println("linux");
        } else {
            MOut.G().println("windows");
        }
    }

    private void setSOLBitRate(byte bitRate) {
        IPMISOLCommand ipmiSOLCommand = new IPMISOLCommand(null);
        ISessionController sessionController = SessionControllerFactory.createSessionController(this.config, ipmiSOLCommand);
        if (sessionController == null) {
            MOut.G().println("cannot establish connection !");
        }
        boolean b1 = ipmiSOLCommand.setSOLBitRateNonVolatile(bitRate);
        boolean b2 = ipmiSOLCommand.setSOLBitRateVolatile(bitRate);
        if (b1 && b2) {
            MOut.G().println("Done");
        } else {
            MOut.G().println("Failed");
        }
    }

    @Override
    public String getAlternateValue() {
        return null;
    }

    @Override
    public String getComment() {
        return "SOL Commands";
    }

    @Override
    public String getName() {
        return "sol";
    }

    @Override
    public String getValue() {
        return "sol";
    }

    @Override
    public boolean isSupportCLIMode() {
        return true;
    }

    @Override
    public boolean isSupportShellMode() {
        return true;
    }
}

