/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm;

import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tw.com.aten.bean.ConnInfo;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.bean.UserInfo;
import tw.com.aten.ikvm.bean.KVMInfoRepository;
import tw.com.aten.ikvm.jni.RMConnection;
import tw.com.aten.ikvm.ui.Viewer;
import tw.com.aten.ikvm.util.Converter;

public class KVMMain
implements Runnable {
    private InfoRepository infoRepository;

    static {
        String nativeLF = UIManager.getSystemLookAndFeelClassName();
        String osArch = System.getProperty("os.arch");
        try {
            if (osArch.indexOf("64") != -1) {
                System.loadLibrary("iKVM".concat("64"));
                System.loadLibrary("SharedLibrary".concat("64"));
            } else {
                System.loadLibrary("iKVM".concat("32"));
                System.loadLibrary("SharedLibrary".concat("32"));
            }
            RMConnection.init(ConnInfo.class, UserInfo.class);
        }
        catch (UnsatisfiedLinkError ule) {
            JOptionPane.showMessageDialog(null, ule.getLocalizedMessage(), "Error", 0);
            System.exit(1);
        }
    }

    public KVMMain(String[] args) {
        String ip = Converter.toIP(args[0]);
        String userName = args[1];
        String passwd = args[2];
        String hostName = args[3];
        String port = args[4];
        String vm_port = args.length > 5 ? args[5] : "623";
        int companyId = args.length > 6 ? Integer.parseInt(args[6]) : 0;
        int boardId = args.length > 7 ? Integer.parseInt(args[7]) : 0;
        String lang = args.length > 8 ? args[8] : "ENG";
        this.infoRepository = new InfoRepository();
        this.infoRepository.getConnInfo().setIp(ip);
        this.infoRepository.getConnInfo().setPort(Integer.parseInt(port));
        this.infoRepository.getConnInfo().setHostName(hostName);
        this.infoRepository.getUserInfo().setUserName(userName);
        this.infoRepository.getUserInfo().setPassword(passwd);
        this.infoRepository.getUserInfo().setLanguage(lang);
        this.infoRepository.getVirtualUsbInfo().setPort(Integer.parseInt(vm_port));
        this.infoRepository.getPlatformInfo().setCompanyId(companyId);
        this.infoRepository.getPlatformInfo().setBoardId(boardId);
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            JOptionPane.showMessageDialog(null, "Usage: IP USER_NAME PASSWORD PORT", "Error", 0);
            return;
        }
        KVMMain main = new KVMMain(args);
        SwingUtilities.invokeLater(main);
    }

    @Override
    public void run() {
        if (!RMConnection.keepActive(this.infoRepository.getConnInfo())) {
            String msg = "Connection failed";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        } else if (!RMConnection.checkValidUser(this.infoRepository.getUserInfo())) {
            String msg = "Authentication failed";
            JOptionPane.showMessageDialog(null, msg, "Error", 0);
        } else {
            KVMInfoRepository repository = new KVMInfoRepository();
            System.setProperty("sun.java2d.opengl", "true");
            new Viewer(this.infoRepository, repository);
        }
    }
}

