/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.im.InputContext;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import tw.com.aten.bean.InfoRepository;
import tw.com.aten.ikvm.bean.KVMInfoRepository;
import tw.com.aten.ikvm.bean.MouseMode;
import tw.com.aten.ikvm.ui.RemoteVideo;

public class Viewer
extends JFrame
implements WindowListener,
FocusListener,
ActionListener {
    public static final String RESOURCE_BUNDLE_NAME = "tw.com.aten.ikvm.impl.huawei.bundle.MainFrameStrings";
    private InfoRepository infoRepository;
    private KVMInfoRepository kvmInfoRepository;
    public JScrollPane scrollPane;
    private RemoteVideo remoteVideo;
    public JMenuBar menuBar;
    public JMenu menuSetHotKey;
    public JMenu menuVDevice;
    public JMenu menuOption;
    public JMenu menuExit;
    public JMenu menuScale;
    public JMenu menuPrivilege;
    public JMenu menuRecording;
    public JMenu menuActionMacro;
    public JMenu menuCapture;
    public JMenu virtualDevMenu;
    private JMenuItem virtualMediaMenuItem;
    private JMenuItem virtualKeyboardMenuItem;
    public JMenu virtualKeyMenu;
    public JMenuItem holdRightAltMenuItem;
    public JMenuItem holdLeftAltMenuItem;
    public JMenuItem holdWindowsMenuItem;
    private JMenuItem windowsMenuItem;
    private JMenuItem ctrlAltDelMenuItem;
    private JMenuItem altEnterMenuItem;
    private JMenuItem altTabMenuItem;
    private JMenuItem altEscMenuItem;
    public JMenu viewMenu;
    private JMenuItem captureScreenMenuItem;
    public JMenuItem recordVideoMenuItem;
    private JMenuItem fullScreenModeMenuItem;
    public JMenuItem fitWindowNowMenuItem;
    public JMenu optionsMenu;
    private JMenuItem preferenceMenuItem;
    public JMenu languageMenu;
    public JMenuItem englishMenuItem;
    public JMenuItem chineseMenuItem;
    private ButtonGroup languageButtonGroup;
    public JMenuItem absoluteMouseMenuItem;
    public JMenuItem relativeMouseMenuItem;
    public JMenuItem singleMouseMenuItem;
    private ButtonGroup mouseButtonGroup;
    private JMenuItem keyboardMouseHotplugMenuItem;

    public Viewer(InfoRepository infoRepository, KVMInfoRepository kvmInfoRepository) {
        super("Java Viewer");
        this.infoRepository = infoRepository;
        this.kvmInfoRepository = kvmInfoRepository;
        this.menuBar = new JMenuBar();
        this.menuBar.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent ce) {
                if (Viewer.this.remoteVideo != null && ((Viewer)Viewer.this).remoteVideo.adjustSize) {
                    Viewer.this.remoteVideo.adjustSize();
                }
            }

            @Override
            public void componentMoved(ComponentEvent ce) {
            }

            @Override
            public void componentResized(ComponentEvent ce) {
            }

            @Override
            public void componentShown(ComponentEvent ce) {
                if (Viewer.this.remoteVideo != null && ((Viewer)Viewer.this).remoteVideo.adjustSize) {
                    Viewer.this.remoteVideo.adjustSize();
                }
            }
        });
        this.menuSetHotKey = new JMenu(" Set Hotkey ");
        this.menuVDevice = new JMenu(" Virtual Media ");
        this.menuRecording = new JMenu(" Record ");
        this.menuActionMacro = new JMenu(" Macro ");
        this.menuOption = new JMenu(" Options ");
        this.menuScale = new JMenu(" Scale ");
        this.menuExit = new JMenu(" Exit ");
        this.menuPrivilege = new JMenu(" User List ");
        this.menuCapture = new JMenu(" Capture ");
        this.menuBar.add(this.menuVDevice);
        this.menuBar.add(this.menuRecording);
        this.menuBar.add(this.menuActionMacro);
        this.menuBar.add(this.menuOption);
        this.menuBar.add(this.menuPrivilege);
        this.menuBar.add(this.menuCapture);
        this.menuBar.add(this.menuExit);
        this.remoteVideo = new RemoteVideo(this, this.infoRepository, this.kvmInfoRepository);
        this.remoteVideo.setBackground(Color.WHITE);
        this.scrollPane = new JScrollPane(this.remoteVideo, 20, 30);
        String lang = infoRepository.getUserInfo().getLanguage();
        if (lang.equals("CHN")) {
            Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
        } else {
            Locale.setDefault(Locale.ENGLISH);
        }
        this.add(this.scrollPane);
        this.setResizable(!kvmInfoRepository.getOptinoInfo().isAutoResizeWindow());
        this.setSize(640, 480);
        this.getRootPane().setFocusable(false);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(this);
        this.remoteVideo.addFocusListener(this);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.remoteVideo.go();
        this.remoteVideo.syncMouse();
    }

    @Override
    public InputContext getInputContext() {
        InputContext ic = InputContext.getInstance();
        ic.selectInputMethod(this.kvmInfoRepository.getOptinoInfo().getKbLayout());
        return ic;
    }

    public RemoteVideo getVideoPane() {
        return this.remoteVideo;
    }

    public void reloadText() {
    }

    @Override
    public void windowActivated(WindowEvent we) {
        this.remoteVideo.doCatch(1);
        this.remoteVideo.requestFocusInWindow();
    }

    @Override
    public void windowClosed(WindowEvent we) {
    }

    @Override
    public void windowClosing(WindowEvent we) {
        this.remoteVideo.closeRemoteVideo();
    }

    @Override
    public void windowDeactivated(WindowEvent we) {
        this.remoteVideo.doCatch(0);
    }

    @Override
    public void windowDeiconified(WindowEvent we) {
        if (this.remoteVideo.vs != null) {
            this.remoteVideo.vs.setExtendedState(0);
        }
        if (this.remoteVideo.hotKeyDialog != null) {
            this.remoteVideo.hotKeyDialog.setExtendedState(0);
        }
        if (this.remoteVideo.optionDialog != null) {
            this.remoteVideo.optionDialog.setExtendedState(0);
        }
        if (this.remoteVideo.kb != null) {
            this.remoteVideo.kb.setExtendedState(0);
        }
        if (RemoteVideo.userListDialog != null) {
            RemoteVideo.userListDialog.setExtendedState(0);
        }
    }

    @Override
    public void windowIconified(WindowEvent we) {
        if (this.remoteVideo.vs != null) {
            this.remoteVideo.vs.setExtendedState(1);
        }
        if (this.remoteVideo.hotKeyDialog != null) {
            this.remoteVideo.hotKeyDialog.setExtendedState(1);
        }
        if (this.remoteVideo.optionDialog != null) {
            this.remoteVideo.optionDialog.setExtendedState(1);
        }
        if (this.remoteVideo.kb != null) {
            this.remoteVideo.kb.setExtendedState(1);
        }
        if (RemoteVideo.userListDialog != null) {
            RemoteVideo.userListDialog.setExtendedState(1);
        }
    }

    @Override
    public void windowOpened(WindowEvent we) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object evtSrc = ae.getSource();
        if (evtSrc == this.englishMenuItem) {
            this.remoteVideo.SetUILanguage(null, 0);
            Locale.setDefault(Locale.ENGLISH);
            this.reloadText();
        } else if (evtSrc == this.chineseMenuItem) {
            this.remoteVideo.SetUILanguage(null, 7);
            Locale.setDefault(Locale.SIMPLIFIED_CHINESE);
            this.reloadText();
        } else if (evtSrc == this.absoluteMouseMenuItem) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Viewer.this.remoteVideo.changeMouseMode(MouseMode.ABSOLUTE);
                }
            });
            t.start();
        } else if (evtSrc == this.relativeMouseMenuItem) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Viewer.this.remoteVideo.changeMouseMode(MouseMode.NORMAL);
                }
            });
            t.start();
        } else if (evtSrc == this.singleMouseMenuItem) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    Viewer.this.remoteVideo.changeMouseMode(MouseMode.SINGLE);
                }
            });
            t.start();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.remoteVideo.setLEDstatus();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.remoteVideo.keyboardled = this.remoteVideo.getLEDstatus();
        this.remoteVideo.CheckAndReleaseSingleMouse();
        this.remoteVideo.releasePressedKeys();
    }
}

