/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.util;

import ch.randelshofer.media.avi.AVIOutputStream;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class VideoRecorder
extends TimerTask {
    private static final AVIOutputStream.VideoFormat DEFAULT_FORMAT = AVIOutputStream.VideoFormat.JPG;
    private final Timer recordTimer;
    private final File file;
    private BufferedImage dataSource;
    private final BufferedImage scaledImage;
    private final int fps;
    private final int videoWidth;
    private final int videoHeight;
    private final AVIOutputStream out;
    private final AffineTransform affineTransform;
    private final RenderingHints hints;
    private final AffineTransformOp affineTransformOp;

    public VideoRecorder(File file, BufferedImage dataSource, int fps, int videoWidth, int videoHeight) throws IOException {
        this.file = file;
        this.dataSource = dataSource;
        this.scaledImage = new BufferedImage(videoWidth, videoHeight, 1);
        this.fps = fps;
        this.videoWidth = videoWidth;
        this.videoHeight = videoHeight;
        this.out = new AVIOutputStream(file, DEFAULT_FORMAT);
        this.out.setVideoDimension(videoWidth, videoHeight);
        this.out.setFrameRate(fps);
        this.recordTimer = new Timer();
        this.affineTransform = new AffineTransform();
        this.hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.affineTransformOp = new AffineTransformOp(this.affineTransform, this.hints);
    }

    public void start() {
        this.recordTimer.scheduleAtFixedRate((TimerTask)this, 0L, (long)(1000 / this.fps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.recordTimer.cancel();
        try {
            AVIOutputStream aVIOutputStream = this.out;
            synchronized (aVIOutputStream) {
                this.out.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setDataSource(BufferedImage dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Graphics2D g2d = this.scaledImage.createGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.drawImage(this.dataSource, 0, 0, this.videoWidth, this.videoHeight, null);
            g2d.dispose();
            g2d = this.out;
            synchronized (g2d) {
                this.out.writeFrame(this.scaledImage);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

