/*
 * Decompiled with CFR 0.152.
 */
package tw.com.aten.ikvm.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZipFile {
    public static boolean compressFileTo(String src, String dst) throws IOException {
        int length;
        int sChunk = 8192;
        byte[] buffer = new byte[sChunk];
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        FileLock lock = out.getChannel().lock();
        GZIPOutputStream zipout = new GZIPOutputStream(out);
        while ((length = in.read(buffer, 0, sChunk)) != -1) {
            zipout.write(buffer, 0, length);
        }
        lock.release();
        in.close();
        zipout.close();
        return true;
    }

    public static boolean decompressFileTo(String src, String dst) throws IOException {
        int length;
        int sChunk = 8192;
        byte[] buffer = new byte[sChunk];
        FileInputStream in = new FileInputStream(src);
        GZIPInputStream zipin = new GZIPInputStream(in);
        FileOutputStream out = new FileOutputStream(dst);
        while ((length = zipin.read(buffer, 0, sChunk)) != -1) {
            out.write(buffer, 0, length);
        }
        out.close();
        zipin.close();
        return true;
    }
}

